/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.DataFormatException;
import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.ZipException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private byte[] onebytebuffer = new byte[1];

    public InflaterInputStream(InputStream in) {
        this(in, new Inflater(), 4096);
    }

    public InflaterInputStream(InputStream in, Inflater inf) {
        this(in, inf, 4096);
    }

    public InflaterInputStream(InputStream in, Inflater inf, int size) {
        super(in);
        this.inf = inf;
        this.len = 0;
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[size];
    }

    @Override
    public int available() throws IOException {
        return this.inf.finished() ? 0 : 1;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    protected void fill() throws IOException {
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len < 0) {
            throw new ZipException("Deflated stream ends early.");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    @Override
    public int read() throws IOException {
        int nread = this.read(this.onebytebuffer, 0, 1);
        if (nread > 0) {
            return this.onebytebuffer[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (true) {
            int count;
            try {
                count = this.inf.inflate(b, off, len);
            }
            catch (DataFormatException dfe) {
                throw new ZipException(dfe.getMessage());
            }
            if (count > 0) {
                return count;
            }
            if (this.inf.needsDictionary()) {
                throw new ZipException("Need a dictionary");
            }
            if (this.inf.finished()) {
                return -1;
            }
            if (!this.inf.needsInput()) break;
            this.fill();
        }
        throw new InternalError("Don't know what to do");
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        int len = 2048;
        if (n < (long)len) {
            len = (int)n;
        }
        byte[] tmp = new byte[len];
        return this.read(tmp);
    }
}

