/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.Checksum;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum sum;

    public CheckedInputStream(InputStream in, Checksum sum) {
        super(in);
        this.sum = sum;
    }

    public Checksum getChecksum() {
        return this.sum;
    }

    @Override
    public int read() throws IOException {
        int x = this.in.read();
        if (x != -1) {
            this.sum.update(x);
        }
        return x;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int r = this.in.read(buf, off, len);
        if (r != -1) {
            this.sum.update(buf, off, r);
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        int r;
        if (n == 0L) {
            return 0L;
        }
        int min = (int)Math.min(n, 1024L);
        byte[] buf = new byte[min];
        long s = 0L;
        while (n > 0L && (r = this.in.read(buf, 0, min)) != -1) {
            s += (long)r;
            min = (int)Math.min(n -= (long)r, 1024L);
            this.sum.update(buf, 0, r);
        }
        return s;
    }
}

