/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.email;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.BASE64EncoderStream;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CMyEmail {
    private static Logger s_logger = Logger.getLogger(CMyEmail.class);
    public static final int FORMAT_HTML = 1;
    public static final int FORMAT_TEXT = 0;
    public static final String MAIL_SEPARATOR = "----TRS_Email_Maker";
    public static final String MAIL_HTML_SEPARATOR = "----TRS_Email_Maker";
    private static final String LR = "\r\n";
    private String m_sCharset = "GBK";
    private String m_sFrom;
    private String m_sReplyTo;
    private String m_sTo;
    private String m_sCc;
    private String m_sBcc;
    private String m_sSubject;
    private String m_sBody;
    private String m_sAttachFilename;
    private HashMap m_hAttachFileList;
    private int m_nMailFormat = 0;
    private boolean m_bMimeMail;
    private String m_sFromUser;

    public CMyEmail() {
        this.setMimeMail(true);
    }

    public void setFrom(String _sFrom) {
        this.m_sFrom = _sFrom;
    }

    public String getFrom() {
        return this.m_sFrom;
    }

    public void setFromUser(String _sUserName) {
        this.m_sFromUser = _sUserName;
    }

    public String getFromUser() {
        if (CMyString.isEmpty(this.m_sFromUser)) {
            return this.m_sFrom;
        }
        return this.m_sFromUser;
    }

    public void setReplyTo(String _sReplyTo) {
        this.m_sReplyTo = _sReplyTo;
    }

    public String getReplyTo() {
        return this.m_sReplyTo;
    }

    public void setTo(String _sTo) {
        this.m_sTo = _sTo;
    }

    public String getTo() {
        return this.m_sTo;
    }

    public void setCc(String _sCc) {
        this.m_sCc = _sCc;
    }

    public String getCc() {
        return this.m_sCc;
    }

    public void setBcc(String _sBcc) {
        this.m_sBcc = _sBcc;
    }

    public String getBcc() {
        return this.m_sBcc;
    }

    public void setSubject(String _sSubject) {
        this.m_sSubject = _sSubject;
    }

    public String getSubject() {
        return this.m_sSubject;
    }

    public void setBody(String _sBody) {
        this.m_sBody = _sBody;
    }

    public String getBody() {
        return this.m_sBody;
    }

    public void setAttachedFile(String _sAbsoluteFileName) {
        this.setAttachedFile(_sAbsoluteFileName, null);
    }

    public void setAttachedFile(String _sAbsoluteFileName, String _sSrcFileName) {
        if (_sAbsoluteFileName != null && _sAbsoluteFileName.length() > 0) {
            FileService attachFile = new FileService(_sAbsoluteFileName);
            if (attachFile.exists()) {
                this.m_sAttachFilename = attachFile.getPath();
                this.addAttachedFile(this.m_sAttachFilename, _sSrcFileName);
            } else {
                s_logger.error((Object)(I18NMessage.get(CMyEmail.class, "CMyEmail.label1", "\u9644\u4ef6\u6587\u4ef6[") + _sAbsoluteFileName + I18NMessage.get(CMyEmail.class, "CMyEmail.label2", "]\u4e0d\u5b58\u5728")));
            }
        } else {
            this.m_sAttachFilename = "";
        }
    }

    public String getAttachedFile() {
        return this.m_sAttachFilename;
    }

    public void addAttachedFile(String _sAbsoluteFileName) {
        this.addAttachedFile(_sAbsoluteFileName, null);
    }

    public void addAttachedFile(String _sAbsoluteFileName, String _sFileName) {
        if (CMyString.isEmpty(_sAbsoluteFileName) || !CMyFile.fileExists(_sAbsoluteFileName)) {
            return;
        }
        if (this.m_hAttachFileList == null) {
            this.m_hAttachFileList = new HashMap(3);
        }
        String sFileName = CMyString.isEmpty(_sFileName) ? CMyFile.extractFileName(_sAbsoluteFileName) : _sFileName;
        this.m_hAttachFileList.put(sFileName, _sAbsoluteFileName);
    }

    public HashMap getAttatchedFileList() {
        return this.m_hAttachFileList;
    }

    public void setMailFormat(int _iMailFormat) {
        this.m_nMailFormat = _iMailFormat;
    }

    public int getMailFormat() {
        return this.m_nMailFormat;
    }

    public void setMimeMail(boolean _bMimeMail) {
        this.m_bMimeMail = _bMimeMail;
    }

    public boolean getMimeMail() {
        return this.m_bMimeMail;
    }

    public String composeMail() {
        return this.makeMailData();
    }

    public String makeMailData() {
        StringBuffer buff = new StringBuffer(1024);
        String temp = this.getFromUser();
        if (CMyString.isEmpty(temp)) {
            temp = this.getFrom();
        }
        buff.append("From: ");
        buff.append("=?");
        buff.append(this.m_sCharset);
        buff.append("?B?");
        try {
            buff.append(new String(BASE64EncoderStream.encode(temp.getBytes(this.m_sCharset))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        buff.append("?=");
        buff.append(" <").append(this.getFrom()).append('>');
        buff.append(LR);
        temp = this.getTo();
        buff.append("To: ").append(temp).append(LR);
        temp = this.getCc();
        if (!CMyString.isEmpty(temp)) {
            buff.append("Cc: ").append(temp).append(LR);
        }
        temp = this.getReplyTo();
        buff.append("Reply-To: ");
        if (CMyString.isEmpty(temp)) {
            temp = this.getFrom();
        }
        buff.append(temp).append(LR);
        temp = this.getSubject();
        buff.append("Subject: ");
        if (!CMyString.isEmpty(temp)) {
            buff.append("=?");
            buff.append(this.m_sCharset);
            buff.append("?B?");
            try {
                buff.append(new String(BASE64EncoderStream.encode(temp.getBytes(this.m_sCharset))));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            buff.append("?=").append(LR);
        }
        buff.append("Date: ").append(this.getCurrentDate()).append(LR);
        buff.append("MIME-Version: 1.0").append(LR);
        if (this.m_hAttachFileList != null && !this.m_hAttachFileList.isEmpty()) {
            buff.append("Content-Type: multipart/mixed; ").append(LR);
            buff.append("\tboundary=\"");
            buff.append("----TRS_Email_Maker");
            buff.append("\"").append(LR);
            buff.append("X-Mailer: TRS Mailer Ver 1.2").append(LR);
            buff.append(LR);
            buff.append("--").append("----TRS_Email_Maker").append(LR);
            if (this.m_nMailFormat == 0) {
                buff.append("Content-Type: text/plain; ").append(LR);
            } else {
                buff.append("Content-Type: text/html; ").append(LR);
            }
            buff.append("\tcharset=\"").append(this.m_sCharset);
            buff.append("\"").append(LR);
            buff.append("Content-Transfer-Encoding: base64").append(LR);
        } else if (this.m_nMailFormat == 1) {
            buff.append("Content-Type: text/html; ").append(LR);
            buff.append("\tcharset=\"").append(this.m_sCharset);
            buff.append("\"").append(LR);
            buff.append("Content-Transfer-Encoding: base64").append(LR);
        } else {
            buff.append("Content-Type: text/plain; ").append(LR);
            buff.append("\tcharset=\"").append(this.m_sCharset);
            buff.append("\"").append(LR);
            buff.append("Content-Transfer-Encoding: base64").append(LR);
        }
        buff.append(LR);
        temp = this.getBody();
        buff.append(this.encode(temp)).append(LR);
        buff.append(LR);
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encode(String string) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BASE64EncoderStream encoder = new BASE64EncoderStream(baos);
        try {
            encoder.write(string.getBytes(this.m_sCharset));
            encoder.flush();
            String string2 = baos.toString();
            return string2;
        }
        catch (Exception e) {
            String string3 = new String(BASE64EncoderStream.encode("System Error!".getBytes()));
            return string3;
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
            try {
                encoder.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getCurrentDate() {
        SimpleDateFormat format = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss", Locale.ENGLISH);
        return format.format(new Date(System.currentTimeMillis()));
    }

    static String getMailEnd() {
        return "------TRS_Email_Maker--\r\n\r\n";
    }

    public void validate() throws CMyMailException {
        if (this.getTo() == null || this.getTo().trim().length() == 0) {
            throw new CMyMailException(I18NMessage.get(CMyEmail.class, "CMyEmail.label3", "\u90ae\u4ef6\u63a5\u6536\u8005\u4e3a\u7a7a\uff01 "));
        }
    }
}

