/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CSQLText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DataType;
import java.sql.Connection;
import java.sql.ResultSet;

public class SQLServerDB
extends DBType {
    public static String WRITE_STR_ENCODING = "ISO-8859-1";
    public static final DataType BIT = new DataType("BIT", -7, 1);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType SMALLINT = new DataType("SMALLINT", 5, 2);
    public static final DataType INT = new DataType("INT", 4, 4);
    public static final DataType BIGINT = new DataType("BIGINT", -5, 8);
    public static final DataType NUMERIC = new DataType("NUMERIC", 2, 9);
    public static final DataType REAL = new DataType("REAL", 7, 4);
    public static final DataType FLOAT = new DataType("FLOAT", 6, 8);
    public static final DataType DECIMAL = new DataType("DECIMAL", 3, 9);
    public static final DataType MONEY = new DataType("MONEY", 3, 8);
    public static final DataType SMALLMONEY = new DataType("SMALLMONEY", 3, 4);
    public static final DataType BINARY = new DataType("BINARY", -2);
    public static final DataType VARBINARY = new DataType("VARBINARY", -3);
    public static final DataType IMAGE = new DataType("IMAGE", -4, 16);
    public static final DataType CHAR = new DataType("CHAR", 1, -8000);
    public static final DataType NCHAR = new DataType("NCHAR", 1, -4000);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -8000);
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType TEXT = new DataType("TEXT", -1, 16);
    public static final DataType NTEXT = new DataType("NTEXT", -1, 16);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType DATETIME = new DataType("DATETIME", 93, 8);
    public static final DataType SMALLDATETIME = new DataType("SMALLDATETIME", 93, 4);
    public static final DataType UNIQUEIDENTIFIER = new DataType("UNIQUEIDENTIFIER", -5, 16);
    public static final DataType SQL_VARIRANT = new DataType("SQL_VARIRANT", -3);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType NUMBER = new DataType("NUMBER", 4, 4);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    static final DataType[] m_allDataTypes = new DataType[]{BIGINT, BINARY, BIT, CHAR, DATETIME, DECIMAL, FLOAT, IMAGE, INT, MONEY, NCHAR, NTEXT, NUMERIC, NVARCHAR, REAL, SMALLDATETIME, SMALLINT, SMALLMONEY, SQL_VARIRANT, TEXT, TIMESTAMP, TINYINT, UNIQUEIDENTIFIER, VARBINARY, VARCHAR, VARCHAR2, NUMBER, DATE};
    static final DataType[] m_supportedDataTypes = new DataType[]{SMALLINT, TINYINT, INT, NVARCHAR, NTEXT, DATETIME, FLOAT};

    public SQLServerDB() {
        super("SQLServer", "net.sourceforge.jtds.jdbc.Driver", true);
    }

    public SQLServerDB(String _sName, String _sDriverClass) {
        super(_sName, _sDriverClass, true);
    }

    @Override
    protected void registerDBInfo() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "nvarchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "datetime");
        this.registerColumnType(92, "datetime");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "image");
        this.registerColumnType(2005, "text");
        this.registerColumnType(-3, "image");
        this.registerColumnType(-3, 8000, "varbinary($l)");
    }

    @Override
    public String encodeStrToWrite(String _strSrc) {
        return _strSrc;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return true;
    }

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    @Override
    public DataType[] getSupportedDataTypes() {
        return m_supportedDataTypes;
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2) {
        return _strSQL1 + "+" + _strSQL2;
    }

    @Override
    public String sqlConcatStr(String _strSQL1, String _strSQL2, String _strSQL3) {
        return _strSQL1 + "+" + _strSQL2 + "+" + _strSQL3;
    }

    @Override
    public String sqlConcatStr(String[] _strSQLs) {
        String sRet = _strSQLs[0];
        for (int i = 1; i < _strSQLs.length; ++i) {
            sRet = sRet + "+" + _strSQLs[i];
        }
        return sRet;
    }

    @Override
    public String sqlFilterForClob(String _sFieldName, String _sValue) {
        String sValue = _sValue.equals("?") ? "?" : "'%" + CMyString.filterForSQL(_sValue) + "%'";
        return " patindex(" + sValue + "," + _sFieldName + ")>0 ";
    }

    @Override
    public String sqlAddField(String _sTableName, String _sFieldName, String _sFieldType, int _nMaxLength, boolean _bNullable, String _sDefaultValue, int _nScale) {
        DataType dataType = this.getDataType(_sFieldType);
        if (dataType == null) {
            return null;
        }
        String sFieldType = _sFieldType;
        int nMaxLength = _nMaxLength;
        switch (dataType.getType()) {
            case 2: 
            case 4: {
                sFieldType = "INT";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 6: {
                sFieldType = "FLOAT";
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                sFieldType = "DATETIME";
                break;
            }
            case 12: {
                sFieldType = "NVARCHAR";
            }
        }
        String strSQL = "ALTER TABLE " + _sTableName + " ADD " + _sFieldName + " " + sFieldType;
        if (dataType.isLengthDefinedByUser()) {
            strSQL = _nScale > 0 ? strSQL + "(" + nMaxLength + ", " + _nScale + ")" : strSQL + "(" + nMaxLength + ")";
        }
        strSQL = strSQL + " NULL";
        return strSQL;
    }

    @Override
    public String sqlGetSysDate() {
        return "GETDATE()";
    }

    @Override
    public String sqlFilterOneDay(String _sFieldName, String _sDateTime, String _sFormat) {
        return "DateDiff(day," + _sFieldName + ",'" + _sDateTime + "')=0";
    }

    @Override
    public String sqlDateTime(String _sDateTime, String _sFormat) {
        return "'" + _sDateTime + "'";
    }

    @Override
    public String sqlDate(String _sDateTime) {
        return "'" + _sDateTime + "'";
    }

    @Override
    public String sqlDateField(String _sDateField) {
        return _sDateField;
    }

    @Override
    public String initQuerySQL(String _strSql, int _nStartIndex, int _nSize) {
        return _strSql;
    }

    @Override
    public String sqlQueryTableInfos(String _sOwnerUser) {
        String strSQL = "SELECT *, NUMERIC_SCALE AS DATA_SCALE FROM WCM_ViewCOLUMNS ORDER BY TABLE_NAME, COLUMN_ID";
        return strSQL;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        return CSQLText.getText(p_rsData, p_nFieldIndex);
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        return CSQLText.getText(p_rsData, p_sFieldName);
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        throw new CMyException(2, I18NMessage.get(SQLServerDB.class, "SQLServerDB.label1", "SQL Server\u4e0d\u9700\u8981\u8bbe\u7f6e\u5927\u5b57\u6bb5\uff01"));
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        throw new CMyException(2, I18NMessage.get(SQLServerDB.class, "SQLServerDB.label1", "SQL Server\u4e0d\u9700\u8981\u8bbe\u7f6e\u5927\u5b57\u6bb5\uff01"));
    }

    @Override
    public String sqlGetNextId() {
        return "exec sp_getNextId ?,?,?";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String sqlQueryTableInfo(String _sOwnerUser, String _sDBTableName) {
        String strSQL = "SELECT *, NUMERIC_SCALE AS DATA_SCALE FROM WCM_ViewCOLUMNS WHERE TABLE_NAME='" + CMyString.filterForSQL(_sDBTableName) + "'  ORDER BY TABLE_NAME, COLUMN_ID";
        return strSQL;
    }

    @Override
    public boolean canDropField() {
        return true;
    }

    @Override
    public String sqlRenameTable(String _sOldTableName, String _sNewTableName) {
        return "exec sp_rename '" + CMyString.filterForSQL(_sOldTableName) + "','" + CMyString.filterForSQL(_sNewTableName) + "';";
    }

    @Override
    public String sqlRenameField(String _sTableName, String _sOldFieldName, String _sNewFieldName) {
        return "exec sp_rename '" + _sTableName + "." + CMyString.filterForSQL(_sOldFieldName) + "','" + CMyString.filterForSQL(_sNewFieldName) + "', 'COLUMN';";
    }

    @Override
    protected String keywordsModifyField() {
        return "alter column";
    }
}

