/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import java.io.Serializable;

public class DataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LENGTH_UNKOWN = 0;
    private String name;
    private int type;
    private int maxLength;

    public DataType(String _name, int _type) {
        this(_name, _type, 0);
    }

    public DataType(String _name, int _type, int _maxLength) {
        this.name = _name;
        this.type = _type;
        this.maxLength = _maxLength;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getMaxLength() {
        return this.maxLength >= 0 ? this.maxLength : -this.maxLength;
    }

    public boolean isCharData() {
        int nType = this.getType();
        return nType == 12 || nType == 1 || nType == -1 || nType == 2005;
    }

    public boolean isLengthDefinedByUser() {
        return this.maxLength < 0;
    }

    public String toString() {
        return "Name=" + this.name + " Type=" + this.type;
    }

    public boolean equals(Object _obj) {
        if (!(_obj instanceof DataType)) {
            return false;
        }
        int nType = ((DataType)_obj).getType();
        if (nType == this.getType()) {
            return true;
        }
        if (nType == 2 && this.getType() == 4) {
            return true;
        }
        return nType == 4 && this.getType() == 2;
    }

    public static String toTypeDescription(DataType _currDataType) {
        if (_currDataType == null) {
            return "";
        }
        int nDataType = _currDataType.getType();
        switch (nDataType) {
            case 6: {
                return I18NMessage.get(DataType.class, "DataType.label1", "\u5c0f\u6570\u578b");
            }
            case 2: 
            case 4: {
                return I18NMessage.get(DataType.class, "DataType.label2", "\u6574\u6570\u578b");
            }
            case 12: {
                return I18NMessage.get(DataType.class, "DataType.label3", "\u6587\u672c\u578b");
            }
            case 93: {
                return I18NMessage.get(DataType.class, "DataType.label4", "\u65f6\u95f4\u578b");
            }
        }
        return _currDataType.getName();
    }
}

