/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.database.DB2UDB2;
import com.trs.infra.util.database.FieldInfo;

public class DB2UDBV9
extends DB2UDB2 {
    public DB2UDBV9() {
    }

    public DB2UDBV9(String _sName, String _sDriverClass, boolean _bSupportStoredProc) {
        super(_sName, _sDriverClass, _bSupportStoredProc);
    }

    @Override
    public boolean canDropField() {
        return true;
    }

    @Override
    public String sqlDropField(String tableName, String fieldNames) throws Exception {
        StringBuffer buff = new StringBuffer(64);
        buff.append("alter table ");
        buff.append(tableName.toUpperCase());
        buff.append(" drop column ");
        buff.append(fieldNames);
        return buff.toString();
    }

    @Override
    protected String keywordsModifyField() throws WCMException {
        return null;
    }

    @Override
    public String sqlModifyField(String tableName, String fieldName, int fieldType, int lengthOrPrecision, boolean nullable, int scale) throws WCMException {
        if (fieldType != 12) {
            throw new UnsupportedOperationException("Only varchar column is modifyable!");
        }
        FieldInfo fi = DBManager.getDBManager().getFieldInfo(tableName, fieldName);
        if (fi == null) {
            throw new WCMException("No such field[" + tableName + "." + fieldName + "]");
        }
        if (fi.getDataLength() >= lengthOrPrecision) {
            throw new UnsupportedOperationException("Unsupprted operation :shrink column size[" + fi.getDataLength() + "-->" + lengthOrPrecision + "]");
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append("alter table ");
        buff.append(tableName.toUpperCase());
        buff.append(" alter column ");
        buff.append(fieldName.toUpperCase());
        buff.append(" set data type varchar(");
        buff.append(lengthOrPrecision);
        buff.append(")");
        return buff.toString();
    }

    @Override
    public String sqlRenameField(String tableName, String oldFieldName, String newFieldName) throws WCMException {
        throw new UnsupportedOperationException("Rename a column is not allowed by DB2!");
    }

    @Override
    public String sqlRenameTable(String oldTableName, String newTableName) throws WCMException {
        throw new UnsupportedOperationException("Rename a table is not allowed by DB2!");
    }
}

