/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DBTypes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;

public class CDBText
implements Serializable {
    public static final boolean JDBC_IS2 = false;
    private String m_sText = null;
    private transient DBType m_oDBType;
    private boolean m_bLoaded = false;

    public CDBText(int _nDBType) {
        this.setDBType(DBTypes.getDBType(_nDBType));
    }

    public CDBText(int _nDBType, String _sText) {
        this.setDBType(DBTypes.getDBType(_nDBType));
        this.setText(_sText);
    }

    public CDBText(DBType _dBType, String _sText) {
        this.setDBType(_dBType);
        this.setText(_sText);
    }

    public CDBText(DBType _dBType) {
        this.setDBType(_dBType);
    }

    public DBType getDBType() {
        return this.m_oDBType;
    }

    public boolean isLoaded() {
        return this.m_bLoaded;
    }

    public String getText() {
        return this.m_sText;
    }

    public void setText(String p_sText) {
        this.m_sText = p_sText;
        this.m_bLoaded = true;
    }

    public boolean isNull() {
        return this.m_sText == null;
    }

    public int getLength() {
        return this.m_sText == null ? 0 : this.m_sText.length();
    }

    public String toString() {
        return this.getText() == null ? "" : this.getText();
    }

    public void readFromRs(ResultSet p_rsData, String p_sFieldName) throws CMyException {
        this.setText(this.getDBType().getClob(p_rsData, false, p_sFieldName));
    }

    public void readFromRs(ResultSet p_rsData, int p_nFieldIndex) throws CMyException {
        this.setText(this.getDBType().getClob(p_rsData, false, p_nFieldIndex));
    }

    public boolean updateToDB(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sTextFieldName) throws CMyException {
        return this.getDBType().setClob(p_oConn, p_sTableName, p_sWhere, p_sIdFieldName, p_sTextFieldName, this.getText());
    }

    public void setDBType(DBType type) {
        this.m_oDBType = type;
    }

    public boolean equals(Object _another) {
        if (_another == null || !(_another instanceof CDBText)) {
            return false;
        }
        String sText = ((CDBText)_another).getText();
        if (sText == null) {
            return this.m_sText == null;
        }
        return sText.equals(this.m_sText);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.m_oDBType.getType());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setDBType(DBTypes.getDBType(in.readInt()));
    }
}

