/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CAS400CLOB {
    private static String getStringFromClob(Clob p_clob) throws Exception {
        if (p_clob == null) {
            return null;
        }
        long len = p_clob.length();
        if (len > 0L) {
            return p_clob.getSubString(1L, (int)len);
        }
        return "";
    }

    public static String getClob(ResultSet p_rsData, String p_sFieldName) throws CMyException {
        try {
            Clob clob = p_rsData.getClob(p_sFieldName);
            return CAS400CLOB.getStringFromClob(clob);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label1", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB.getClob)"), ex);
        }
    }

    public static String getClob(ResultSet p_rsData, int p_nFieldIndex) throws CMyException {
        try {
            Clob clob = p_rsData.getClob(p_nFieldIndex);
            return CAS400CLOB.getStringFromClob(clob);
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label2", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB2.getClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label2", "\u4ece\u5f53\u524d\u8bb0\u5f55\u96c6\u4e2d\u8bfb\u53d6CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB2.getClob)"), ex);
        }
    }

    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label3", "\u53c2\u6570\u65e0\u6548(CAS400CLOB.setClob)"));
        }
        String strSQL = "UPDATE " + p_sTableName + " SET " + p_sClobFieldName + "=? WHERE " + p_sWhere;
        return CAS400CLOB.setClob(p_oConn, p_sValue, strSQL, p_sClobFieldName);
    }

    public static boolean setClob(Connection p_oConn, String p_sValue, String p_sUpdateSQL, String p_sFieldName) throws CMyException {
        if (p_sValue == null) {
            return true;
        }
        try {
            PreparedStatement pstmt = p_oConn.prepareStatement(p_sUpdateSQL);
            pstmt.setObject(1, (Object)p_sValue, -1);
            pstmt.executeUpdate();
            pstmt.close();
            return true;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label4", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label4", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB.setClob)"), ex);
        }
    }

    public static boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int nClobCount = p_asFieldsAndValues.length / 2;
        if (nClobCount <= 0 || nClobCount * 2 != p_asFieldsAndValues.length) {
            throw new CMyException(10, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label5", "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548(CAS400CLOB.setClob)") + p_sIdFieldName);
        }
        String strSQL = "UPDATE " + p_sTableName + " SET " + p_asFieldsAndValues[0] + "=?";
        for (int i = 1; i < nClobCount; ++i) {
            strSQL = strSQL + "," + p_asFieldsAndValues[i * 2] + "=?";
        }
        strSQL = strSQL + " WHERE " + p_sWhere;
        PreparedStatement pstmt = null;
        try {
            int i;
            pstmt = p_oConn.prepareStatement(strSQL);
            for (i = 0; i < nClobCount; ++i) {
                String sValue = p_asFieldsAndValues[i * 2 + 1];
                if (sValue == null) {
                    sValue = "";
                }
                pstmt.setObject(i + 1, (Object)sValue, -1);
            }
            pstmt.executeUpdate();
            i = 1;
            return i != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label4", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519(CAS400CLOB.setClob)"), ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, I18NMessage.get(CAS400CLOB.class, "CAS400CLOB.label6", "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u95192(CAS400CLOB.setClob)"), ex);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

