/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.discover.DiscoveryFactory;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.discover.util.DiscoveryServletHelper;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileWrapper;
import java.io.File;

public class WCMDiscoveryFactory {
    private static IDiscovery s_oDiscovery = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDiscovery initDiscovery(FileStore[] _pLibDirs, FileStore[] _pClassesDirs) {
        if (s_oDiscovery != null) {
            return s_oDiscovery;
        }
        Class<WCMDiscoveryFactory> clazz = WCMDiscoveryFactory.class;
        synchronized (WCMDiscoveryFactory.class) {
            if (s_oDiscovery != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return s_oDiscovery;
            }
            File[] pLib = new FileWrapper[_pLibDirs.length];
            File[] pClasses = new FileWrapper[_pClassesDirs.length];
            for (int i = 0; i < pLib.length; ++i) {
                pLib[i] = new FileWrapper(_pLibDirs[i]);
            }
            for (int j = 0; j < pClasses.length; ++j) {
                pClasses[j] = new FileWrapper(_pClassesDirs[j]);
            }
            s_oDiscovery = DiscoveryFactory.create((File[])pLib, (File[])pClasses);
            DiscoveryServletHelper.setDiscovery((IDiscovery)s_oDiscovery);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return s_oDiscovery;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDiscovery getDiscovery() {
        if (s_oDiscovery != null) return s_oDiscovery;
        Class<WCMDiscoveryFactory> clazz = WCMDiscoveryFactory.class;
        synchronized (WCMDiscoveryFactory.class) {
            s_oDiscovery = DiscoveryServletHelper.getDiscovery();
            if (s_oDiscovery != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return s_oDiscovery;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            FileStore[] pClassesDirs = new FileStore[]{WCMDiscoveryFactory.getConfigRootFilePath(), WCMDiscoveryFactory.getClassRootFilePath()};
            WCMDiscoveryFactory.initDiscovery(new FileStore[0], pClassesDirs);
            return s_oDiscovery;
        }
    }

    public static FileStore getConfigRootFilePath() {
        FileService file = new FileService(ConfigConstants.DIR_APPROOT);
        if (!file.exists()) {
            throw new RuntimeException(I18NMessage.get(WCMDiscoveryFactory.class, "WCMDiscoveryFactory.label1", "\u76ee\u5f55[") + ConfigConstants.DIR_APPROOT + I18NMessage.get(WCMDiscoveryFactory.class, "WCMDiscoveryFactory.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return file;
    }

    public static FileStore getClassRootFilePath() {
        FileService file = new FileService(ConfigConstants.DIR_CLASSROOT);
        if (!file.exists()) {
            throw new RuntimeException(I18NMessage.get(WCMDiscoveryFactory.class, "WCMDiscoveryFactory.label1", "\u76ee\u5f55[") + ConfigConstants.DIR_CLASSROOT + I18NMessage.get(WCMDiscoveryFactory.class, "WCMDiscoveryFactory.label2", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return file;
    }
}

