/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import javax.servlet.http.HttpServletRequest;

public class RemoteAddrUtil {
    public static String getRemoteAddr(HttpServletRequest req) {
        String addr = req.getHeader("Cdn-Src-Ip");
        if (RemoteAddrUtil.isIPAddress(addr)) {
            return addr;
        }
        addr = req.getHeader("X-Forwarded-For");
        while (addr != null) {
            String address = null;
            int iFirstDot = addr.indexOf(44);
            if (iFirstDot > 0) {
                address = addr.substring(0, iFirstDot).trim();
                addr = addr.substring(iFirstDot + 1);
            } else {
                address = addr;
                addr = null;
            }
            if (!RemoteAddrUtil.isIPAddress(address)) continue;
            return address;
        }
        return req.getRemoteAddr();
    }

    public static final boolean isIPAddress(String s) {
        if (s != null) {
            int temp;
            int dot1 = (s = s.trim()).indexOf(46);
            if (dot1 <= 0) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(0, dot1++));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            int dot2 = s.indexOf(46, dot1);
            if (dot2 <= 0) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(dot1, dot2++));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            int dot3 = s.indexOf(46, dot2);
            if (dot3 <= 0) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(dot2, dot3++));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            try {
                temp = Integer.parseInt(s.substring(dot3));
                if (temp < 0 || temp > 255) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }
        return false;
    }
}

