/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFilenameFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreFilter;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Timestamp;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CMyFile {
    private static Logger m_oLogger = Logger.getLogger(CMyFile.class);

    public static boolean fileExists(String _sPathFileName) {
        FileService file = new FileService(_sPathFileName);
        return file.exists();
    }

    public static boolean pathExists(String _sPathFileName) {
        String sPath = CMyFile.extractFilePath(_sPathFileName);
        return CMyFile.fileExists(sPath);
    }

    public static String extractFileName(String _sFilePathName) {
        return CMyFile.extractFileName(_sFilePathName, File.separator);
    }

    public static String extractFileName(String _sFilePathName, String _sFileSeparator) {
        int nPos = -1;
        if (_sFileSeparator == null) {
            nPos = _sFilePathName.lastIndexOf(File.separatorChar);
            if (nPos < 0) {
                nPos = _sFilePathName.lastIndexOf(File.separatorChar == '/' ? 92 : 47);
            }
        } else {
            nPos = _sFilePathName.lastIndexOf(_sFileSeparator);
        }
        if (nPos < 0) {
            return _sFilePathName;
        }
        return _sFilePathName.substring(nPos + 1);
    }

    public static String extractHttpFileName(String _sFilePathName) {
        int nPos = _sFilePathName.lastIndexOf("/");
        return _sFilePathName.substring(nPos + 1);
    }

    public static String extractMainFileName(String _sFilePathName) {
        String sFileMame = CMyFile.extractFileName(_sFilePathName);
        int nPos = sFileMame.lastIndexOf(46);
        if (nPos > 0) {
            return sFileMame.substring(0, nPos);
        }
        return sFileMame;
    }

    public static String excludeFileExt(String sFileMame) {
        int nPos = sFileMame.lastIndexOf(46);
        if (nPos > 0) {
            return sFileMame.substring(0, nPos);
        }
        return sFileMame;
    }

    public static String extractFileExt(String _sFilePathName) {
        int nPos;
        if (_sFilePathName.endsWith("7png")) {
            return "png";
        }
        if (_sFilePathName.endsWith("7jpg")) {
            return "jpg";
        }
        int nParamPos = _sFilePathName.lastIndexOf(63);
        if (nParamPos >= 0 && _sFilePathName.substring(nParamPos).indexOf(46) < 0) {
            _sFilePathName = _sFilePathName.substring(0, nParamPos);
        }
        return (nPos = _sFilePathName.lastIndexOf(46)) >= 0 ? _sFilePathName.substring(nPos + 1) : "";
    }

    public static String extractFilePath(String _sFilePathName) {
        _sFilePathName = StringUtils.replace((String)_sFilePathName, (String)"/", (String)File.separator);
        _sFilePathName = StringUtils.replace((String)_sFilePathName, (String)"\\\\", (String)File.separator);
        int nPos = _sFilePathName.lastIndexOf(File.separator);
        int nParamPos = _sFilePathName.lastIndexOf(63);
        if (nParamPos >= 0) {
            _sFilePathName = _sFilePathName.substring(0, nParamPos);
        }
        return nPos >= 0 ? _sFilePathName.substring(0, nPos + 1) : "";
    }

    public static String toAbsolutePathName(String _sFilePathName) {
        FileService file = new FileService(_sFilePathName);
        return file.getAbsolutePath();
    }

    public static String extractFileDrive(String _sFilePathName) {
        int nLen = _sFilePathName.length();
        if (nLen > 2 && _sFilePathName.charAt(1) == ':') {
            return _sFilePathName.substring(0, 2);
        }
        if (nLen > 2 && _sFilePathName.charAt(0) == File.separatorChar && _sFilePathName.charAt(1) == File.separatorChar) {
            int nPos = _sFilePathName.indexOf(File.separatorChar, 2);
            if (nPos >= 0) {
                nPos = _sFilePathName.indexOf(File.separatorChar, nPos + 1);
            }
            return nPos >= 0 ? _sFilePathName.substring(0, nPos) : _sFilePathName;
        }
        return "";
    }

    public static boolean deleteFile(String _sFilePathName) {
        FileService file = new FileService(_sFilePathName);
        return file.exists() ? file.delete() : false;
    }

    public static boolean makeDir(String _sDir, boolean _bCreateParentDir) {
        boolean zResult = false;
        FileService file = new FileService(_sDir);
        zResult = _bCreateParentDir ? file.mkdirs() : file.mkdir();
        if (!zResult) {
            zResult = file.exists();
        }
        return zResult;
    }

    public static boolean deleteDir(String _sDir, boolean _bDeleteChildren) {
        FileService file = new FileService(_sDir);
        if (!file.exists()) {
            return false;
        }
        if (_bDeleteChildren) {
            FileStore[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileStore aFile = files[i];
                if (aFile.isDirectory()) {
                    CMyFile.deleteDir(aFile);
                    continue;
                }
                aFile.delete();
            }
        }
        return file.delete();
    }

    public static boolean deleteDir(String _sPath) {
        FileService path = new FileService(_sPath);
        return CMyFile.deleteDir(path);
    }

    public static boolean deleteDir(FileStore _path) {
        if (!_path.exists()) {
            return false;
        }
        if (_path.isDirectory()) {
            FileStore[] files = _path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileStore aFile = files[i];
                if (aFile.isDirectory()) {
                    CMyFile.deleteDir(aFile);
                    continue;
                }
                aFile.delete();
            }
        }
        return _path.delete();
    }

    public static FileStore[] listFiles(String _dir, String _extendName) {
        FileService fDir = new FileService(_dir);
        if (_extendName.charAt(0) != '.') {
            _extendName = "." + _extendName;
        }
        FileStore[] Files = fDir.listFiles(new CMyFilenameFilter(_extendName));
        return Files;
    }

    public static FileStore[] listSubDirectories(String _dir) {
        FileService fDir = new FileService(_dir);
        FileStoreFilter fileFilter = new FileStoreFilter(){

            @Override
            public boolean accept(FileStore file) {
                return file.isDirectory();
            }
        };
        FileStore[] files = fDir.listFiles(fileFilter);
        return files;
    }

    public static String readFile(String _sFileName) throws CMyException {
        return CMyFile.readFile(_sFileName, CMyString.FILE_WRITING_ENCODING);
    }

    public static String readFile(String _sFileName, String _sEncoding) throws CMyException {
        InputStreamReader fileReader = null;
        StringBuffer buffContent = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        if (_sEncoding == null) {
            _sEncoding = "utf-8";
        }
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, _sEncoding));
            boolean zFirstLine = "utf-8".equalsIgnoreCase(_sEncoding);
            while ((sLine = buffReader.readLine()) != null) {
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                if (zFirstLine) {
                    sLine = CMyFile.removeBomHeaderIfExists(sLine);
                    zFirstLine = false;
                }
                buffContent.append(sLine);
            }
            String string = buffContent == null ? "" : buffContent.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(CMyFile.class, "CMyFile.label1", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, I18NMessage.get(CMyFile.class, "CMyFile.label2", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String removeBomHeaderIfExists(String _sLine) {
        if (_sLine == null) {
            return null;
        }
        String line = _sLine;
        if (line.length() > 0) {
            char ch = line.charAt(0);
            while ((ch == '\ufeff' || ch == '\ufffe') && (line = line.substring(1)).length() != 0) {
                ch = line.charAt(0);
            }
        }
        return line;
    }

    public static byte[] readBytesFromFile(String _sFileName) throws CMyException {
        InputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileService(_sFileName).getInputStream();
            byte[] buffer = new byte[1024];
            bos = new ByteArrayOutputStream(2048);
            int nLen = 0;
            while ((nLen = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, nLen);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new CMyException("\u8bfb\u53d6\u6587\u4ef6[" + _sFileName + "]\u5931\u8d25\uff01");
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean writeFile(String _sFileName, String _sFileContent) throws CMyException {
        return CMyFile.writeFile(_sFileName, _sFileContent, CMyString.FILE_WRITING_ENCODING);
    }

    public static boolean writeFile(String _sFileName, String _sFileContent, String _encoding) throws CMyException {
        return CMyFile.writeFile(_sFileName, _sFileContent, _encoding, false);
    }

    public static boolean writeFile(String _sFileName, String _sFileContent, String _sFileEncoding, boolean _bWriteUnicodeFlag) throws CMyException {
        boolean zOk = CMyFile.writeFile0(_sFileName, _sFileContent, _sFileEncoding, _bWriteUnicodeFlag);
        int nMaxCount = 30;
        int nCount = 1;
        while (!zOk) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileService file = new FileService(_sFileName);
            m_oLogger.warn((Object)("Try again write [" + _sFileContent.length() + "] to [" + _sFileName + "][" + file.length() + "], already try [" + nCount + "] times!"));
            zOk = CMyFile.writeFile0(_sFileName, _sFileContent, _sFileEncoding, _bWriteUnicodeFlag);
            if (++nCount <= nMaxCount) continue;
            break;
        }
        return zOk;
    }

    private static boolean writeFile0(String _sFileName, String _sFileContent, String _sFileEncoding, boolean _bWriteUnicodeFlag) throws CMyException {
        int nSrcLen = 0;
        String sPath = CMyFile.extractFilePath(_sFileName);
        if (!CMyFile.pathExists(sPath)) {
            CMyFile.makeDir(sPath, true);
        }
        String sFileEncoding = CMyString.showNull(_sFileEncoding, CMyString.FILE_WRITING_ENCODING);
        boolean bRet = false;
        OutputStream fos = null;
        Writer outWriter = null;
        try {
            fos = new FileService(_sFileName).getOutputStream();
            if (_bWriteUnicodeFlag) {
                fos.write(65279);
            }
            byte[] pContent = _sFileContent.getBytes(_sFileEncoding);
            nSrcLen = pContent.length;
            fos.write(pContent);
            bRet = true;
        }
        catch (Exception ex) {
            m_oLogger.error((Object)(I18NMessage.get(CMyFile.class, "CMyFile.label5", "\u5199\u6587\u4ef6[") + _sFileName + I18NMessage.get(CMyFile.class, "CMyFile.label6", "]\u53d1\u751f\u5f02\u5e38")), (Throwable)ex);
            throw new CMyException(54, I18NMessage.get(CMyFile.class, "CMyFile.label7", "\u5199\u6587\u4ef6\u9519\u8bef(CMyFile.writeFile)"), ex);
        }
        finally {
            if (outWriter != null) {
                try {
                    outWriter.flush();
                }
                catch (Exception exception) {}
                try {
                    outWriter.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.flush();
                }
                catch (Exception exception) {}
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        FileService newFile = new FileService(_sFileName);
        if (bRet && newFile.exists()) {
            return newFile.length() >= (long)nSrcLen;
        }
        return false;
    }

    public static boolean appendFile(String _sFileName, String _sAddContent) throws CMyException {
        boolean bResult = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(_sFileName, "rw");
            raf.seek(raf.length());
            raf.writeBytes(_sAddContent);
            bResult = true;
        }
        catch (Exception ex) {
            throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label8", "\u5411\u6587\u4ef6\u8ffd\u52a0\u5185\u5bb9\u65f6\u53d1\u751f\u5f02\u5e38(CMyFile.appendFile)"), ex);
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception exception) {}
        }
        return bResult;
    }

    public static boolean moveFile(String _sSrcFile, String _sDstFile) throws CMyException {
        return CMyFile.moveFile(_sSrcFile, _sDstFile, true);
    }

    public static boolean moveFile(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists) throws CMyException {
        CMyFile.copyFile(_sSrcFile, _sDstFile, _bMakeDirIfNotExists);
        CMyFile.deleteFile(_sSrcFile);
        return false;
    }

    public static boolean copyFile(String _sSrcFile, String _sDstFile) throws CMyException {
        return CMyFile.copyFile(_sSrcFile, _sDstFile, true);
    }

    public static boolean copyFile(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists) throws CMyException {
        return CMyFile.copyFile(_sSrcFile, _sDstFile, _bMakeDirIfNotExists, false);
    }

    public static boolean copyFile(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists, boolean preserveFileDate) throws CMyException {
        boolean zOk = CMyFile.copyFile0(_sSrcFile, _sDstFile, _bMakeDirIfNotExists, preserveFileDate);
        int nMaxCount = 30;
        int nCount = 1;
        while (!zOk) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_oLogger.warn((Object)("Try again copy [" + _sSrcFile + "] to [" + _sDstFile + "], already try [" + nCount + "] times!"));
            zOk = CMyFile.copyFile0(_sSrcFile, _sDstFile, _bMakeDirIfNotExists, preserveFileDate);
            if (++nCount <= nMaxCount) continue;
            break;
        }
        return zOk;
    }

    private static boolean copyFile0(String _sSrcFile, String _sDstFile, boolean _bMakeDirIfNotExists, boolean preserveFileDate) throws CMyException {
        FileService newFile;
        FileService srcFile = new FileService(_sSrcFile);
        if (srcFile.isDirectory() || !srcFile.exists()) {
            m_oLogger.error((Object)("\u65e0\u6548\u7684\u6587\u4ef6[" + _sSrcFile + "]\uff01"));
            throw new BizError("\u8981\u590d\u5236\u7684\u6587\u4ef6\u65e0\u6548");
        }
        long lSrcStart = srcFile.length();
        int nPos = _sSrcFile.lastIndexOf(46);
        String sFileExt = null;
        if (nPos > 0 && nPos < _sSrcFile.length() - 1) {
            sFileExt = _sSrcFile.substring(nPos + 1);
        }
        if (lSrcStart == 0L && sFileExt != null && "jpg".equalsIgnoreCase(sFileExt)) {
            m_oLogger.warn((Object)("Copy 0KB File [" + _sSrcFile + "] to [" + _sDstFile + "]........"));
            return false;
        }
        InputStream fis = null;
        OutputStream fos = null;
        try {
            int nLen;
            FileService dstFile = new FileService(_sDstFile);
            if (srcFile.equals(dstFile)) {
                boolean bl = true;
                return bl;
            }
            fis = srcFile.getInputStream();
            try {
                fos = dstFile.getOutputStream();
            }
            catch (Exception ex) {
                if (_bMakeDirIfNotExists) {
                    if (!CMyFile.makeDir(CMyFile.extractFilePath(_sDstFile), true)) {
                        throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label9", "\u4e3a\u76ee\u6807\u6587\u4ef6[") + _sDstFile + I18NMessage.get(CMyFile.class, "CMyFile.label10", "]\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01"));
                    }
                    fos = new FileService(_sDstFile).getOutputStream();
                }
                throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label11", "\u6307\u5b9a\u76ee\u6807\u6587\u4ef6[") + _sDstFile + I18NMessage.get(CMyFile.class, "CMyFile.label12", "]\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff01"), ex);
            }
            byte[] buffer = new byte[4096];
            while ((nLen = fis.read(buffer)) > 0) {
                fos.write(buffer, 0, nLen);
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(CMyFile.class, "CMyFile.label13", "\u8981\u590d\u5236\u7684\u539f\u6587\u4ef6\u6ca1\u6709\u53d1\u73b0(CMyFile.copyFile)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(50, I18NMessage.get(CMyFile.class, "CMyFile.label14", "\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38(CMyFile.copyFile)"), ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                }
                catch (Exception exception) {}
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (preserveFileDate) {
            new FileService(_sDstFile).setLastModified(new FileService(_sSrcFile).lastModified());
        }
        if ((newFile = new FileService(_sDstFile)).exists()) {
            boolean bResult;
            srcFile = new FileService(_sSrcFile);
            long lSrc = srcFile.length();
            long lDst = newFile.length();
            if (lDst == 0L && sFileExt != null && "jpg".equalsIgnoreCase(sFileExt)) {
                m_oLogger.warn((Object)("Copy 0KB File[" + _sSrcFile + "][" + lSrc + "][" + lSrcStart + "] to [" + _sDstFile + "][" + lDst + "]!"));
                return false;
            }
            boolean bl = bResult = lDst >= lSrc;
            if (!bResult) {
                m_oLogger.warn((Object)("Copy File[" + _sSrcFile + "][" + lSrc + "][" + lSrcStart + "] to [" + _sDstFile + "][" + lDst + "]"));
            }
            return bResult;
        }
        return false;
    }

    public static void copyFileDir(String _fromFileDir, String _toFileDir, boolean _bIncludeCurrDir) throws CMyException {
        if (CMyString.isEmpty(_fromFileDir) || CMyString.isEmpty(_toFileDir)) {
            return;
        }
        FileService fFromFile = new FileService(_fromFileDir);
        FileService fToFile = new FileService(_toFileDir);
        if (fFromFile.isFile() || fToFile.isFile()) {
            throw new CMyException("\u6e90\u76ee\u5f55\u548c\u76ee\u6807\u76ee\u5f55\u90fd\u4e0d\u80fd\u662f\u6587\u4ef6\uff01");
        }
        FileStore[] files = fFromFile.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        _fromFileDir = CMyString.setStrEndWith(_fromFileDir, File.separatorChar);
        _toFileDir = CMyString.setStrEndWith(_toFileDir, File.separatorChar);
        if (_bIncludeCurrDir) {
            FileService parentFile = new FileService(_toFileDir + fFromFile.getName());
            if (!parentFile.exists()) {
                parentFile.mkdir();
            }
            _toFileDir = _toFileDir + fFromFile.getName();
            _toFileDir = _toFileDir + File.separatorChar;
        }
        for (int i = 0; i < files.length; ++i) {
            FileStore aFile = files[i];
            if (aFile == null || "Thumbs.db".equals(aFile.getName())) continue;
            if (!aFile.isFile()) {
                String sToFileDirPath = _toFileDir + aFile.getName();
                if (!CMyFile.fileExists(sToFileDirPath)) {
                    CMyFile.makeDir(sToFileDirPath, true);
                }
                CMyFile.copyFileDir(_fromFileDir + aFile.getName(), sToFileDirPath, false);
                continue;
            }
            try {
                CMyFile.copyFile(_fromFileDir + aFile.getName(), _toFileDir + aFile.getName(), true);
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getStackTrace());
            }
        }
    }

    public static String mapResouceFullPath(String _resource) throws WCMException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(_resource);
        if (url == null) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + _resource + I18NMessage.get(CMyFile.class, "CMyFile.label16", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        String sPath = null;
        try {
            sPath = url.getFile();
            if (sPath.indexOf(37) >= 0) {
                String enc = System.getProperty("file.encoding", "GBK");
                sPath = URLDecoder.decode(url.getFile(), enc);
            }
        }
        catch (Exception ex) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + url.getFile() + I18NMessage.get(CMyFile.class, "CMyFile.label17", "]\u8f6c\u6362\u5931\u8d25\uff01"), ex);
        }
        return sPath;
    }

    public static String mapResouceFullPath(String _resource, Class _currClass) throws WCMException {
        URL url = _currClass.getResource(_resource);
        if (url == null) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + _resource + I18NMessage.get(CMyFile.class, "CMyFile.label16", "]\u6ca1\u6709\u627e\u5230\uff01"));
        }
        String sPath = null;
        try {
            sPath = url.getFile();
            if (sPath.indexOf(37) >= 0) {
                String enc = System.getProperty("file.encoding", "GBK");
                sPath = URLDecoder.decode(url.getFile(), enc);
            }
        }
        catch (Exception ex) {
            throw new WCMException(55, I18NMessage.get(CMyFile.class, "CMyFile.label15", "\u6587\u4ef6[") + url.getFile() + I18NMessage.get(CMyFile.class, "CMyFile.label17", "]\u8f6c\u6362\u5931\u8d25\uff01"), ex);
        }
        return sPath;
    }

    public static boolean validImageFile(String sFileAbsPath, int _minWidth, int _minHeight) {
        BufferedImage srcFile;
        if (!CMyFile.fileExists(sFileAbsPath)) {
            return false;
        }
        FileService imageFile = new FileService(sFileAbsPath);
        try {
            srcFile = ImageIO.read(imageFile.getInputStream());
        }
        catch (IOException e) {
            if (m_oLogger.isDebugEnabled()) {
                m_oLogger.error((Object)("\u8bfb\u53d6\u6587\u4ef6[" + sFileAbsPath + "]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
            }
            return false;
        }
        if (srcFile == null) {
            return false;
        }
        int nSrcWidth = srcFile.getWidth();
        if (nSrcWidth < _minWidth) {
            return false;
        }
        int nSrcHeight = srcFile.getHeight();
        return nSrcHeight >= _minHeight;
    }

    public static String getTempFileName() {
        String sTime = new Timestamp(System.currentTimeMillis()).toString();
        sTime = sTime.substring(0, 19).replace('-', '.').replace(' ', '_').replace(':', '.');
        StringBuffer sb = new StringBuffer(256);
        sb.append("__deleted_");
        sb.append(sTime);
        sb.append("__");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            CMyFile.writeFile("d:\\t1.txt", "\u4e2d\u6587", "utf-8");
            CMyFile.writeFile("d:\\t2.txt", "\u4e2d\u6587", "GBK");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

