/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.log;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.log.Log;
import com.trs.infra.support.log.LogType;
import com.trs.infra.support.log.Logs;
import com.trs.infra.support.log.OperType;
import org.dom4j.Element;

public final class LogXmlConverter
extends BaseObjToXmlConverter {
    private static final String UNKOWN_DESC = I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label15", "\u672a\u77e5");
    private static final String TAG_PROPERTIES = "PROPERTIES";
    private static final String VALUEABLE_FIELDS = "LOGTYPE,LOGOBJNAME,LOGOPTYPE,LOGUSER,LOGUSERIP,LOGOPTIME,EXECTIME,LOGRESULT,LOGDESC";

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        this.assertIsLogInstance(_baseObj);
        Log currLog = (Log)_baseObj;
        WCMFilter aFilter = new WCMFilter("", "TopId=" + currLog.getId(), "");
        Logs children = Logs.openWCMObjs(aFilter);
        if (children.isEmpty()) {
            return null;
        }
        Element[] childrendEls = new Element[]{this.toXmlElement(children, null)};
        childrendEls[0].setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label1", "\u89e6\u53d1\u7684\u64cd\u4f5c"));
        return childrendEls;
    }

    @Override
    protected Element toXmlElement(BaseObj _baseObj, String _sFiledList) throws WCMException {
        this.assertIsLogInstance(_baseObj);
        Element root = super.toXmlElement(_baseObj, VALUEABLE_FIELDS);
        root.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label2", "\u64cd\u4f5c\u65e5\u5fd7"));
        Element properties = root.element(TAG_PROPERTIES);
        properties.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label3", "\u65e5\u5fd7\u4fe1\u606f"));
        Element child = properties.element("LOGTYPE");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label4", "\u65e5\u5fd7\u7c7b\u578b"));
        child.setText(this.getOperDesc(child.getText()));
        child = properties.element("LOGOBJNAME");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label5", "\u64cd\u4f5c\u5bf9\u8c61"));
        child = properties.element("LOGOPTYPE");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label6", "\u64cd\u4f5c\u7c7b\u578b"));
        child.setText(this.getOperTypeDesc(child.getText()));
        child = properties.element("LOGUSER");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label7", "\u64cd\u4f5c\u7528\u6237"));
        child = properties.element("LOGUSERIP");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label8", "\u64cd\u4f5c\u7528\u6237IP"));
        child = properties.element("LOGOPTIME");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label9", "\u64cd\u4f5c\u65f6\u95f4"));
        child = properties.element("EXECTIME");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label10", "\u64cd\u4f5c\u8017\u65f6"));
        child.setText(child.getText() + "ms");
        child = properties.element("LOGRESULT");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label11", "\u64cd\u4f5c\u7ed3\u679c"));
        child.setText(this.getOperResultDesc(child.getText()));
        child = properties.element("LOGDESC");
        child.setName(I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label12", "\u64cd\u4f5c\u8be6\u7ec6\u63cf\u8ff0"));
        return root;
    }

    private void assertIsLogInstance(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null || !(_baseObj instanceof Log)) {
            throw new WCMException(10, "isn't a log instance!");
        }
    }

    private String getOperDesc(String _type) throws WCMException {
        if (this.emptyString(_type)) {
            return UNKOWN_DESC;
        }
        LogType type = LogType.findById(Integer.parseInt(_type));
        return type != null ? type.getDesc() : UNKOWN_DESC;
    }

    private String getOperTypeDesc(String type) throws WCMException {
        OperType opertype = OperType.findById(Integer.parseInt(type));
        return opertype != null ? opertype.getDesc() : UNKOWN_DESC;
    }

    private String getOperResultDesc(String _resultid) {
        if (this.emptyString(_resultid)) {
            return UNKOWN_DESC;
        }
        int id = Integer.parseInt(_resultid);
        return id == 1 ? I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label13", "\u6210\u529f") : I18NMessage.get(LogXmlConverter.class, "LogXmlConverter.label14", "\u5931\u8d25");
    }

    private boolean emptyString(String _string) {
        return _string == null || _string.trim().length() == 0;
    }
}

