/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.listener;

import com.trs.DreamFactory;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListener;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnBeforeAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.persistent.listener.MonitorHostConfig;
import com.trs.infra.persistent.listener.ObjectLCListenerConfig;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectLCMonitorServer
extends BaseServer
implements IObjectLCListenerOnBeforeAdd,
IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    public static final int EVENT_TYPE_ADD_BEFORE = -1;
    public static final int EVENT_TYPE_ADD = 1;
    public static final int EVENT_TYPE_EDIT_AFTER = 2;
    public static final int EVENT_TYPE_DELETE_BEFORE = 3;
    public static final int EVENT_TYPE_DELETE_AFTER = 4;
    public static final int EVENT_TYPE_EDIT_BEFORE = 5;
    public static final int[] EVENT_TYPES = new int[]{-1, 1, 2, 3, 4, 5};
    public static final int[] EVENT_TYPES_DEFAULT = new int[]{1, 2, 3};
    private Map m_hmListenersIndexs = null;
    private Map<String, Boolean> m_hmStatus = null;
    private Map<String, Boolean> m_hmCanUsedInChildren = null;

    public static ObjectLCMonitorServer getMonitorServer() {
        return (ObjectLCMonitorServer)DreamFactory.createObjectById("ObjectLCMonitorServer");
    }

    public IObjectLCListener[] getListeners(int _nEventType, BaseObj _currObj) {
        return this.getListenersByTypeAndClass(_nEventType, _currObj.getClass());
    }

    private IObjectLCListener[] getListenersByTypeAndClass(int _nEventType, Class _objClass) {
        if (_objClass == null) {
            return null;
        }
        String sKey = this.makeKey(_nEventType, _objClass.getName());
        IObjectLCListener[] aListeners = (IObjectLCListener[])this.getListenersIndexs().get(sKey);
        if (this.m_hmStatus == null) {
            this.m_hmStatus = new HashMap<String, Boolean>();
        }
        if (this.m_hmStatus.containsKey(sKey)) {
            return aListeners;
        }
        IObjectLCListener[] aParentListeners = this.getParentListeners(_nEventType, _objClass);
        if (aParentListeners != null && aParentListeners.length > 0) {
            int nOldSize = 0;
            if (aListeners != null && aListeners.length > 0) {
                nOldSize = aListeners.length;
            }
            IObjectLCListener[] temp = new IObjectLCListener[nOldSize + aParentListeners.length];
            if (nOldSize > 0) {
                System.arraycopy(aListeners, 0, temp, 0, nOldSize);
                System.arraycopy(aParentListeners, 0, temp, nOldSize, aParentListeners.length);
                aListeners = temp;
            } else {
                aListeners = aParentListeners;
            }
            this.m_hmListenersIndexs.put(sKey, aListeners);
            aParentListeners = null;
            temp = null;
        }
        this.m_hmStatus.put(sKey, Boolean.TRUE);
        return aListeners;
    }

    private IObjectLCListener[] getParentListeners(int _nEventType, Class _oClass) {
        Class supperClass;
        if (_oClass == null) {
            return null;
        }
        Class<?>[] aParentClasses = _oClass.getInterfaces();
        if (!_oClass.isInterface() && (supperClass = _oClass.getSuperclass()) != null) {
            if (aParentClasses == null || aParentClasses.length == 0) {
                aParentClasses = new Class[]{supperClass};
            } else {
                Class[] temp = new Class[aParentClasses.length + 1];
                System.arraycopy(aParentClasses, 0, temp, 0, aParentClasses.length);
                temp[aParentClasses.length] = supperClass;
                aParentClasses = temp;
                temp = null;
            }
        }
        ArrayList<IObjectLCListener> m_lParentListeners = new ArrayList<IObjectLCListener>();
        if (aParentClasses != null && aParentClasses.length > 0) {
            for (int i = 0; i < aParentClasses.length; ++i) {
                IObjectLCListener[] aParentListeners = null;
                aParentListeners = this.getListenersByTypeAndClass(_nEventType, aParentClasses[i]);
                List<IObjectLCListener> parentListeners = this.getListenersCanUsedInChildern(_nEventType, aParentClasses[i], aParentListeners);
                if (parentListeners.size() == 0) continue;
                m_lParentListeners.addAll(parentListeners);
            }
        }
        if (m_lParentListeners.size() == 0) {
            return null;
        }
        Object[] objects = m_lParentListeners.toArray();
        IObjectLCListener[] aIObjectLCListeners = new IObjectLCListener[m_lParentListeners.size()];
        System.arraycopy(objects, 0, aIObjectLCListeners, 0, objects.length);
        this.registerCanUsedInChildren(aIObjectLCListeners, _nEventType, _oClass.getName());
        return aIObjectLCListeners;
    }

    private void registerCanUsedInChildren(IObjectLCListener[] _aListeners, int _nEventType, String _sClassName) {
        if (_aListeners == null || _aListeners.length == 0 || _sClassName == null) {
            return;
        }
        for (int i = 0; i < _aListeners.length; ++i) {
            IObjectLCListener oListener = _aListeners[i];
            if (oListener == null) continue;
            String sKey = this.makeKey(_nEventType, _sClassName);
            String sCheckKey = this.makeKey(sKey, oListener.getClass().getName());
            this.m_hmCanUsedInChildren.put(sCheckKey, Boolean.TRUE);
        }
    }

    private List<IObjectLCListener> getListenersCanUsedInChildern(int _nEventType, Class _oClass, IObjectLCListener[] _aListeners) {
        ArrayList<IObjectLCListener> oListeners = new ArrayList<IObjectLCListener>();
        if (this.m_hmCanUsedInChildren == null || _oClass == null) {
            return oListeners;
        }
        String sKey = this.makeKey(_nEventType, _oClass.getName());
        if (_aListeners == null) {
            _aListeners = (IObjectLCListener[])this.getListenersIndexs().get(sKey);
        }
        if (_aListeners == null || _aListeners.length == 0) {
            return oListeners;
        }
        for (IObjectLCListener oListener : _aListeners) {
            String sCheckKey = this.makeKey(sKey, oListener.getClass().getName());
            if (!this.m_hmCanUsedInChildren.containsKey(sCheckKey)) continue;
            oListeners.add(oListener);
        }
        return oListeners;
    }

    public IObjectLCListener[] getListeners(int _nEventType, Class _objClass) {
        return (IObjectLCListener[])this.getListenersIndexs().get(this.makeKey(_nEventType, _objClass.getName()));
    }

    public boolean isDoNotify(int _nEventType, BaseObj _currObj) {
        return this.getListenersIndexs().containsKey(this.makeKey(_nEventType, _currObj.getClass().getName()));
    }

    private String makeKey(int eventType, String _sClassName) {
        return _sClassName + "_" + eventType;
    }

    private String makeKey(String _sPrefix, String _sListenerClassName) {
        return _sPrefix + "_" + _sListenerClassName;
    }

    @Override
    public void notifyOnBeforeAddObj(BaseObj _oObjAdded) throws WCMException {
        IObjectLCListener[] arListeners = this.getListeners(-1, _oObjAdded);
        for (int i = 0; i < arListeners.length; ++i) {
            try {
                ((IObjectLCListenerOnBeforeAdd)arListeners[i]).notifyOnBeforeAddObj(_oObjAdded);
                continue;
            }
            catch (ClassCastException e) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + arListeners[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnBeforeAdd.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"));
            }
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        IObjectLCListener[] arListeners = this.getListeners(1, _oObjAdded);
        for (int i = 0; i < arListeners.length; ++i) {
            try {
                ((IObjectLCListenerOnAdd)arListeners[i]).notifyOnAddObj(_oObjAdded);
                continue;
            }
            catch (ClassCastException e) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + arListeners[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnAdd.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"));
            }
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        IObjectLCListener[] arListeners = this.getListeners(_nEventType, _oObjDeleted);
        for (int i = 0; i < arListeners.length; ++i) {
            try {
                ((IObjectLCListenerOnDel)arListeners[i]).notifyOnDelObj(_oObjDeleted, _nEventType);
                continue;
            }
            catch (ClassCastException e) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + arListeners[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnDel.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"));
            }
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        IObjectLCListener[] arListeners = this.getListeners(_nEventType, _oObjModified);
        for (int i = 0; i < arListeners.length; ++i) {
            try {
                ((IObjectLCListenerOnModify)arListeners[i]).notifyOnModifyObj(_oObjModified, _nEventType);
                continue;
            }
            catch (ClassCastException e) {
                throw new WCMException(I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label1", "\u6307\u5b9a\u7684Listener[") + arListeners[i].getClass().getName() + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label2", "]\u4e0d\u662f[") + IObjectLCListenerOnModify.class + I18NMessage.get(ObjectLCMonitorServer.class, "ObjectLCMonitorServer.label3", "]\u7684\u5b9e\u73b0\uff01"), e);
            }
        }
    }

    private Map getListenersIndexs() {
        if (this.m_hmListenersIndexs == null) {
            this.loadConfig();
        }
        return this.m_hmListenersIndexs;
    }

    private void clear() {
        this.m_hmListenersIndexs.clear();
        this.m_hmListenersIndexs = null;
        if (this.m_hmCanUsedInChildren != null) {
            this.m_hmCanUsedInChildren.clear();
            this.m_hmCanUsedInChildren = null;
        }
        if (this.m_hmStatus != null) {
            this.m_hmStatus.clear();
            this.m_hmStatus = null;
        }
    }

    private void loadConfig() {
        if (this.m_hmListenersIndexs != null) {
            return;
        }
        List listConfig = XMLConfigServer.getInstance().getConfigObjects(MonitorHostConfig.class);
        this.m_hmListenersIndexs = new HashMap(listConfig.size());
        for (int i = 0; i < listConfig.size(); ++i) {
            this.loadListeners((MonitorHostConfig)listConfig.get(i));
        }
    }

    private void loadListeners(MonitorHostConfig _oMonitorHostConfig) {
        if (_oMonitorHostConfig.getListeners().size() <= 0) {
            return;
        }
        for (int i = 0; i < EVENT_TYPES.length; ++i) {
            List listeners = this.findListenerConfigsByEventType(EVENT_TYPES[i], _oMonitorHostConfig.getListeners());
            this.loadListeners(listeners, this.makeKey(EVENT_TYPES[i], _oMonitorHostConfig.getClassName()));
        }
    }

    private List findListenerConfigsByEventType(int _nEventType, List _lstAllListnerConfigs) {
        if (_lstAllListnerConfigs.size() <= 0) {
            return null;
        }
        ArrayList<ObjectLCListenerConfig> result = new ArrayList<ObjectLCListenerConfig>();
        block0: for (int i = 0; i < _lstAllListnerConfigs.size(); ++i) {
            ObjectLCListenerConfig aConfig = (ObjectLCListenerConfig)_lstAllListnerConfigs.get(i);
            int[] arEventTypes = null;
            String sEventType = aConfig.getEventType();
            arEventTypes = sEventType == null || sEventType.trim().length() == 0 ? EVENT_TYPES_DEFAULT : CMyString.splitToInt(sEventType, ",");
            for (int j = 0; j < arEventTypes.length; ++j) {
                if (arEventTypes[j] != _nEventType) continue;
                result.add(aConfig);
                continue block0;
            }
        }
        return result;
    }

    private void loadListeners(List _lsListenerConfigs, String _sKey) {
        int i;
        int nListenerCount = _lsListenerConfigs.size();
        if (nListenerCount <= 0) {
            return;
        }
        IObjectLCListener[] arOldListeners = (IObjectLCListener[])this.m_hmListenersIndexs.get(_sKey);
        if (arOldListeners == null) {
            arOldListeners = new IObjectLCListener[]{};
        }
        IObjectLCListener[] arListeners = new IObjectLCListener[nListenerCount + arOldListeners.length];
        for (i = 0; i < arOldListeners.length; ++i) {
            arListeners[i] = arOldListeners[i];
        }
        for (i = 0; i < nListenerCount; ++i) {
            ObjectLCListenerConfig aConfig = (ObjectLCListenerConfig)_lsListenerConfigs.get(i);
            arListeners[i + arOldListeners.length] = aConfig.getBean();
            if (aConfig.getUsedInChildren() == null || !"true".equalsIgnoreCase(aConfig.getUsedInChildren())) continue;
            if (this.m_hmCanUsedInChildren == null) {
                this.m_hmCanUsedInChildren = new HashMap<String, Boolean>();
            }
            String ssKey = this.makeKey(_sKey, aConfig.getBean().getClass().getName());
            this.m_hmCanUsedInChildren.put(ssKey, Boolean.TRUE);
        }
        this.m_hmListenersIndexs.put(_sKey, arListeners);
        arOldListeners = null;
    }

    public Map getListenersMap() {
        return this.m_hmListenersIndexs;
    }

    @Override
    protected void doShutdown() {
        this.clear();
    }

    @Override
    protected boolean doStart() {
        this.loadConfig();
        return true;
    }
}

