/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.config.domain;

import com.trs.infra.I18NMessage;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.config.persistent.ConfigFiles;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.XmlDocWithDom4j;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xml.sax.InputSource;

public class ConfigHelper {
    private static Logger logger = Logger.getLogger(ConfigHelper.class);
    public static boolean RUN_IN_ECLISPE = false;
    private static ArrayList<String> s_arDomainConfigPaths = new ArrayList();
    private static ArrayList<String> s_arServiceConfigPaths = new ArrayList();
    private static ArrayList<String> s_arClassPaths = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getDomainConfigPaths() {
        if (s_arDomainConfigPaths.isEmpty()) {
            ArrayList<String> arrayList = s_arDomainConfigPaths;
            synchronized (arrayList) {
                if (!s_arDomainConfigPaths.isEmpty()) {
                    return s_arDomainConfigPaths;
                }
                ArrayList<String> arTemp = new ArrayList<String>();
                boolean bRunInEclipse = RUN_IN_ECLISPE;
                String[] pClassPaths = ConfigHelper.splitClassPathFromProperty();
                for (int i = 0; i < pClassPaths.length; ++i) {
                    File path;
                    String sClassPath = pClassPaths[i];
                    File file = new File(sClassPath);
                    if (!file.isDirectory()) continue;
                    sClassPath = file.getAbsolutePath();
                    if (!bRunInEclipse && sClassPath.endsWith(".cp")) {
                        bRunInEclipse = true;
                        continue;
                    }
                    if (!sClassPath.endsWith(File.separator)) {
                        sClassPath = sClassPath + File.separator;
                    }
                    if (!(path = new File(sClassPath = sClassPath + "trsconfig" + File.separator + "domain" + File.separator)).exists()) continue;
                    arTemp.add(sClassPath);
                }
                if (!bRunInEclipse) {
                    arTemp = new ArrayList();
                    arTemp.add(ConfigConstants.getConfigRootPath());
                }
                s_arDomainConfigPaths = arTemp;
            }
        }
        return s_arDomainConfigPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getClassPaths() {
        if (s_arClassPaths.isEmpty()) {
            ArrayList<String> arrayList = s_arClassPaths;
            synchronized (arrayList) {
                if (!s_arClassPaths.isEmpty()) {
                    return s_arClassPaths;
                }
                ArrayList<String> arTemp = new ArrayList<String>();
                boolean bRunInEclipse = RUN_IN_ECLISPE;
                String[] pClassPaths = ConfigHelper.splitClassPathFromProperty();
                for (int i = 0; i < pClassPaths.length; ++i) {
                    String sClassPath = pClassPaths[i];
                    File file = new File(sClassPath);
                    if (!file.isDirectory()) continue;
                    sClassPath = file.getAbsolutePath();
                    if (!bRunInEclipse && sClassPath.endsWith(".cp")) {
                        bRunInEclipse = true;
                        continue;
                    }
                    if (!sClassPath.endsWith(File.separator)) {
                        sClassPath = sClassPath + File.separator;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("find classpath:[" + sClassPath + "]"));
                    }
                    arTemp.add(sClassPath);
                }
                if (!bRunInEclipse) {
                    arTemp = new ArrayList();
                    arTemp.add(TRSConfigServer.getAppRootPath());
                }
                s_arClassPaths = arTemp;
            }
        }
        return s_arClassPaths;
    }

    private static String[] splitClassPathFromProperty() {
        Properties sysProperties = System.getProperties();
        String[] pClassPaths = null;
        String sClassPathOfProperties = sysProperties.getProperty("java.class.path");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sClassPathOfProperties);
        }
        pClassPaths = sClassPathOfProperties.indexOf(";") >= 0 ? sClassPathOfProperties.split(";") : (sClassPathOfProperties.indexOf(":") >= 0 ? sClassPathOfProperties.split(":") : new String[]{sClassPathOfProperties});
        return pClassPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getServiceConfigPaths() {
        if (s_arServiceConfigPaths.isEmpty()) {
            ArrayList<String> arrayList = s_arServiceConfigPaths;
            synchronized (arrayList) {
                if (!s_arServiceConfigPaths.isEmpty()) {
                    return s_arServiceConfigPaths;
                }
                ArrayList<String> arTemp = new ArrayList<String>();
                boolean bRunInEclipse = RUN_IN_ECLISPE;
                String[] pClassPaths = ConfigHelper.splitClassPathFromProperty();
                for (int i = 0; i < pClassPaths.length; ++i) {
                    File path;
                    String sClassPath = pClassPaths[i];
                    File file = new File(sClassPath);
                    if (!file.isDirectory()) continue;
                    sClassPath = file.getAbsolutePath();
                    if (!bRunInEclipse && sClassPath.endsWith(".cp")) {
                        bRunInEclipse = true;
                        continue;
                    }
                    if (!sClassPath.endsWith(File.separator)) {
                        sClassPath = sClassPath + File.separator;
                    }
                    if (!(path = new File(sClassPath = sClassPath + "trsconfig" + File.separator)).exists()) continue;
                    arTemp.add(sClassPath);
                }
                if (!bRunInEclipse) {
                    arTemp = new ArrayList();
                    arTemp.add(TRSConfigServer.getConfigRootPath());
                }
                s_arServiceConfigPaths = arTemp;
            }
        }
        return s_arServiceConfigPaths;
    }

    public static Document toXMLDocument(File _file) throws CMyException {
        if (_file == null) {
            throw new CMyException(20, I18NMessage.get(ConfigHelper.class, "ConfigHelper.label1", "\u6307\u5b9a\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728!"));
        }
        try {
            return XmlDocWithDom4j.parse(_file.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new CMyException(150, I18NMessage.get(ConfigHelper.class, "ConfigHelper.label2", "\u5efa\u7acbXML Document\u5bf9\u8c61\u5931\u8d25!"), ex);
        }
    }

    public static InputSource getMappingSource(ConfigFiles _configFiles) throws CMyException {
        Document coreMapDoc = ConfigHelper.getMappingDoc(ConfigConstants.getAbsoluteFileNameOfCoreMapping());
        Document pluginMapDoc = null;
        for (int i = 0; i < _configFiles.size(); ++i) {
            FileStore fMapping = _configFiles.get(i).getMapping();
            if (fMapping == null || fMapping.getPath().compareTo(ConfigConstants.getAbsoluteFileNameOfCoreMapping()) == 0) continue;
            pluginMapDoc = ConfigHelper.getMappingDoc(fMapping.getPath());
            List nodeList = pluginMapDoc.getRootElement().elements("class");
            int nodeIndex = nodeList.size();
            while (nodeIndex > 0) {
                Element node = (Element)nodeList.get(--nodeIndex);
                node.getParent().remove(node);
                coreMapDoc.getRootElement().add(node);
            }
        }
        return ConfigHelper.toFileInputSrcFromXmlDocument(coreMapDoc);
    }

    public static InputSource getMappingSource(String _sMappingFile) throws CMyException {
        return ConfigHelper.toFileInputSrcFromXmlDocument(ConfigHelper.getMappingDoc(_sMappingFile));
    }

    private static InputSource toFileInputSrcFromXmlDocument(Document _oXmlDoc) {
        return new InputSource(new StringReader(_oXmlDoc.asXML()));
    }

    private static Document getMappingDoc(String _sMappingFile) throws CMyException {
        Document result = null;
        try {
            logger.debug((Object)("Loading the mapping file[" + _sMappingFile + "]"));
            result = XmlDocWithDom4j.parse(_sMappingFile);
        }
        catch (Exception ex) {
            if (_sMappingFile.compareTo(ConfigConstants.getAbsoluteFileNameOfCoreMapping()) == 0) {
                return ConfigHelper.getEmptyXMLDocument();
            }
            throw new CMyException(I18NMessage.get(ConfigHelper.class, "ConfigHelper.label3", "\u8bfb\u53d6\u6216\u89e3\u6790\u6587\u4ef6[") + _sMappingFile + I18NMessage.get(ConfigHelper.class, "ConfigHelper.label4", "]\u65f6\u51fa\u9519"), ex);
        }
        return result;
    }

    private static Document getEmptyXMLDocument() {
        return DocumentHelper.createDocument();
    }
}

