/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index;

import com.trs.components.wcm.content.ViewDocuments;
import com.trs.index.LuceneContext;
import com.trs.index.util.IndexUtil;
import com.trs.index.vo.IndexField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public class Producer
implements Runnable {
    private volatile boolean isRunning = true;
    private BlockingQueue<IndexField> queue;
    private int startRange;
    private int endRange;
    private static Logger m_oLogger = Logger.getLogger(Producer.class);

    public Producer(BlockingQueue<IndexField> queue, int startRange, int endRange) {
        this.queue = queue;
        this.startRange = startRange;
        this.endRange = endRange;
    }

    @Override
    public void run() {
        m_oLogger.debug((Object)("\u542f\u52a8\u751f\u4ea7\u8005\u7ebf\u7a0b:" + Thread.currentThread().getName()));
        try {
            while (this.isRunning) {
                String strSQL = LuceneContext.getInstance().getIndexConfig().getSql() + " AND WCMDOCUMENT.DOCID >= ? and WCMDOCUMENT.DOCID <= ?";
                int rangSize = (this.endRange - this.startRange) / 3000 + 1;
                for (int i = 0; i < rangSize; ++i) {
                    DebugTimer aTimer1 = new DebugTimer();
                    aTimer1.start();
                    int start = this.startRange + i * 3000 + i;
                    int end = start + 3000;
                    if (rangSize == 1 || end > this.endRange) {
                        end = this.endRange;
                    }
                    Connection oConn = null;
                    PreparedStatement oPreStmt = null;
                    ResultSet rsData = null;
                    ResultSetMetaData rsmdData = null;
                    try {
                        oConn = DBManager.getDBManager().getConnection();
                        oPreStmt = oConn.prepareStatement(strSQL);
                        oPreStmt.setInt(1, start);
                        oPreStmt.setInt(2, end);
                        rsData = oPreStmt.executeQuery();
                        while (rsData.next()) {
                            if (rsmdData == null) {
                                rsmdData = rsData.getMetaData();
                            }
                            IndexField indexField = IndexUtil.readData(rsData, rsmdData);
                            this.queue.put(indexField);
                        }
                        rsData.close();
                        aTimer1.stop();
                        continue;
                    }
                    catch (SQLException ex) {
                        throw new WCMException(40, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label2", "\u9884\u5148\u8bfb\u5165\u5c0f\u6570\u636e\u53d1\u751f\u6570\u636e\u5e93\u5f02\u5e38\uff08") + this.getClass().getName() + ".refresh)\uff1a\n", ex);
                    }
                    catch (Exception ex) {
                        throw new WCMException(0, I18NMessage.get(ViewDocuments.class, "ViewDocuments.label3", "\u5237\u65b0\u96c6\u5408\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)", ex);
                    }
                    finally {
                        try {
                            if (oPreStmt != null) {
                                oPreStmt.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (oConn != null) {
                            DBManager.getDBManager().freeConnection(oConn);
                        }
                    }
                }
                m_oLogger.debug((Object)("\u751f\u4ea7\u8005\u7ebf\u7a0b:" + Thread.currentThread().getName() + "\u8bfb\u53d6\u6570\u636e\u5b8c\u6bd5\uff0c\u505c\u6b62\u8bfb\u53d6"));
                this.stop();
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
            m_oLogger.debug((Object)("\u51fa\u73b0\u5f02\u5e38:" + e));
        }
    }

    public void stop() {
        this.isRunning = false;
    }
}

