/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index;

import com.chenlb.mmseg4j.analysis.ComplexAnalyzer;
import com.trs.index.config.IndexConfig;
import com.trs.index.config.TableDesc;
import com.trs.index.config.TableFieldDesc;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NRTManager;
import org.apache.lucene.search.NRTManagerReopenThread;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SearcherWarmer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class LuceneContext {
    private static LuceneContext instance;
    private static IndexWriter writer;
    private static Analyzer analyzer;
    private static Version version;
    private static NRTManager nrtMgr;
    private static SearcherManager mgr;
    private static Directory directory;
    private static Directory[] tempDirectory;
    private static IndexWriter[] tempWriter;
    private static int tempIndexNum;
    private static IndexConfig indexConfig;
    private static Logger m_oLogger;

    private LuceneContext() throws WCMException {
        LuceneContext.loadXml();
    }

    private static void loadXml() throws WCMException {
        String luceneConfig = LuceneContext.class.getClassLoader().getResource("lucene.xml").getPath();
        m_oLogger.info((Object)("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6" + luceneConfig));
        SAXReader read = new SAXReader();
        try {
            Node whereNode;
            indexConfig = new IndexConfig();
            Document document = read.read(luceneConfig);
            Element root = document.getRootElement();
            Node indexPathNode = root.selectSingleNode("//indexPath");
            if (indexPathNode == null) {
                throw new WCMException("\u6ca1\u6709\u914d\u7f6eindexPath\u7d22\u5f15\u5e93\u4f4d\u7f6e");
            }
            indexConfig.setIndexPath(indexPathNode.getText());
            Node relationNode = root.selectSingleNode("//relation");
            if (relationNode != null) {
                indexConfig.setRelative(relationNode.getText());
            }
            if ((whereNode = root.selectSingleNode("//where")) != null) {
                indexConfig.setWhere(whereNode.getText());
            }
            List tableNodes = root.selectNodes("tables/table");
            ArrayList<TableDesc> tableDescList = new ArrayList<TableDesc>();
            for (int i = 0; i < tableNodes.size(); ++i) {
                TableDesc tableDesc = new TableDesc();
                ArrayList<TableFieldDesc> tableFieldDescList = new ArrayList<TableFieldDesc>();
                Element tableELement = (Element)tableNodes.get(i);
                tableDesc.setTableName(tableELement.attributeValue("name"));
                List fieldList = tableELement.selectNodes("field");
                for (int j = 0; j < fieldList.size(); ++j) {
                    Element fieldElement = (Element)fieldList.get(j);
                    TableFieldDesc tableFieldDesc = new TableFieldDesc();
                    String name = fieldElement.attributeValue("name");
                    String index = fieldElement.attributeValue("index");
                    String store = fieldElement.attributeValue("store");
                    String analyzed = fieldElement.attributeValue("analyzed");
                    String type = fieldElement.attributeValue("type");
                    String key = fieldElement.attributeValue("key").toUpperCase();
                    String occur = fieldElement.attributeValue("occur");
                    String start = fieldElement.attributeValue("start");
                    String end = fieldElement.attributeValue("end");
                    String interval = fieldElement.attributeValue("interval");
                    String quickQuery = fieldElement.attributeValue("quickQuery");
                    String sort = fieldElement.attributeValue("sort");
                    if (!CMyString.isEmpty(sort)) {
                        boolean sortBy = false;
                        int sortFileType = 3;
                        if ("desc".equals(sort)) {
                            sortBy = true;
                        }
                        if ("int".equalsIgnoreCase(type)) {
                            sortFileType = 4;
                        } else if ("date".equalsIgnoreCase(type) || "long".equalsIgnoreCase(type)) {
                            sortFileType = 6;
                        }
                        Sort sortFile = new Sort(new SortField(key.toUpperCase(), sortFileType, sortBy));
                        indexConfig.setSortFile(sortFile);
                    }
                    tableFieldDesc.setFieldName(name);
                    if ("yes".equalsIgnoreCase(index)) {
                        tableFieldDesc.setIndex(true);
                    } else {
                        tableFieldDesc.setIndex(false);
                    }
                    if ("yes".equalsIgnoreCase(store)) {
                        tableFieldDesc.setStore(true);
                    } else {
                        tableFieldDesc.setStore(false);
                    }
                    if ("yes".equalsIgnoreCase(analyzed)) {
                        tableFieldDesc.setAnalyzed(true);
                    } else {
                        tableFieldDesc.setAnalyzed(false);
                    }
                    if ("yes".equalsIgnoreCase(quickQuery)) {
                        tableFieldDesc.setQuickQuery(true);
                    } else {
                        tableFieldDesc.setQuickQuery(false);
                    }
                    tableFieldDesc.setType(type);
                    tableFieldDesc.setKey(key);
                    tableFieldDesc.setOccur(occur);
                    tableFieldDesc.setStart(start);
                    tableFieldDesc.setEnd(end);
                    tableFieldDesc.setInterval(interval);
                    tableFieldDescList.add(tableFieldDesc);
                }
                tableDesc.setTableFieldDescList(tableFieldDescList);
                tableDescList.add(tableDesc);
            }
            indexConfig.setTableDescList(tableDescList);
        }
        catch (DocumentException e) {
            m_oLogger.info((Object)("\u89e3\u6790\u5f02\u5e38" + e.getMessage()));
        }
    }

    public static LuceneContext getInstance() {
        if (instance == null) {
            try {
                instance = new LuceneContext();
            }
            catch (WCMException e) {
                e.printStackTrace();
            }
            LuceneContext.init();
        }
        return instance;
    }

    private static void init() {
        try {
            directory = FSDirectory.open((File)new FileWrapper(new FileService(indexConfig.getIndexPath())));
            version = Version.LUCENE_35;
            String dicUrl = LuceneContext.class.getClassLoader().getResource("data").getPath();
            analyzer = new ComplexAnalyzer(dicUrl);
            LogDocMergePolicy mergePolicy = new LogDocMergePolicy();
            mergePolicy.setMergeFactor(30);
            mergePolicy.setMaxMergeDocs(10000);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(version, analyzer);
            indexWriterConfig.setMergePolicy((MergePolicy)mergePolicy);
            indexWriterConfig.setRAMBufferSizeMB(100.0);
            indexWriterConfig.setMaxThreadStates(100);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            writer = new IndexWriter(directory, indexWriterConfig);
            nrtMgr = new NRTManager(writer, new SearcherWarmer(){

                public void warm(IndexSearcher arg0) throws IOException {
                }
            });
            mgr = nrtMgr.getSearcherManager(true);
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            NRTManagerReopenThread reopenThread = new NRTManagerReopenThread(nrtMgr, 5.0, 0.025);
            reopenThread.setName("NRTManager reopen thread");
            reopenThread.setDaemon(true);
            reopenThread.start();
        }
        catch (IOException e) {
            m_oLogger.info((Object)("io \u5f02\u5e38" + e.getMessage()));
        }
    }

    private Directory[] initTempFSDirectory() throws IOException {
        tempDirectory = new FSDirectory[tempIndexNum];
        for (int i = 0; i < tempIndexNum; ++i) {
            String fileName = indexConfig.getIndexPath() + File.separator + "tempIndex" + File.separator + i;
            FileService file = new FileService(fileName);
            if (!file.exists()) {
                file.mkdirs();
            }
            LuceneContext.tempDirectory[i] = FSDirectory.open((File)new FileWrapper(file));
        }
        return tempDirectory;
    }

    public IndexConfig getIndexConfig() {
        return indexConfig;
    }

    public IndexWriter[] getTempIndexWriters() {
        if (tempWriter != null) {
            return tempWriter;
        }
        tempWriter = new IndexWriter[tempIndexNum];
        try {
            this.initTempFSDirectory();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < tempIndexNum; ++i) {
            try {
                LuceneContext.tempWriter[i] = new IndexWriter(tempDirectory[i], new IndexWriterConfig(version, analyzer).setRAMBufferSizeMB(10.0));
                continue;
            }
            catch (CorruptIndexException e) {
                e.printStackTrace();
                continue;
            }
            catch (LockObtainFailedException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempWriter;
    }

    public String getIndexPath() {
        return indexConfig.getIndexPath();
    }

    public IndexSearcher getSearcher() {
        return mgr.acquire();
    }

    public void releaseSearcher(IndexSearcher searcher) {
        try {
            mgr.release(searcher);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setTempWriter(IndexWriter[] _tempWriter) {
        tempWriter = _tempWriter;
    }

    public IndexWriter getIndexWriter() {
        return writer;
    }

    public void commitIndex() {
        try {
            m_oLogger.info((Object)"\u6b63\u5728\u63d0\u4ea4\u7d22\u5f15\u4fe1\u606f");
            writer.commit();
            writer.forceMerge(10);
            m_oLogger.info((Object)"\u7d22\u5f15\u63d0\u4ea4\u5b8c\u6bd5");
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Directory[] getTempDirectory() {
        return tempDirectory;
    }

    public NRTManager getNRTManager() {
        return nrtMgr;
    }

    public Version getVersion() {
        return version;
    }

    public Analyzer getAnalyzer() {
        return analyzer;
    }

    public int getTempIndexNum() {
        return tempIndexNum;
    }

    public void setTempIndexNum(int tempIndexNum) {
        LuceneContext.tempIndexNum = tempIndexNum;
    }

    static {
        tempIndexNum = 10;
        m_oLogger = Logger.getLogger(LuceneContext.class);
    }
}

