/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ora2DB2Convertor {
    private static final Pattern PATTERN = Pattern.compile("sysdate", 2);
    private static final Pattern PTODATE = Pattern.compile("to_date\\s*\\(.+\\s*\\)", 2);
    private static final Pattern PADD = Pattern.compile("ADD\\s*\\(.+\\s*\\)", 2);
    private static final String TYPEMAP_CONF = "/mapping.properties";
    private static final String[] ORATYPES = new String[]{"NUMBER", "VARCHAR", "VARCHAR2", "DATE", "CLOB"};
    private static final List TYPES = Arrays.asList(ORATYPES);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("No oracle sql provided.");
            System.exit(1);
        }
        String fn = args[0];
        try {
            if (!"true".equals(System.getProperty("std"))) {
                System.setOut(new PrintStream(new FileService(fn + ".db2").getOutputStream()));
            }
        }
        catch (Exception ex) {
            System.out.println("Can't print to file,ingnore." + ex);
        }
        InputStream ins = null;
        BufferedReader reader = null;
        InputStreamReader insr = null;
        try {
            ins = new FileService(fn).getInputStream();
            insr = new InputStreamReader(ins);
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            StringBuffer buff = new StringBuffer(128);
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '-') {
                    System.out.println(line);
                } else {
                    buff.append(line).append(' ');
                    if (line.charAt(line.length() - 1) == ';') {
                        System.out.println(Ora2DB2Convertor.format(buff.toString()));
                        buff.setLength(0);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String format(String line) {
        if ((line = line.trim().replace('\t', ' ')).length() < 6) {
            return line;
        }
        String flag = line.substring(0, 6).trim().toLowerCase();
        if ("create".equals(flag) || "alter".equals(flag)) {
            StringBuffer buff = new StringBuffer(128);
            char[] chars = line.toCharArray();
            StringBuffer temp = new StringBuffer(32);
            char achar = '\u0000';
            boolean zend = false;
            String word = null;
            int ix = -1;
            int len = chars.length;
            for (int i = 0; i < len; ++i) {
                achar = chars[i];
                while (!zend && i < len - 1) {
                    temp.append(achar);
                    achar = chars[++i];
                    zend = achar == ' ' || achar == '(' || achar == ',' || achar == ')' || achar == ';';
                }
                zend = false;
                word = temp.toString().trim().toUpperCase();
                temp.setLength(0);
                ix = TYPES.indexOf(word);
                if (ix != -1) {
                    switch (ix) {
                        case 0: {
                            boolean bl = zend = achar == '(' || achar == ',';
                            while (!zend && i < len - 1) {
                                zend = (achar = chars[++i]) != ' ' || achar == '(' || achar == ',';
                            }
                            zend = false;
                            if (achar == '(') {
                                int p = 0;
                                int s = 0;
                                while (!zend && i < len - 1) {
                                    if (zend = (achar = chars[++i]) == ')' || achar == ',') continue;
                                    temp.append(achar);
                                }
                                zend = false;
                                if (achar == ',') {
                                    p = Integer.parseInt(temp.toString().trim());
                                    temp.setLength(0);
                                    while (!zend && i < len - 1) {
                                        if (zend = (achar = chars[++i]) == ')') continue;
                                        temp.append(achar);
                                    }
                                    zend = false;
                                    s = Integer.parseInt(temp.toString().trim());
                                    temp.setLength(0);
                                    if (s != 0) {
                                        buff.append("DECIMAL(");
                                        buff.append(p).append(',').append(s);
                                        buff.append(") ");
                                        break;
                                    }
                                    if (p < 10) {
                                        buff.append("INTEGER ");
                                        break;
                                    }
                                    if (p < 19) {
                                        buff.append("BIGINT ");
                                        break;
                                    }
                                    buff.append("DECIMAL(").append(p);
                                    buff.append(",0) ");
                                    break;
                                }
                                buff.append("DECIMAL(").append(temp);
                                buff.append(",0) ");
                                break;
                            }
                            buff.append("DECIMAL(38,0) ");
                            if (achar != ',') {
                                --i;
                                break;
                            }
                            buff.append(achar);
                            break;
                        }
                        case 1: 
                        case 2: {
                            buff.append("VARCHAR");
                            while (achar != ')') {
                                buff.append(achar);
                                achar = chars[++i];
                            }
                            buff.append(") ");
                            break;
                        }
                        case 3: {
                            buff.append("TIMESTAMP");
                            boolean bl = zend = achar == ',' || achar == ')';
                            while (!zend && i < len - 1) {
                                zend = (achar = chars[++i]) != ' ' || achar == ',';
                            }
                            zend = false;
                            if (achar == ',' || achar == ')') {
                                buff.append(achar);
                                break;
                            }
                            buff.append(' ');
                            --i;
                            break;
                        }
                        case 4: {
                            buff.append("CLOB");
                            boolean bl = zend = achar == ',' || achar == ')';
                            while (!zend && i < len - 1) {
                                zend = (achar = chars[++i]) != ' ' || achar == ',';
                            }
                            zend = false;
                            if (achar == ',' || achar == ')') {
                                buff.append(achar);
                                break;
                            }
                            buff.append(' ');
                            --i;
                            break;
                        }
                    }
                    continue;
                }
                buff.append(word).append(achar);
            }
            line = buff.toString();
            Matcher matcher = PADD.matcher(line = PATTERN.matcher(line).replaceAll("current timestamp"));
            if (matcher.find()) {
                String group = matcher.group();
                String grouptemp = group.replaceFirst("\\(", " ");
                ix = line.indexOf(group);
                line = line.substring(0, ix) + grouptemp.substring(0, grouptemp.length() - 1) + line.substring(ix + group.length());
            }
            return line.replaceAll("NOT NULL ENABLE", "NOT NULL");
        }
        Matcher matcher = PTODATE.matcher(line = PATTERN.matcher(line).replaceAll("current timestamp"));
        if (matcher.find()) {
            String group = matcher.group();
            String datetime = group.split("'")[1];
            int ix = line.indexOf(group);
            line = line.substring(0, ix) + "'" + datetime + "'" + line.substring(ix + group.length() - 1);
        }
        return line;
    }
}

