/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.infra.util.store.FileService;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;

public class DbDDLMaker {
    private static final String DB_CONF = "/database.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            InputStream ins = null;
            if (args.length == 0) {
                Class<DbDDLMaker> clazz = DbDDLMaker.class;
                ins = clazz.getResourceAsStream(DB_CONF);
                if (ins == null) {
                    ins = clazz.getResourceAsStream(DB_CONF.substring(1));
                }
            } else {
                ins = new FileService(args[0]).getInputStream();
            }
            Properties props = new Properties();
            try {
                props.load(ins);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
            }
            String username = props.getProperty("sql.dbuser");
            String password = props.getProperty("sql.dbpwd");
            String url = props.getProperty("sql.dburl");
            String driver = props.getProperty("sql.dbdriver");
            Class.forName(driver);
            String dbtype = props.getProperty("sql.dbtarget");
            if (args.length > 1) {
                dbtype = args[1];
            }
            dbtype = dbtype.toLowerCase() + ".";
            boolean doublelen = "true".equals(props.getProperty("sql.doublelen"));
            doublelen = doublelen && !dbtype.equals("mssql.");
            Connection conn = DriverManager.getConnection(url, username, password);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String tableNamePattern = props.getProperty("sql.tableNamePattern");
            if (tableNamePattern == null) {
                tableNamePattern = "%";
            }
            ResultSet tables = dbMetaData.getTables(null, null, tableNamePattern, new String[]{"TABLE"});
            ResultSet columns = null;
            String tableName = null;
            String colName = null;
            int colType = 0;
            int colSize = 0;
            String def = null;
            ResultSet pks = null;
            String pk = null;
            StringBuffer buff = new StringBuffer(128);
            boolean zNotFirst = false;
            boolean zCharType = false;
            String typeName = null;
            boolean useNull = "true".equals(props.getProperty(dbtype + "useNull"));
            while (tables.next()) {
                tableName = tables.getString(3).toUpperCase();
                buff.setLength(0);
                buff.append("CREATE TABLE ");
                buff.append('\"');
                buff.append(tableName);
                buff.append('\"');
                buff.append("(\n");
                pk = "";
                pks = dbMetaData.getPrimaryKeys(null, null, tableName);
                while (pks.next()) {
                    pk = pk + ",\"" + pks.getString("COLUMN_NAME") + "\"";
                }
                pks.close();
                columns = dbMetaData.getColumns(null, null, tableName, null);
                zNotFirst = false;
                while (columns.next()) {
                    if (zNotFirst) {
                        buff.append(",\n");
                    }
                    colName = columns.getString("COLUMN_NAME").toUpperCase();
                    buff.append("\t");
                    buff.append('\"');
                    buff.append(colName);
                    buff.append('\"');
                    buff.append(" ");
                    typeName = columns.getString("TYPE_NAME").toUpperCase();
                    typeName = (String)props.get(dbtype + typeName);
                    if (typeName == null) {
                        typeName = columns.getString("TYPE_NAME").toUpperCase();
                    }
                    buff.append(typeName.toUpperCase());
                    colType = columns.getInt("DATA_TYPE");
                    boolean bl = zCharType = 1 == colType || 12 == colType;
                    if (zCharType) {
                        buff.append("(");
                        colSize = columns.getInt("COLUMN_SIZE");
                        if (doublelen) {
                            colSize = Math.min(colSize * 2, 4000);
                        }
                        buff.append(colSize);
                        buff.append(")");
                    } else if (colType == 2) {
                        buff.append("(");
                        buff.append(columns.getInt("COLUMN_SIZE"));
                        buff.append(',');
                        buff.append(columns.getInt("DECIMAL_DIGITS"));
                        buff.append(")");
                    }
                    def = columns.getString("COLUMN_DEF");
                    if (def != null) {
                        def = def.substring(1, def.length() - 1);
                        if (!zCharType) {
                            if (def.charAt(0) == 'g') {
                                def = props.getProperty(dbtype + "getdate");
                            } else {
                                while (def.indexOf(40) != -1) {
                                    def = def.substring(1, def.length() - 1);
                                }
                            }
                        } else if (def.indexOf(39) == -1) {
                            def = '\'' + def + '\'';
                        }
                        buff.append(" DEFAULT ").append(def);
                    }
                    if (!"YES".equals(columns.getString("IS_NULLABLE"))) {
                        buff.append(" NOT NULL");
                    } else if (useNull && pk.indexOf(colName) == -1) {
                        buff.append(" NULL");
                    }
                    zNotFirst = true;
                }
                columns.close();
                if (pk.length() > 1) {
                    buff.append(",\n\tPRIMARY KEY (");
                    buff.append(pk.substring(1).toUpperCase());
                    buff.append(")");
                }
                buff.append("\n);\n");
                System.out.println(buff);
            }
            tables.close();
            props.clear();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

