/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;

public class DataDictionary {
    private static final String DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    private static final String FILE_NAME = "/template.html";
    private static final String[] TABLE = new String[]{"TABLE"};
    private static final int NCHAR = -15;
    private static final int NVARCHAR = -9;
    private Connection conn = null;
    private String template = null;

    public DataDictionary(String url, String user, String passwd) throws Exception {
        Class.forName(DRIVER);
        this.conn = DriverManager.getConnection(url, user, passwd);
        this.load();
    }

    public void makeDic() throws Exception {
        DatabaseMetaData metaData = this.conn.getMetaData();
        ResultSet tables = metaData.getTables(null, null, "%WCM%", TABLE);
        String tableName = null;
        StringBuffer buff = new StringBuffer(256);
        ResultSet columns = null;
        String colName = null;
        String pkCol = null;
        ResultSet pks = null;
        while (tables.next()) {
            tableName = tables.getString("TABLE_NAME");
            pks = metaData.getPrimaryKeys(null, null, tableName);
            pkCol = pks.next() ? pks.getString("COLUMN_NAME").toUpperCase() : null;
            columns = metaData.getColumns(null, null, tableName, null);
            while (columns.next()) {
                colName = columns.getString("COLUMN_NAME").toUpperCase();
                int type = columns.getInt("DATA_TYPE");
                buff.append("<tr>");
                buff.append("\n\t<td>");
                buff.append(colName);
                if (colName.equals(pkCol)) {
                    buff.append("<img src='css/pk.gif'/>");
                }
                buff.append("</td>");
                if ("CRUSER".equals(colName)) {
                    buff.append("\n\t<td>\u5bf9\u8c61\u521b\u5efa\u8005</td>");
                } else if ("CRTIME".equals(colName)) {
                    buff.append("\n\t<td>\u5bf9\u8c61\u521b\u5efa\u65f6\u95f4</td>");
                } else if ("ATTRIBUTE".equals(colName)) {
                    buff.append("\n\t<td>\u6269\u5c55\u5c5e\u6027</td>");
                } else {
                    buff.append("\n\t<td>--\u5217\u8bf4\u660e--</td>");
                }
                buff.append("\n\t<td>");
                buff.append(this.showNull(columns.getString("COLUMN_DEF")));
                buff.append("</td>");
                buff.append("\n\t<td>");
                if ("YES".equals(columns.getString("IS_NULLABLE"))) {
                    buff.append("<img src='css/yes.gif'/>");
                }
                buff.append("</td>");
                buff.append("\n\t<td>");
                buff.append(columns.getString("TYPE_NAME"));
                buff.append("</td>");
                buff.append("\n\t<td>");
                if (12 == type || 1 == type || -15 == type || -9 == type) {
                    buff.append(columns.getInt("COLUMN_SIZE"));
                }
                buff.append("</td>");
                buff.append("\n\t<td>");
                if ("CRUSER".equals(colName) && !"WCMUSER".equals(tableName.toUpperCase())) {
                    buff.append("<a href='wcmuser.htm'>WCMUSER</a>.USERNAME");
                }
                buff.append("</td>");
                buff.append("</tr>\n");
            }
            columns.close();
            this.write2File(tableName, buff.toString());
            buff.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write2File(String tableName, String string) throws Exception {
        OutputStream ostream = null;
        OutputStreamWriter oswriter = null;
        BufferedWriter writer = null;
        try {
            ostream = new FileService(tableName.toLowerCase() + ".htm").getOutputStream();
            oswriter = new OutputStreamWriter(ostream, "utf-8");
            writer = new BufferedWriter(oswriter);
            String content = this.template.replaceAll("#t", tableName.toUpperCase());
            content = content.replaceAll("<!-- tbody -->", string);
            writer.write(content);
            writer.flush();
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (Exception exception) {}
            }
            if (oswriter != null) {
                try {
                    oswriter.close();
                }
                catch (Exception exception) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String showNull(String string) {
        if (string == null) {
            return "";
        }
        return string.substring(1, string.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws Exception {
        InputStream ins = null;
        InputStreamReader insr = null;
        BufferedReader reader = null;
        try {
            Class<DataDictionary> clazz = DataDictionary.class;
            ins = clazz.getResourceAsStream(FILE_NAME);
            if (ins == null) {
                ins = clazz.getResourceAsStream(FILE_NAME.substring(1));
            }
            insr = new InputStreamReader(ins, "utf-8");
            reader = new BufferedReader(insr);
            StringBuffer buff = new StringBuffer(512);
            String line = reader.readLine();
            while (line != null) {
                buff.append(line).append('\n');
                line = reader.readLine();
            }
            this.template = buff.toString();
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:jtds:sqlserver://" + args[0];
        String user = args[1];
        String passwd = args[2];
        DataDictionary dic = new DataDictionary(url, user, passwd);
        dic.makeDic();
    }
}

