/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.wcmx.media;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.wcmx.media.MediaRemindedAgent;
import com.trs.components.wcm.wcmx.media.MediaRemindedInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;

public class MediaRemindedInfo
extends CMSObj {
    public static final int OBJ_TYPE = 4001;
    public static final String DB_TABLE_NAME = "XWCMMEDIAREMINDEDINFO";
    public static final String DB_ID_NAME = "MEDIAREMINDEDINFOID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 4001;
    }

    public int getUserID() {
        return this.getPropertyAsInt("USERID", 0);
    }

    public boolean setUserID(int _nUserID) throws WCMException {
        return this.setProperty("USERID", _nUserID);
    }

    public int getSourceId() {
        return this.getPropertyAsInt("SOURCEID", 0);
    }

    public boolean setSourceId(int _nSourceId) throws WCMException {
        return this.setProperty("SOURCEID", _nSourceId);
    }

    public int getFreqReminded() {
        return this.getPropertyAsInt("FREQREMINDED", 0);
    }

    public boolean setFreqReminded(int _nFreqReminded) throws WCMException {
        return this.setProperty("FREQREMINDED", _nFreqReminded);
    }

    public int getCurrMediaCount() {
        return this.getPropertyAsInt("CURRMEDIACOUNT", 0);
    }

    public boolean setCurrMediaCount(int _nCurrMediaCount) throws WCMException {
        return this.setProperty("CURRMEDIACOUNT", _nCurrMediaCount);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("USERID") == null) {
                throw new WCMException(1106, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label1", "\u5c5e\u6027UserID\u6ca1\u6709\u8bbe\u7f6e(MediaRemindedInfo.isValid)"));
            }
            if (this.getAllProperty().get("SOURCEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label2", "\u5c5e\u6027SourceId\u6ca1\u6709\u8bbe\u7f6e(MediaRemindedInfo.isValid)"));
            }
            if (this.getAllProperty().get("FREQREMINDED") == null) {
                throw new WCMException(1106, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label3", "\u5c5e\u6027FreqReminded\u6ca1\u6709\u8bbe\u7f6e(MediaRemindedInfo.isValid)"));
            }
            if (this.getAllProperty().get("CURRMEDIACOUNT") == null) {
                this.setCurrMediaCount(0);
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MediaRemindedInfo.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("CRUSER") == null) {
                this.setCrUser(_currUser);
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(_currUser);
            MediaRemindedAgent.getInstance().putMediaRemindedInfoInCache(this);
        }
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        int nUserId = this.getUserID();
        int nSourceId = this.getSourceId();
        int nResult = super.delete(_currUser);
        if (nResult > 0) {
            MediaRemindedAgent.getInstance().removeMediaRemindedInfoFromCache(nUserId, nSourceId);
        }
        return nResult;
    }

    @Override
    public synchronized void update(User _user) throws WCMException {
        super.update(_user);
        MediaRemindedAgent.getInstance().updateMediaRemindedCache(this);
    }

    public static final MediaRemindedInfo findById(User _currUser, int _nId, String _sSelect) throws WCMException {
        if (_nId <= 0) {
            throw new WCMException(10, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label5", "\u6307\u5b9a\u5bf9\u8c61ID(") + _nId + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label6", ")\u65e0\u6548\uff01"));
        }
        BaseObjs aMediaRemindedInfos = null;
        MediaRemindedInfo aMediaRemindedInfo = null;
        try {
            aMediaRemindedInfos = new MediaRemindedInfos(_currUser, 1, 1);
            aMediaRemindedInfos.setMaxSize(1);
            aMediaRemindedInfos.open(new WCMFilter("", "MEDIAREMINDEDINFOID=" + _nId, "", _sSelect));
            if (!aMediaRemindedInfos.isEmpty()) {
                aMediaRemindedInfo = (MediaRemindedInfo)aMediaRemindedInfos.getAt(0);
            }
            MediaRemindedInfo mediaRemindedInfo = aMediaRemindedInfo;
            return mediaRemindedInfo;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label7", "\u63d0\u53d6ID=") + _nId + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label8", "\u7684MediaRemindedInfo\u5bf9\u8c61\u5931\u8d25\uff01"), ex);
        }
        finally {
            if (aMediaRemindedInfos != null) {
                aMediaRemindedInfos.clear();
            }
        }
    }

    public static final MediaRemindedInfo findByUserAndSrc(User _currUser, int _nUserId, int _nSourceId) throws WCMException {
        if (_nUserId <= 0) {
            throw new WCMException(10, "UserID(" + _nUserId + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label6", ")\u65e0\u6548\uff01"));
        }
        if (_nSourceId <= 0) {
            throw new WCMException(10, "SourceId(" + _nSourceId + I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label6", ")\u65e0\u6548\uff01"));
        }
        BaseObjs aMediaRemindedInfos = null;
        MediaRemindedInfo aMediaRemindedInfo = null;
        try {
            aMediaRemindedInfos = new MediaRemindedInfos(_currUser, 1, 1);
            aMediaRemindedInfos.setMaxSize(1);
            aMediaRemindedInfos.open(new WCMFilter("", "SourceId=" + _nSourceId + " and UserId=" + _nUserId, ""));
            if (!aMediaRemindedInfos.isEmpty()) {
                aMediaRemindedInfo = (MediaRemindedInfo)aMediaRemindedInfos.getAt(0);
            }
            MediaRemindedInfo mediaRemindedInfo = aMediaRemindedInfo;
            return mediaRemindedInfo;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label9", "\u63d0\u53d6\u6307\u5b9a\u7684MediaRemindedInfo\u5bf9\u8c61\u5931\u8d25\uff01"), ex);
        }
        finally {
            if (aMediaRemindedInfos != null) {
                aMediaRemindedInfos.clear();
            }
        }
    }

    public static final MediaRemindedInfo findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MediaRemindedInfo)BaseObj.findById(MediaRemindedInfo.class, _nId);
    }

    public static final MediaRemindedInfo createNewInstance() throws WCMException {
        return (MediaRemindedInfo)BaseObj.createNewInstance(MediaRemindedInfo.class);
    }

    public static final MediaRemindedInfo findByKey(Object _oKey) throws WCMException {
        return (MediaRemindedInfo)BaseObj.findByKey(MediaRemindedInfo.class, _oKey);
    }

    public static final MediaRemindedInfo addRemindedSource(User _currUser, int _nUserId, int _nSourceId, int _nRemindedReq) throws Exception {
        boolean bAddNew;
        MediaRemindedInfo newMediaRemindedInfo = MediaRemindedInfo.findByUserAndSrc(_currUser, _nUserId, _nSourceId);
        boolean bl = bAddNew = newMediaRemindedInfo == null;
        if (newMediaRemindedInfo != null && newMediaRemindedInfo.getFreqReminded() == _nRemindedReq) {
            return null;
        }
        try {
            MediaRemindedInfos newMediaRemindedInfos = new MediaRemindedInfos(_currUser);
            if (bAddNew) {
                newMediaRemindedInfo = (MediaRemindedInfo)newMediaRemindedInfos.addNew();
            }
            newMediaRemindedInfo.setUserID(_nUserId);
            newMediaRemindedInfo.setSourceId(_nSourceId);
            newMediaRemindedInfo.setFreqReminded(_nRemindedReq);
            if (bAddNew) {
                newMediaRemindedInfos.update();
            } else {
                newMediaRemindedInfo.update(_currUser);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1105, I18NMessage.get(MediaRemindedInfo.class, "MediaRemindedInfo.label10", "\u6dfb\u52a0\u65b0\u7684\u63d0\u9192\u8bbe\u7f6e\u5931\u8d25\uff01(MediaRemindedInfo.addRemindedSource)"), ex);
        }
        return newMediaRemindedInfo;
    }
}

