/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.template.TempAppendix;
import com.trs.components.wcm.version.IObjSpecialHandler;
import com.trs.components.wcm.version.ObjAndFileVersion;
import com.trs.components.wcm.version.ObjAndFileVersionMgr;
import com.trs.components.wcm.version.ObjAndFileVersions;
import com.trs.components.wcm.version.file.FileVersionMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.io.File;

public class TempAppendixSpecialHandler
implements IObjSpecialHandler {
    private FileVersionMgr m_oFileVersionMgr = (FileVersionMgr)DreamFactory.createObjectById("IFileVersionMgr");
    private ObjAndFileVersionMgr m_objAndFileMgr = (ObjAndFileVersionMgr)DreamFactory.createObjectById("IObjAndFileVersionMgr");

    @Override
    public String getCMSObjType() {
        return TempAppendix.class.getName();
    }

    @Override
    public void parseSpecialField(CMSObj _curObj, CMSObj _mainObj, int _nVersionNum) throws WCMException {
        String sFileName = this.getTemplateFilePath(_curObj);
        int nFileVersionNum = this.m_oFileVersionMgr.buildVersion(sFileName);
        if (nFileVersionNum <= 0) {
            throw new WCMException(I18NMessage.get(ObjAndFileVersionMgr.class, "ObjAndFileVersionMgr.lable2", "\u6587\u4ef6\u8fdb\u884c\u7248\u672c\u7ba1\u7406\u5f02\u5e38"));
        }
        ObjAndFileVersions objAndFileVersions = this.m_objAndFileMgr.findVersionMapping(_mainObj, sFileName, _nVersionNum);
        if (objAndFileVersions.size() == 0) {
            ObjAndFileVersion mapping = new ObjAndFileVersion();
            mapping.setObjId(_mainObj.getId());
            mapping.setObjType(_mainObj.getWCMType());
            mapping.setObjVersion(_nVersionNum);
            mapping.setFileName(sFileName);
            mapping.setFileVersion(nFileVersionNum);
            this.m_objAndFileMgr.addVersionMapping(mapping);
        }
    }

    @Override
    public void deleteSpecialField(CMSObj _curObj, CMSObj _mainObj, int _nVersionNum) throws WCMException {
        ObjAndFileVersions objAndFileVersions = this.m_objAndFileMgr.findVersionMapping(_mainObj, _nVersionNum);
        for (int i = 0; i < objAndFileVersions.size(); ++i) {
            ObjAndFileVersion mapping = (ObjAndFileVersion)objAndFileVersions.getAt(i);
            this.m_oFileVersionMgr.deleteFileVersion(mapping.getFileName(), mapping.getFileVersion());
            mapping.delete(ContextHelper.getLoginUser());
        }
    }

    @Override
    public void recoverSpecialField(CMSObj _curObj, CMSObj _mainObj, int _nVersionNum) throws WCMException {
        String sFileName = this.getTemplateFilePath(_curObj);
        ObjAndFileVersions objAndFileVersions = this.m_objAndFileMgr.findVersionMapping(_mainObj, sFileName, _nVersionNum);
        for (int i = 0; i < objAndFileVersions.size(); ++i) {
            ObjAndFileVersion mapping = (ObjAndFileVersion)objAndFileVersions.getAt(i);
            this.m_oFileVersionMgr.recover(sFileName, mapping.getFileVersion());
        }
    }

    private String getTemplateFilePath(CMSObj _curObj) {
        TempAppendix tempAppendix = (TempAppendix)_curObj;
        String sFileName = "";
        int rootType = tempAppendix.getRootType();
        int rootId = tempAppendix.getRootId();
        sFileName = rootType == 103 ? sFileName + "site" : sFileName + "root" + Integer.toHexString(rootType) + File.separatorChar;
        sFileName = sFileName + rootId + "" + File.separatorChar + tempAppendix.getFile();
        return sFileName;
    }
}

