/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.resource;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.Schedules;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class ResourceMgr {
    private static final int[] RESOURCE_OBJ_TYPE = new int[]{608, 607, 610, 205, 313, 704, 951};

    public CMSObj save(User _currUser, CMSObj _currObj) throws WCMException {
        if (!this.isValidResourceType(_currObj)) {
            throw new WCMException(10, I18NMessage.get(ResourceMgr.class, "ResourceMgr.label1", "\u975e\u914d\u7f6e\u8d44\u6e90\u5bf9\u8c61\uff01"));
        }
        _currObj.save(_currUser);
        return _currObj;
    }

    public boolean delete(User _currUser, CMSObj _currObj) throws WCMException {
        if (!this.isValidResourceType(_currObj)) {
            throw new WCMException(10, I18NMessage.get(ResourceMgr.class, "ResourceMgr.label2", "\u975e\u914d\u7f6e\u8d44\u6e90\u5bf9\u8c61!"));
        }
        return _currObj.delete(_currUser) == 1;
    }

    private boolean isValidResourceType(CMSObj _currObj) throws WCMException {
        if (_currObj == null) {
            throw new WCMException(10, I18NMessage.get(ResourceMgr.class, "ResourceMgr.label3", "\u65e0\u6548\u7684\u5bf9\u8c61\u53c2\u6570!"));
        }
        int nObjType = _currObj.getWCMType();
        int[] nTypes = RESOURCE_OBJ_TYPE;
        for (int i = 0; i < nTypes.length; ++i) {
            if (nObjType != nTypes[i]) continue;
            return true;
        }
        return false;
    }

    public Schedules getTempPathDeleteSchedules(WCMFilter _filter) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SenderType=0", "");
        aFilter.mergeWith(_filter);
        return Schedules.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }
}

