/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TemplateParameter;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateNestMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.tagparser.RollDocumentsChannelsFinder;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTemplateChildIndexAnalyer {
    private static Logger logger = Logger.getLogger(WCMTemplateChildIndexAnalyer.class);
    public static final String INSERT_CHANNEL_CHILDINDEX_QUOTE = "insert into WCMChannelChildIndexQuote (TemplateId, FolderType, FolderId, QuoteChannelId) values(?, ?, ?, ?)";
    public static final String QUERY_CHANNEL_CHILDINDEX_QUOTE = "select 1 from WCMChannelChildIndexQuote where TemplateId=? and FolderType = ? and FolderId=? and QuoteChannelId=?";
    private Template m_oTemplate = null;
    private final int m_nTopTemplateId;
    private TagDocument m_oTagDoc = null;
    private DBManager dbMgr = null;
    private List lEmployers = null;

    public WCMTemplateChildIndexAnalyer(Template _template) {
        this.m_oTemplate = _template;
        this.m_nTopTemplateId = this.m_oTemplate.getId();
        this.dbMgr = DBManager.getDBManager();
    }

    public WCMTemplateChildIndexAnalyer(IPublishFolder _root) {
        this.m_nTopTemplateId = 0;
        this.dbMgr = DBManager.getDBManager();
    }

    public void analyer() throws WCMException {
        this.removeOldAnalyeInfo();
        this.analyer(false);
    }

    private void analyer(boolean recuseCall) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyzing template quote: " + this.m_oTemplate));
        }
        try {
            TemplateParseMgr tpm = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            this.m_oTagDoc = tpm.parse(this.m_oTemplate);
        }
        catch (Throwable ex) {
            throw new WCMException("analyer " + this.m_oTemplate + "\u5931\u8d25\uff01", ex);
        }
        if (this.m_oTagDoc == null) {
            return;
        }
        if (!recuseCall) {
            this.lEmployers = this.makeEmployers();
            HashSet<String> employers = new HashSet<String>();
            for (int i = this.lEmployers.size() - 1; i >= 0; --i) {
                IPublishElement employer = (IPublishElement)this.lEmployers.get(i);
                if (employer == null || employer instanceof IPublishContent) {
                    this.lEmployers.remove(i);
                    continue;
                }
                String sKey = employer.getType() + "." + employer.getId();
                if (employers.contains(sKey)) {
                    this.lEmployers.remove(i);
                    continue;
                }
                employers.add(sKey);
            }
            employers.clear();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Employers of this template: " + this.lEmployers));
            }
        }
        if (this.lEmployers.isEmpty()) {
            return;
        }
        this.analyseTagsContainsChildIndex();
        this.analyseChannelsTags();
        this.anzlyzePageGenTags();
    }

    private void anzlyzePageGenTags() throws WCMException {
        String sTagName = "TRS_PAGEGENERATE";
        Iterator itr = this.m_oTagDoc.findItems(sTagName);
        HashMap<String, Template> templates = new HashMap<String, Template>();
        while (itr.hasNext()) {
            TagItem item = (TagItem)itr.next();
            if (item == null) continue;
            String tempname = item.getAttribute("TEMPNAME");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("tempname: " + tempname));
            }
            if (templates.containsKey(tempname)) continue;
            TemplateCacheMgr templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
            int nSize = this.lEmployers.size();
            for (int i = 0; i < nSize; ++i) {
                IPublishElement employer = (IPublishElement)this.lEmployers.get(i);
                if (employer == null || !employer.isFolder()) continue;
                IPublishFolder folder = (IPublishFolder)employer;
                Template template = templateCacheMgr.lookupByName(folder.getRoot(), tempname);
                if (template != null) {
                    templates.put(tempname, template);
                    continue;
                }
                logger.warn((Object)("Template not found: " + tempname + "@" + folder.getRoot().getInfo()));
            }
        }
        for (Template this.m_oTemplate : templates.values()) {
            this.analyer(true);
        }
        templates.clear();
    }

    private void analyseTagsContainsChildIndex() throws WCMException {
        List lTagItems = this.findTagItemsContainsChildIndex();
        if (lTagItems == null || lTagItems.isEmpty()) {
            return;
        }
        int[] pParameters = new int[4];
        pParameters[0] = this.m_nTopTemplateId;
        int nSize = this.lEmployers.size();
        for (int i = 0; i < nSize; ++i) {
            IPublishElement employer = (IPublishElement)this.lEmployers.get(i);
            if (employer == null || !(employer instanceof IPublishFolder)) continue;
            IPublishFolder folder = (IPublishFolder)employer;
            pParameters[1] = employer.getType();
            pParameters[2] = employer.getId();
            int nTagSize = lTagItems.size();
            for (int nTagItemIndex = 0; nTagItemIndex < nTagSize; ++nTagItemIndex) {
                TagItem tagItem = (TagItem)lTagItems.get(nTagItemIndex);
                if (tagItem == null) continue;
                this.saveQuoteInfo(pParameters, folder, tagItem);
            }
        }
    }

    private List makeEmployers() throws WCMException {
        ArrayList lResult = new ArrayList();
        TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        List lEmployers = employMgr.getEmployers(this.m_oTemplate, null);
        if (lEmployers != null && !lEmployers.isEmpty()) {
            lResult.addAll(lEmployers);
        }
        TemplateNestMgr templateNestMgr = (TemplateNestMgr)DreamFactory.createObjectById("TemplateNestMgr");
        Templates templates = templateNestMgr.getTemplatesNested(this.m_oTemplate);
        int nSize = templates.size();
        for (int i = 0; i < nSize; ++i) {
            List lEmployersTemp;
            Template templateNested = (Template)templates.getAt(i);
            if (templateNested == null || (lEmployersTemp = employMgr.getEmployers(templateNested, null)) == null || lEmployersTemp.isEmpty()) continue;
            lResult.addAll(lEmployersTemp);
        }
        return lResult;
    }

    private void analyseChannelsTags() throws WCMException {
        List lTagItems = this.findChannelsTagItems();
        if (lTagItems == null || lTagItems.isEmpty()) {
            return;
        }
        int[] pParameters = new int[4];
        pParameters[0] = this.m_nTopTemplateId;
        int nSize = this.lEmployers.size();
        for (int i = 0; i < nSize; ++i) {
            IPublishElement employer = (IPublishElement)this.lEmployers.get(i);
            if (employer == null || !(employer instanceof IPublishFolder)) continue;
            pParameters[1] = employer.getType();
            pParameters[2] = employer.getId();
            IPublishFolder oFolder = (IPublishFolder)employer;
            int nTagSize = lTagItems.size();
            for (int nTagItemIndex = 0; nTagItemIndex < nTagSize; ++nTagItemIndex) {
                TagItem tagItem = (TagItem)lTagItems.get(nTagItemIndex);
                if (tagItem == null) continue;
                this.analyseChannelsTag(tagItem, oFolder, pParameters);
            }
        }
    }

    private void analyseChannelsTag(TagItem _currTagItem, IPublishFolder _upperHostFolder, int[] _pParametersOfFolderQuoting) throws WCMException {
        List<Channel> lChildrenOfChannel;
        BaseChannel parentChannel;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Analyzing TRS_CHANNELS quote, params: ");
            int len = _pParametersOfFolderQuoting.length;
            for (int i = 0; i < len; ++i) {
                logger.debug((Object)(i + ":" + _pParametersOfFolderQuoting[i]));
            }
        }
        if ((parentChannel = WCMTemplateChildIndexAnalyer.findFolderHost(_currTagItem, _upperHostFolder)) == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyzing TRS_CHANNELS quote, parent: " + parentChannel));
        }
        if ((lChildrenOfChannel = parentChannel.getChildren(null)) == null || lChildrenOfChannel.isEmpty()) {
            return;
        }
        int nChildrenSize = lChildrenOfChannel.size();
        int nStartPos = WCMTemplateChildIndexAnalyer.getValueOfTag(_upperHostFolder, _currTagItem, "StartPos", 0);
        if (nStartPos < 0) {
            nStartPos = 0;
        }
        int nNum = WCMTemplateChildIndexAnalyer.getValueOfTag(_upperHostFolder, _currTagItem, "NUM", nChildrenSize);
        int nCounter = 0;
        for (int nChannelChildIndex = nStartPos; nChannelChildIndex < nChildrenSize && nCounter < nNum; ++nChannelChildIndex) {
            Channel childChannel = lChildrenOfChannel.get(nChannelChildIndex);
            if (childChannel == null) continue;
            IPublishFolder currFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(childChannel);
            List lChildren = _currTagItem.getChildren();
            int nChildCount = lChildren.size();
            for (int nChildIndex = 0; nChildIndex < nChildCount; ++nChildIndex) {
                Object oChild = lChildren.get(nChildIndex);
                if (!(oChild instanceof TagItem)) continue;
                TagItem oChildTagItem = (TagItem)oChild;
                if (oChildTagItem.getName().equalsIgnoreCase("TRS_CHANNELS")) {
                    this.analyseChannelsTag(oChildTagItem, currFolder, _pParametersOfFolderQuoting);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TRS_CHANNELS: " + currFolder.getInfo()));
                }
                this.saveQuoteInfo(_pParametersOfFolderQuoting, currFolder, (TagItem)oChild);
            }
            ++nCounter;
        }
    }

    private void saveQuoteInfo(int[] _pRelateFolderParameters, IPublishFolder _currFolder, TagItem _currTagItem) throws WCMException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("saveQuoteInfo: " + _currTagItem.getName()));
            logger.debug((Object)("currFolder: " + _currFolder.getInfo()));
        }
        BaseChannel channelOfChildTag = null;
        if (_currTagItem.getName().equalsIgnoreCase("TRS_DOCUMENTS") || _currTagItem.getName().equalsIgnoreCase("TRS_VIEWDATAS") || _currTagItem.getName().equalsIgnoreCase("TRS_OUTLINE")) {
            channelOfChildTag = WCMTemplateChildIndexAnalyer.findFolderHost(_currTagItem, _currFolder);
        } else if (_currTagItem.getName().equalsIgnoreCase("TRS_ROLLDOCUMENTS")) {
            RollDocumentsChannelsFinder finder = new RollDocumentsChannelsFinder(_currFolder);
            String sChannelIds = finder.find(_currTagItem);
            if (CMyString.isEmpty(sChannelIds)) {
                return;
            }
            Channels channels = Channels.findByIds(null, sChannelIds);
            int nSize = channels.size();
            for (int i = 0; i < nSize; ++i) {
                this.saveQuoteInDB(_pRelateFolderParameters, (Channel)channels.getAt(i));
            }
        }
        this.saveQuoteInDB(_pRelateFolderParameters, channelOfChildTag);
    }

    private void saveQuoteInDB(int[] _pRelateFolderParameters, BaseChannel _quoteChannel) throws WCMException {
        if (_quoteChannel == null || _quoteChannel.isSite()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("quote channel: " + _quoteChannel));
        }
        _pRelateFolderParameters[3] = _quoteChannel.getId();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("quote channel: " + _quoteChannel + ", sql:" + QUERY_CHANNEL_CHILDINDEX_QUOTE));
            for (int param : _pRelateFolderParameters) {
                logger.debug((Object)("param: " + param));
            }
        }
        if (this.dbMgr.sqlExecuteIntQuery(QUERY_CHANNEL_CHILDINDEX_QUOTE, _pRelateFolderParameters) > 0) {
            return;
        }
        _pRelateFolderParameters[3] = _quoteChannel.getId();
        this.dbMgr.sqlExecuteUpdate(new String[]{INSERT_CHANNEL_CHILDINDEX_QUOTE}, _pRelateFolderParameters);
    }

    private void removeOldAnalyeInfo() throws WCMException {
        String REMOVEALL_CHANNEL_CHILDINDEX_SQL = "delete from WCMChannelChildIndexQuote where TemplateId=?";
        this.dbMgr.sqlExecuteUpdate(new String[]{"delete from WCMChannelChildIndexQuote where TemplateId=?"}, new int[]{this.m_nTopTemplateId});
        String REMOVEALL_TEMPLATEQUOTE_SQL = "delete from WCMTEMPLATEQUOTE where TemplateId=?";
        this.dbMgr.sqlExecuteUpdate(new String[]{"delete from WCMTEMPLATEQUOTE where TemplateId=?"}, new int[]{this.m_nTopTemplateId});
    }

    private List findTagItemsContainsChildIndex() {
        TagItem tagItem;
        Iterator itr = null;
        ArrayList<TagItem> lTagItems = new ArrayList<TagItem>();
        String[] pTagNames = new String[]{"TRS_OUTLINE", "TRS_DOCUMENTS", "TRS_VIEWDATAS"};
        for (int i = 0; i < pTagNames.length; ++i) {
            TagItem tagItem2;
            String sTagName = pTagNames[i];
            itr = this.m_oTagDoc.findItems(sTagName);
            while (itr.hasNext() && (tagItem2 = (TagItem)itr.next()) != null) {
                HashMap mapAttrs;
                TagItem parent = tagItem2.getParent();
                if (parent != null && parent.getName().equals("TRS_CHANNELS") || (mapAttrs = tagItem2.getAttributes()) == null || !mapAttrs.containsKey("CHILDINDEX")) continue;
                lTagItems.add(tagItem2);
            }
        }
        itr = this.m_oTagDoc.findItems("TRS_ROLLDOCUMENTS");
        while (itr.hasNext() && (tagItem = (TagItem)itr.next()) != null) {
            HashMap mapAttrs;
            TagItem parent = tagItem.getParent();
            if (parent != null && parent.getName().equals("TRS_CHANNELS") || (mapAttrs = tagItem.getAttributes()) == null || !mapAttrs.containsKey("PARENTCHANNELID")) continue;
            lTagItems.add(tagItem);
        }
        return lTagItems;
    }

    private List findChannelsTagItems() {
        ArrayList<TagItem> lTagItems = new ArrayList<TagItem>();
        int nSize = this.m_oTagDoc.getItemCount();
        for (int i = 0; i < nSize; ++i) {
            Iterator itChildren;
            TagItem tagItem;
            Object item = this.m_oTagDoc.getItemAt(i);
            if (item == null || !(item instanceof TagItem) || !(tagItem = (TagItem)item).getName().equalsIgnoreCase("TRS_CHANNELS") || !(itChildren = tagItem.findItems(new String[]{"TRS_ROLLDOCUMENTS", "TRS_OUTLINE", "TRS_DOCUMENTS", "TRS_VIEWDATAS"})).hasNext()) continue;
            lTagItems.add(tagItem);
        }
        return lTagItems;
    }

    private static BaseChannel findFolderHost(TagItem _tagItem, IPublishFolder _folerEmployer) throws WCMException {
        BaseChannel folder;
        String sId;
        BaseChannel channelOrSite;
        int nChildIndex = -1;
        String sValue = WCMTemplateChildIndexAnalyer.getAttribute((IPublishElement)_folerEmployer, null, "CHILDINDEX", _tagItem);
        if (!CMyString.isEmpty(sValue)) {
            nChildIndex = Integer.parseInt(sValue);
        }
        if ((channelOrSite = WCMTemplateChildIndexAnalyer.findIdAppointedFolder(sId = WCMTemplateChildIndexAnalyer.getAttribute((IPublishElement)_folerEmployer, null, "ID", _tagItem), _folerEmployer)) == null) {
            return null;
        }
        int nChannelType = WCMTemplateChildIndexAnalyer.getAttribute((IPublishElement)_folerEmployer, _tagItem, "CHANNELTYPE", 0);
        if (nChannelType == 1 || nChannelType == 2) {
            return WCMTemplateChildIndexAnalyer.findTopNewsOrPicChannel(channelOrSite, nChannelType);
        }
        switch (nChildIndex) {
            case -2: {
                if (channelOrSite.isSite()) {
                    throw new WCMException(235, "Site has no parent!");
                }
                folder = ((Channel)channelOrSite).getParent();
                if (folder != null) break;
                if (((Channel)channelOrSite).getParentId() != 0) {
                    throw new WCMException(235, channelOrSite.getInfo() + "\u7684\u7236\u9891\u9053\u6ca1\u6709\u627e\u5230!");
                }
                folder = channelOrSite.getSite();
                break;
            }
            case -1: {
                folder = channelOrSite;
                break;
            }
            default: {
                folder = channelOrSite.getChildAt(nChildIndex);
                if (folder != null) break;
                logger.error((Object)("Child " + nChildIndex + " of " + channelOrSite.getInfo() + " is not found!"));
            }
        }
        return folder;
    }

    private static BaseChannel findIdAppointedFolder(String _sName, IPublishFolder _employerFolder) throws WCMException {
        BaseChannel channelOrSite;
        int nHashcode;
        IPublishFolder _upperHost = _employerFolder;
        IPublishFolder _root = _employerFolder.getRoot();
        String sName = _sName;
        if (sName == null || (sName = sName.trim()).length() == 0) {
            nHashcode = 75627155;
        } else {
            int nChannelId;
            String sKey = "SITEID:";
            if (sName.toUpperCase().startsWith(sKey)) {
                int nSiteId = Integer.parseInt(sName.substring(sKey.length()));
                if (nSiteId > 0) {
                    return WebSite.findById(nSiteId);
                }
            } else if (sName.toUpperCase().startsWith("CHANNELID:") && (nChannelId = Integer.parseInt(sName.substring("CHANNELID:".length()))) > 0) {
                return Channel.findById(nChannelId);
            }
            nHashcode = sName.toUpperCase().hashCode();
        }
        switch (nHashcode) {
            case 2545479: {
                if (_upperHost == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    channelOrSite = _upperHost instanceof IPublishFolder ? (BaseChannel)_upperHost.getSubstance() : (BaseChannel)_upperHost.getFolder().getSubstance();
                    if (channelOrSite.isSite()) break;
                    channelOrSite = channelOrSite.getSite();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case 75627155: {
                if (_upperHost == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    if (_upperHost instanceof IPublishFolder) {
                        channelOrSite = (BaseChannel)_upperHost.getSubstance();
                        break;
                    }
                    channelOrSite = (BaseChannel)_upperHost.getFolder().getSubstance();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case -1942094678: {
                if (_upperHost == null) {
                    throw new WCMException("Upper Host is Null!");
                }
                try {
                    channelOrSite = _upperHost instanceof IPublishFolder ? (BaseChannel)_upperHost.getSubstance() : (BaseChannel)_upperHost.getFolder().getSubstance();
                    if (channelOrSite.isSite()) break;
                    channelOrSite = channelOrSite.getHost();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            default: {
                channelOrSite = Channel.findByName(_root.getId(), sName);
                if (channelOrSite != null) break;
                String sMsg = "\u6307\u5b9a\u7684\u9891\u9053 [" + sName + "]\u5728" + _root.getInfo() + "\u6ca1\u6709\u627e\u5230!";
                logger.error((Object)sMsg);
                throw new WCMException(233, sMsg);
            }
        }
        return channelOrSite;
    }

    private static BaseChannel findTopNewsOrPicChannel(BaseChannel _parent, int _nChannelType) throws WCMException {
        if (_parent == null) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u7236\u9891\u9053\uff01");
        }
        BaseChannel parent = _parent;
        User system = User.getSystem();
        int nChildrenSize = parent.getChildrenSize(system);
        for (int i = 0; i < nChildrenSize && i < 2; ++i) {
            Channel child = parent.getChildAt(i);
            if (child == null || child.getType() != _nChannelType) continue;
            return child;
        }
        if (parent.isSite()) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7c7b\u578b[" + _nChannelType + "]\u7684\u9891\u9053\uff01");
        }
        return WCMTemplateChildIndexAnalyer.findTopNewsOrPicChannel(parent.getHost(), _nChannelType);
    }

    public static int getAttribute(IPublishElement _element, TagItem _item, String _sName, int _nDefault) throws WCMException {
        String sValue = WCMTemplateChildIndexAnalyer.getAttribute(_element, null, _sName, _item);
        if (sValue == null || sValue.length() == 0) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            throw new WCMException(2, "Value [" + sValue + "] of attribute [" + _sName + "] is not integer!", ex);
        }
    }

    private static int getValueOfTag(IPublishElement _element, TagItem _tagItem, String _sValueName, int _nDefault) {
        int nChildLevel = _nDefault;
        String sValue = WCMTemplateChildIndexAnalyer.getAttribute(_element, null, _sValueName, _tagItem);
        if (!CMyString.isEmpty(sValue)) {
            nChildLevel = Integer.parseInt(sValue);
        }
        return nChildLevel;
    }

    private static String getAttribute(IPublishElement _element, String _sIdentityNameOfNestTemplate, String _sName, TagItem _oCurrTagItem) {
        String sValue = _oCurrTagItem.getAttributeTrim(_sName);
        if (sValue == null) {
            return null;
        }
        if (!TagItem.isVariableParameter(sValue)) {
            return sValue;
        }
        TemplateParameter tp = _oCurrTagItem.getVariableParameter(_sName);
        if (tp == null) {
            return sValue;
        }
        String sVariableName = tp.getParameterName();
        if (sVariableName.charAt(0) == '@') {
            return sValue;
        }
        HashMap mVariableArgument = null;
        try {
            mVariableArgument = _element.getTemplateArguments();
            if (mVariableArgument == null) {
                return tp.getParameterDefaultValue();
            }
        }
        catch (Exception e) {
            return sValue;
        }
        String sVariableKey = TemplateArgument.makeCacheKey(_sIdentityNameOfNestTemplate, sVariableName);
        String sVariableValue = (String)mVariableArgument.get(sVariableKey);
        if (sVariableValue != null) {
            return sVariableValue;
        }
        return tp.getParameterDefaultValue();
    }
}

