/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WCMTagParserXAppendixs
extends BaseTagParser4List {
    protected static TagBeanInfo m_sTagBeanInfo = null;
    private List m_xAppendixs;
    private Document m_oDocument;
    private IPublishContent m_oCurrContent;
    protected int m_nCurrNumber = 1;
    private int m_nCurrPos = 0;
    private PublishTagContext m_nextRecordContext = null;
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Map hmAppendix = new HashMap();

    @Override
    public TagBeanInfo getBeanInfo() {
        if (m_sTagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_XAPPENDIXs");
            tbi.setDesc("TRS_XAPPENDIXs");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"PIC", "FILE", "LINK", "ALL"});
            tbai.setDefaultValue("FILE");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ORDER");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MINWIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MINHEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            m_sTagBeanInfo = tbi;
        }
        return m_sTagBeanInfo;
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public int getRecordSize() {
        return this.m_xAppendixs == null ? 0 : this.m_xAppendixs.size();
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            Appendix oAppendix = (Appendix)this.m_xAppendixs.get(this.m_nCurrPos++);
            IPublishContent publishElement = this.m_oCurrContent;
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(publishElement);
            this.hmAppendix.put("APPENDIX", oAppendix);
            this.m_nextRecordContext.setExtraAttributes(this.hmAppendix);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Appendix element;
        int i;
        if (!_context.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(_context)) {
            return null;
        }
        CMSBaseObjs oDefaultObjects = this.findObjects(_context);
        this.m_xAppendixs = new ArrayList(oDefaultObjects.size());
        int nSize = oDefaultObjects.size();
        for (i = 0; i < nSize; ++i) {
            element = (Appendix)oDefaultObjects.getAt(i);
            if (element == null || element.getFlag() == 20 && !WCMAppendixGenerator.validPic(element, _context)) continue;
            this.m_xAppendixs.add(element);
        }
        int length = this.m_xAppendixs.size();
        for (i = 0; i < length; ++i) {
            element = (Appendix)this.m_xAppendixs.get(i);
            element.setAttribute("_RECORDCOUNT", String.valueOf(length));
        }
        this.m_nextRecordContext = new PublishTagContext(_context, _context.getTagItem(), this);
        String[] results = TagParseHelper.parse4List(_context.getTagItem(), _context, this);
        return results;
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        String sId = _context.getAttribute("ID");
        if (CMyString.isEmpty(sId) || "OWNER".equalsIgnoreCase(sId)) {
            IPublishElement publishElement = _context.getUpperHost();
            if (!(publishElement instanceof PublishContentDocumentImpl)) {
                throw new WCMException(200006, "\u5f53\u524dUpperHost\u4e0d\u662fDocument\uff01");
            }
            this.m_oCurrContent = (IPublishContent)publishElement;
            this.m_oDocument = (Document)this.m_oCurrContent.getSubstance();
        } else {
            this.m_oDocument = Document.findById(Integer.parseInt(sId));
            if (this.m_oDocument == null) {
                throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6240\u5c5e\u7684\u6587\u6863\uff01");
            }
            this.m_oCurrContent = (IPublishContent)PublishElementFactory.makeElementFrom(this.m_oDocument);
        }
        Appendixes oAppendixes = this.getAllAppendixes(this.m_oDocument, _context);
        return oAppendixes;
    }

    private Appendixes getAllAppendixes(Document _oDocument, PublishTagContext _context) throws WCMException {
        String sRelatedColumn = _context.getAttribute("RELATEDCOLUMN");
        boolean bRelated = !CMyString.isEmpty(sRelatedColumn);
        int nAppType = this.getAppendixType(_context);
        Appendixes aApps = this.getAppMgr().getAppendixes(_oDocument, nAppType);
        if (bRelated) {
            for (int n = aApps.size() - 1; n >= 0; --n) {
                Appendix appendix = (Appendix)aApps.getAt(n);
                if (appendix == null || sRelatedColumn.equals(appendix.getRelatedColumn())) continue;
                aApps.remove(appendix, false);
            }
        }
        return aApps;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    private int getAppendixType(PublishTagContext _context) {
        String sMode = CMyString.showNull(_context.getAttribute("MODE"), "FILE").toUpperCase();
        return s_oAppendixTypeRegister.lookup(sMode, 10);
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        String sId = _context.getAttribute("ID");
        return CMyString.isEmpty(sId) || sId.indexOf(",") <= -1;
    }

    static {
        s_oAppendixTypeRegister.register("VIDEO", 50);
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 60);
    }
}

