/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.publish.logo.Logo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.io.File;

public abstract class WCMTagParserLogoBase
extends BaseTagParser {
    public abstract IPublishElement findHost(PublishTagContext var1) throws WCMException;

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sReturnPath;
        IPublishElement host = this.findHost(_context);
        if (host == null) {
            return null;
        }
        int nIndex = _context.getAttribute("INDEX", 1);
        boolean bNameOnly = "TRUE".equalsIgnoreCase(_context.getAttribute("NAMEONLY"));
        boolean bSHOWPIC = "TRUE".equalsIgnoreCase(_context.getAttribute("SHOWPIC"));
        boolean bUrlIsAbs = "TRUE".equalsIgnoreCase(_context.getAttribute("URLISABS"));
        String sShowMode = _context.getAttribute("SHOWMODE");
        Logo logo = Logo.findOf(host.getType(), host.getId(), nIndex - 1);
        if (logo == null) {
            return null;
        }
        this.distributeLogoFile(_context, host, logo);
        if (bNameOnly) {
            return new String[]{logo.getFileName()};
        }
        IPublishFolder fileOwner = null;
        fileOwner = !host.isFolder() ? ((IPublishContent)host).getOriginalHome() : (IPublishFolder)host;
        if (fileOwner == null) {
            return null;
        }
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLogoImagesPath = null;
        sLogoImagesPath = !bPreview ? compass.getAbsoluteHttpPath(fileOwner) + "images/" : compass.getPreviewHttpPath(fileOwner) + "images/";
        String sReltivePath = HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(fileOwner) + "images/", _context.getPageHttpPath()) + logo.getFileName();
        String string = sReturnPath = bUrlIsAbs ? sLogoImagesPath + logo.getFileName() : sReltivePath;
        if (bSHOWPIC) {
            return new String[]{"<img src='" + sReturnPath + "'/>"};
        }
        if (sShowMode != null) {
            if (sShowMode.equalsIgnoreCase("FILENAME")) {
                return new String[]{logo.getFileName()};
            }
            if (sShowMode.equalsIgnoreCase("SHOWPIC")) {
                return new String[]{"<img src='" + sReturnPath + "'/>"};
            }
        }
        return new String[]{sReturnPath};
    }

    private void distributeLogoFile(PublishTagContext _context, IPublishElement host, Logo logo) throws WCMException {
        IPublishFolder fileOwner = null;
        fileOwner = !host.isFolder() ? ((IPublishContent)host).getOriginalHome() : (IPublishFolder)host;
        if (fileOwner == null) {
            return;
        }
        String sFileName = logo.getFileName();
        String sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        if (!CMyFile.fileExists(sSrcFilePathName)) {
            _context.addWarning(host.getInfo() + "-Logo", host.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label1", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230(") + host.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684Logo[") + sFileName + "]");
            return;
        }
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        String sLocalPath = CMyString.setStrEndWith(compass.getLocalPath(fileOwner, bPreview), File.separatorChar) + "images" + File.separatorChar;
        if (!bPreview && !logo.isUpdated() && CMyFile.fileExists(sLocalPath + sFileName)) {
            return;
        }
        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
        try {
            CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
        }
        catch (CMyException e) {
            e.printStackTrace();
            _context.addWarning(host.getInfo() + "-Logo", host.getId(), I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label3", "\u62f7\u8d1d(") + host.getInfo() + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label2", ")\u7684Logo[") + sFileName + I18NMessage.get(WCMTagParserLogoBase.class, "WCMTagParserLogoBase.label4", "]\u53d1\u751f\u5f02\u5e38:") + CMyException.getStackTraceText(e));
        }
        if (!bPreview) {
            _context.getFileDistributeShip().distributeFile(sSrcFilePathName, fileOwner, "images", false);
            if (logo.isUpdated()) {
                logo.setUpdated(false);
                logo.update();
            }
        }
    }
}

