/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.publish.element.PublishFolderChannelImpl;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4FolderHostBase;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.List;

public class WCMTagParserChannels
extends WCMTagParser4FolderHostBase
implements ITagParser4List {
    private List m_channels;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_CHANNELS");
            tbi.setDesc("TRS_CHANNELS");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("SITE");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INCLUDEALL");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHNLIDS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDTYPE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setEnumValue(new String[]{"-1", "0", "1", "2", "11"});
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDINDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("order");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PAGESIZE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CONTAINSMANAGERNODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_channels != null) {
            this.m_channels = null;
            this.m_nCurrPos = 0;
            this.m_nextRecordContext = null;
        }
    }

    @Override
    protected int getQuoteType() {
        return 5;
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public int getRecordSize() {
        return this.m_channels == null ? 0 : this.m_channels.size();
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl folder = new PublishFolderChannelImpl(channel);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(folder);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        List tagChildren = this.m_tagItem.getChildren();
        if (tagChildren == null || tagChildren.isEmpty()) {
            return null;
        }
        BaseChannel parent = this.findHost(_context, false, true);
        if (parent == null) {
            return null;
        }
        int type = _context.getAttribute("CHILDTYPE", -1);
        if (_context.getAttribute("ONLY", false) && !parent.isSite()) {
            this.m_channels = new ArrayList(1);
            this.m_channels.add(parent);
        } else if ("true".equalsIgnoreCase(_context.getAttribute("INCLUDEALL"))) {
            this.m_channels = this.getAllChildren(parent, type);
        } else {
            String sOrder = _context.getAttribute("order");
            sOrder = CMyString.isEmpty(sOrder) ? "CHNLORDER desc" : sOrder;
            String chnlids = _context.getAttribute("CHNLIDS");
            WCMFilter filter = new WCMFilter();
            StringBuffer sbWhere = new StringBuffer(100);
            sbWhere.append("status >= 0");
            if (!CMyString.isEmpty(chnlids)) {
                sbWhere.append(" and CHANNELID IN (");
                sbWhere.append(chnlids);
                sbWhere.append(")");
            } else {
                sbWhere.append(" and parentId=?");
                if (parent.isSite()) {
                    filter.addSearchValues(0);
                    sbWhere.append(" and siteid=?");
                    filter.addSearchValues(parent.getId());
                } else {
                    filter.addSearchValues(parent.getId());
                }
            }
            if (type >= 0) {
                sbWhere.append(" and chnlType=?");
                filter.addSearchValues(type);
            }
            filter.setWhere(sbWhere.toString());
            filter.setOrder(sOrder);
            Channels oChildChannels = Channels.openWCMObjs(ContextHelper.getLoginUser(), filter);
            this.m_channels = new ArrayList(oChildChannels.size());
            int nSize = oChildChannels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel element = (Channel)oChildChannels.getAt(i);
                if (element == null) continue;
                this.m_channels.add(element);
            }
        }
        int iCount = 0;
        int iLimit = _context.getAttribute("NUM", 0);
        if (iLimit <= 0 || iLimit > this.m_channels.size()) {
            iLimit = this.m_channels.size();
        }
        boolean containsmanagernode = _context.getAttribute("CONTAINSMANAGERNODE", true);
        for (int i = this.m_channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)this.m_channels.get(i);
            if (channel == null || !channel.isCanPub()) {
                this.m_channels.remove(i);
                continue;
            }
            if (!containsmanagernode && channel.isOnlyManager()) {
                this.m_channels.remove(i);
                continue;
            }
            ++iCount;
        }
        try {
            this.m_nextRecordContext = new PublishTagContext(_context, this.m_tagItem, this);
            String[] i = TagParseHelper.parse4List(this.m_tagItem, _context, this);
            return i;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to parse the channels list!", ex);
        }
        finally {
            this.clear();
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            Channel channel = (Channel)this.m_channels.get(this.m_nCurrPos++);
            PublishFolderChannelImpl folder = new PublishFolderChannelImpl(channel);
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(folder);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    private List<Channel> getAllChildren(BaseChannel parent, int type) throws WCMException {
        ArrayList<Channel> allChildren = new ArrayList<Channel>();
        List<Channel> children = parent.getChildren(ContextHelper.getLoginUser(), type);
        if (children != null && children.size() > 0) {
            allChildren.addAll(children);
            for (BaseChannel baseChannel : children) {
                List<Channel> subChildren = this.getAllChildren(baseChannel, type);
                if (subChildren == null || subChildren.size() <= 0) continue;
                allChildren.addAll(subChildren);
            }
        }
        return allChildren;
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            TagBeanInfoHelper.checkChannelName(_folder, _tagItem, _sbResult);
        }
    }
}

