/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParser4FolderHostBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;

public abstract class WCMTagParser4ObjsInChannelBase
extends WCMTagParser4FolderHostBase
implements ITagParser4List {
    protected boolean m_bForceSetCurrFolderOfContent = true;
    private static final int ATTR_NUM_DEFAULTVALUE = 500;
    protected IPublishFolder m_oCurrFolder;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static int m_nDefaultMaxNum = 0;

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oCurrFolder != null) {
            this.m_oCurrFolder = null;
        }
        if (this.m_contents != null) {
            this.m_contents.clear();
            this.m_nCurrPos = 0;
            this.m_nextRecordContext = null;
        }
    }

    @Override
    protected int getQuoteType() {
        return 1;
    }

    @Override
    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int size = this.m_contents.size();
            while (content == null && this.m_nCurrPos < size) {
                content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            }
            if (content == null) {
                return null;
            }
            if (this.m_bForceSetCurrFolderOfContent || content.getFolder() == null) {
                content.setFolder(this.m_oCurrFolder);
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(content);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            content.setFolder(this.m_oCurrFolder);
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(content);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    private void findFolder(PublishTagContext _context) throws WCMException {
        if (this.m_oCurrFolder != null) {
            return;
        }
        Channel channel = (Channel)this.findHost(_context, true);
        if (channel == null) {
            return;
        }
        this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        _context.setUpperFolder(this.m_oCurrFolder);
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishFolder oldUpperFolder = _context.getUpperFolder();
        try {
            String sAutoMore;
            if (!this.m_tagItem.hasChildren()) {
                String[] stringArray = null;
                return stringArray;
            }
            this.findFolder(_context);
            WCMFilter filter = this.getContentsFilter(_context);
            this.m_contents = _context.isPreview() ? this.getAllContentsInCurrentFolder(_context, filter) : this.getPublishedContentsInCurrentFolder(_context, filter);
            this.m_nextRecordContext = new PublishTagContext(_context, this.m_tagItem, this);
            String[] results = TagParseHelper.parse4List(this.m_tagItem, _context, this);
            if (results != null && results.length == 1 && _context.getAttribute("AUTOMORE", false) && this.m_contents != null && this.m_contents.size() >= _context.getAttribute("NUM", 0) && (sAutoMore = this.parseAutoMore(this.m_oCurrFolder, _context)) != null) {
                results[0] = results[0] + sAutoMore;
            }
            String[] stringArray = results;
            return stringArray;
        }
        catch (Exception ex) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append(I18NMessage.get(WCMTagParser4ObjsInChannelBase.class, "WCMTagParser4ObjsInChannelBase.label1", "\u89e3\u6790 "));
            sb.append(this.m_oCurrFolder == null ? "m_currFolder == null" : this.m_oCurrFolder.getInfo());
            sb.append(I18NMessage.get(WCMTagParser4ObjsInChannelBase.class, "WCMTagParser4ObjsInChannelBase.label2", " \u7684\u6587\u6863\u5217\u8868\u5931\u8d25!\u7f6e\u6807\u5185\u5bb9: \n"));
            sb.append(this.m_tagItem.toString());
            throw new WCMException(234, sb.toString(), ex);
        }
        finally {
            try {
                _context.setUpperFolder(oldUpperFolder);
            }
            catch (Exception exception) {}
            this.clear();
        }
    }

    protected abstract IPublishElements getPublishedContentsInCurrentFolder(PublishTagContext var1, WCMFilter var2) throws WCMException;

    protected abstract IPublishElements getAllContentsInCurrentFolder(PublishTagContext var1, WCMFilter var2) throws WCMException;

    private WCMFilter getContentsFilter(PublishTagContext _tagContext) throws WCMException {
        String sOrder;
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = _tagContext.getAttribute("WHERE");
        if (!CMyString.isEmpty(sWhere)) {
            filter.setWhere(sWhere);
        }
        if (!CMyString.isEmpty(sOrder = _tagContext.getAttribute("ORDER"))) {
            filter.setOrder(sOrder);
        }
        String sSelectFields = this.getSelectFields(_tagContext);
        String sSelect = _tagContext.getAttribute("SELECT");
        if (sSelectFields.length() > 0 && !CMyString.isEmpty(sSelect)) {
            sSelectFields = sSelectFields + "," + sSelect;
        }
        filter.setSelect(sSelectFields);
        int nStartPos = _tagContext.getAttribute("STARTPOS", 0);
        if (nStartPos < 0) {
            nStartPos = 0;
        }
        int nDefaultMaxNum = WCMTagParser4ObjsInChannelBase.getDefaultMaxNum();
        int nMaxNum = _tagContext.getAttribute("NUM", 500);
        if (nMaxNum <= 0) {
            nMaxNum = 500;
        } else if (nMaxNum > nDefaultMaxNum) {
            nMaxNum = nDefaultMaxNum;
        }
        filter.setMaxRowNumber(nMaxNum + nStartPos);
        return filter;
    }

    private static int getDefaultMaxNum() {
        if (m_nDefaultMaxNum == 0) {
            int nDefaultMaxNum = 0;
            try {
                nDefaultMaxNum = PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum();
                if (nDefaultMaxNum <= 0) {
                    nDefaultMaxNum = 1000;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_nDefaultMaxNum = nDefaultMaxNum;
        }
        return m_nDefaultMaxNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseAutoMore(IPublishFolder _currFolder, PublishTagContext _context) throws Exception {
        String sBegin = _context.getAttribute("BEGINMORE");
        String sEnd = _context.getAttribute("ENDMORE");
        String sText = _context.getAttribute("MORETEXT");
        String sTarget = _context.getAttribute("MORETARGET");
        String sExtra = _context.getAttribute("MOREEXTRA");
        if (sText == null || (sText = sText.trim()).length() == 0) {
            sText = I18NMessage.get(WCMTagParser4ObjsInChannelBase.class, "WCMTagParser4ObjsInChannelBase.label3", "\u66f4\u591a\u5185\u5bb9...");
        }
        if (sTarget == null || (sTarget = sTarget.trim()).length() == 0) {
            sTarget = "_blank";
        }
        StringBuffer buff = new StringBuffer();
        try {
            String sUrl = _context.getPathCompass().getAbsoluteHttpPath(_currFolder);
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
            if (sBegin != null && sBegin.length() > 0) {
                buff.append(sBegin);
            }
            buff.append("<A href=\"").append(sUrl);
            buff.append("\" target=\"").append(sTarget).append("\" ");
            if (sExtra != null) {
                buff.append(sExtra);
            }
            buff.append('>').append(sText).append("</A>");
            if (sEnd != null && sEnd.length() > 0) {
                buff.append(sEnd);
            }
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    protected IPublishFolder getCurrFolder(PublishTagContext _tagContext) throws WCMException {
        if (this.m_oCurrFolder == null) {
            this.findFolder(_tagContext);
        }
        return this.m_oCurrFolder;
    }

    protected String getSelectFields(PublishTagContext _tagContext) {
        return "";
    }
}

