/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import com.trs.wcm.photo.ImageLibHelper;
import com.trs.wcm.publish.ImgFileParserHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.log4j.Logger;

public class WCMAppendixGenerator {
    private static Logger m_oLogger = Logger.getLogger(WCMAppendixGenerator.class);
    public static final int RETURN_NONE = 0;
    public static final int RETURN_NAME = 1;
    public static final int RETURN_HTML = 2;

    private WCMAppendixGenerator() {
    }

    public static String generateAppendixes(Document _doc, int _nApdType, PublishTagContext _context, int _nReturnMode) throws WCMException {
        BaseObjs appendixes = null;
        Appendix appendix = null;
        PublishContentDocumentImpl apdOwner = null;
        int nTotal = 0;
        String sResult = null;
        try {
            String sRelatedColumn;
            AppendixMgr mgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            WCMFilter filter = null;
            String sWhere = _context.getAttribute("Where");
            StringBuffer buff = new StringBuffer(128);
            if (!CMyString.isEmpty(sWhere)) {
                buff.append(sWhere);
            }
            if (!CMyString.isEmpty(sRelatedColumn = _context.getAttribute("RELATEDCOLUMN"))) {
                if (buff.length() > 0) {
                    buff.append(" and ");
                }
                buff.append(" RELATEDCOLUMN=?");
            }
            if (buff.length() > 0) {
                filter = new WCMFilter("", buff.toString(), "");
                if (!CMyString.isEmpty(sRelatedColumn)) {
                    filter.addSearchValues(sRelatedColumn);
                }
                buff.setLength(0);
            }
            appendixes = mgr.getAppendixes(_doc, _nApdType, filter);
            String sSeperator = _context.getAttribute("SEPERATOR");
            if (sSeperator == null) {
                String sField = _context.getAttribute("FIELD");
                sSeperator = sField != null && (sField = sField.trim()).length() > 0 ? "\n" : "<BR/>";
            }
            if (appendixes != null && !appendixes.isEmpty()) {
                int nStartPos = _context.getAttribute("STARTPOS", 0);
                if (nStartPos <= 0) {
                    nStartPos = 1;
                }
                for (int index = nStartPos - 1; index < appendixes.size(); ++index) {
                    appendix = (Appendix)appendixes.getAt(index);
                    if (appendix == null) continue;
                    if (apdOwner == null) {
                        apdOwner = new PublishContentDocumentImpl(_doc);
                        IPublishFolder home = _context.getUpperFolder();
                        if (home == null) {
                            throw new WCMException(1100, "The channel where the document [" + _doc.getId() + "] lies not found!");
                        }
                        apdOwner.setFolder(home);
                    }
                    if (appendix.getFlag() == 20 && !WCMAppendixGenerator.validPic(appendix, _context)) continue;
                    sResult = sResult != null ? sResult + sSeperator : "";
                    sResult = sResult + WCMAppendixGenerator.generateAppendix(appendix, apdOwner, _context, _nReturnMode);
                    ++nTotal;
                }
            }
            String string = sResult;
            return string;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to generate document appendixes!", ex);
        }
        finally {
            if (appendixes != null) {
                appendixes.clear();
            }
        }
    }

    public static boolean validPic(Appendix _appendix, PublishTagContext _context) throws WCMException {
        String sFileName = _appendix.getFile();
        FilesMan filesMan = FilesMan.getFilesMan();
        String sAbsoluteFilePath = filesMan.mapFilePath(sFileName, 0) + sFileName;
        String sMinLimit = ConfigServer.getServer().getSysConfigValue("DOCPICAPPENDIX_VALID_MIN_LIMIT", "0,0");
        int[] nMinLimit = CMyString.splitToInt(sMinLimit, ",");
        int minWidth = _context.getAttribute("MinWidth", nMinLimit[0]);
        int minHeight = _context.getAttribute("MinHeight", nMinLimit[1]);
        return FileHelper.validImageFile(sAbsoluteFilePath, minWidth, minHeight);
    }

    public static String generateAppendix(Appendix _appendix, IPublishContent _apdOwner, PublishTagContext _context, int _nReturnMode) throws WCMException {
        String sResult;
        if (_appendix == null || _apdOwner == null || _context == null) {
            throw new WCMException(10, "Invalid parameters!");
        }
        String sField = _context.getAttribute("FIELD");
        if (CMyString.isEmpty(sField)) {
            return WCMAppendixGenerator.distributeFile(_appendix, _apdOwner, _context, _nReturnMode);
        }
        if (_context.getAttribute("UPLOAD", false)) {
            WCMAppendixGenerator.distributeFile(_appendix, _apdOwner, _context, 0);
        }
        if (sField.equalsIgnoreCase("_RECURL")) {
            String sFile = _appendix.getFile();
            if (_appendix.getFlag() == 40) {
                return sFile;
            }
            if (_appendix.getFlag() == 20 && sFile.indexOf(47) >= 0) {
                FilesMan filesMan = FilesMan.getFilesMan();
                if (sFile.startsWith(filesMan.getPathConfigValue("W0", 1))) {
                    sFile = CMyFile.extractFileName(sFile, "/");
                } else {
                    return sFile;
                }
            }
            if (ConfigServer.getServer().getSysConfigValue("Image_Convert_Quality", "false").trim().equalsIgnoreCase("true")) {
                sFile = ImgFileParserHelper.makeFileNameAndConvert(sFile, _context);
            } else {
                int nWidth = _context.getAttribute("Width", 0);
                sFile = FileHelper.makeNewZoomInFileName(sFile, nWidth);
            }
            return WCMAppendixGenerator.makeAppendixURL(_context, _apdOwner, sFile);
        }
        if (sField.equalsIgnoreCase("ReturnImageWidth") || sField.equalsIgnoreCase("ReturnImageHeight") || sField.equalsIgnoreCase("ReturnImageDimensions")) {
            FilesMan filesMan;
            String sFile = _appendix.getFile();
            if (_appendix.getFlag() == 20 && sFile.indexOf(47) >= 0 && sFile.startsWith((filesMan = FilesMan.getFilesMan()).getPathConfigValue("W0", 1))) {
                sFile = CMyFile.extractFileName(sFile, "/");
            }
            String sAbsoluteFieldName = "";
            if (ConfigServer.getServer().getSysConfigValue("Image_Convert_Quality", "false").trim().equalsIgnoreCase("true")) {
                sAbsoluteFieldName = ImgFileParserHelper.makeAbsoluteFilePathAndConvert(sFile, _context);
            } else {
                int nWidth = _context.getAttribute("Width", 0);
                sAbsoluteFieldName = FileHelper.makeAbsoluteFilePathOfImage(sFile, nWidth);
            }
            if (sField.equalsIgnoreCase("ReturnImageWidth")) {
                return String.valueOf(FileHelper.getImageDimensions(sAbsoluteFieldName)[0]);
            }
            if (sField.equalsIgnoreCase("ReturnImageHeight")) {
                return String.valueOf(FileHelper.getImageDimensions(sAbsoluteFieldName)[1]);
            }
            if (sField.equalsIgnoreCase("ReturnImageDimensions")) {
                String sPattern = _context.getAttribute("ImageDimensionsPattern");
                sPattern = CMyString.showEmpty(sPattern, "width='{width}' height='{height}'");
                int[] dimensions = FileHelper.getImageDimensions(sAbsoluteFieldName);
                String sResult2 = sPattern.replaceAll("(?is)\\{width\\}", String.valueOf(dimensions[0]));
                sResult2 = sResult2.replaceAll("(?is)\\{height\\}", String.valueOf(dimensions[1]));
                return sResult2;
            }
        }
        if (sField.startsWith("#")) {
            String sKey = sField.trim().substring(1);
            String sValue = _appendix.getAttributeValue(sKey);
            String sResult3 = "";
            if (sValue == null) {
                return "";
            }
            try {
                sResult3 = URLDecoder.decode(sValue, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WCMException("\u8be5\u5b57\u7b26\u4e32\u65e0\u6cd5\u88ab\u7f16\u7801", e);
            }
            return sResult3;
        }
        if (sField.equalsIgnoreCase("attribute")) {
            sResult = _appendix.getPropertyAsString(sField);
            if (sResult == null) {
                return "";
            }
            try {
                sResult = URLDecoder.decode(sResult, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WCMException("\u8be5\u5b57\u7b26\u4e32\u65e0\u6cd5\u88ab\u7f16\u7801", e);
            }
            return sResult;
        }
        sResult = _appendix.getPropertyAsString(sField);
        if (sResult == null) {
            sResult = "";
        }
        sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
        if (_nReturnMode == 2) {
            sResult = CMyString.showNull(_context.getAttribute("BEGINHTML")) + sResult;
            sResult = sResult + CMyString.showNull(_context.getAttribute("ENDHTML"));
        }
        return sResult;
    }

    private static final String distributeFile(Appendix _appendix, IPublishContent _apdOwner, PublishTagContext _context, int _nReturnMode) throws WCMException {
        try {
            String sLinkOrFile;
            PublishPathCompass compass = _context.getPathCompass();
            boolean bPreview = _context.isPreview();
            String sFileName = sLinkOrFile = _appendix.getFile();
            int nFlag = _appendix.getFlag();
            if (nFlag != 40) {
                String sSrcFilePathName = null;
                int nQuoteType = ImageLibHelper.getTypeQuotedImageLib(_appendix);
                switch (nQuoteType) {
                    case 0: {
                        sFileName = CMyFile.extractFileName(sFileName);
                        if (ConfigServer.getServer().getSysConfigValue("Image_Convert_Quality", "false").trim().equalsIgnoreCase("true")) {
                            sSrcFilePathName = ImgFileParserHelper.makeAbsoluteFilePathAndConvert(sFileName, _context);
                        } else {
                            int nWidth = _context.getAttribute("Width", 0);
                            sSrcFilePathName = FileHelper.makeAbsoluteFilePathOfImage(sFileName, nWidth);
                        }
                        sFileName = CMyFile.extractFileName(sSrcFilePathName);
                        break;
                    }
                    case 1: {
                        sFileName = CMyFile.extractFileName(sFileName);
                        sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                if (sSrcFilePathName != null) {
                    if (!CMyFile.fileExists(sSrcFilePathName)) {
                        _context.addWarning(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label1", "\u6587\u6863\u9644\u4ef6"), _appendix.getId(), I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label2", "\u5728\u78c1\u76d8\u4e0a\u6ca1\u6709\u627e\u5230\u6587\u6863(") + _apdOwner.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label3", ")\u7684\u9644\u4ef6[") + sFileName + "]");
                    } else {
                        String sLocalPath = compass.getLocalPath(_apdOwner, bPreview);
                        PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
                        boolean bNeedDistribute = true;
                        FileService oTargetFile = new FileService(sLocalPath + sFileName);
                        if (!oTargetFile.exists()) {
                            try {
                                CMyFile.copyFile(sSrcFilePathName, sLocalPath + sFileName);
                            }
                            catch (CMyException myEx) {
                                if (new FileService(sSrcFilePathName).exists() && oTargetFile.exists()) {
                                    m_oLogger.debug((Object)I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label4", "\u5ffd\u7565\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\u4e14\u76ee\u6807\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u6b64\u65f6\u4e0d\u518d\u590d\u5236."));
                                }
                                throw myEx;
                            }
                        } else {
                            bNeedDistribute = false;
                            m_oLogger.debug((Object)I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label5", "\u6e90\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u6b64\u65f6\u4e0d\u518d\u590d\u5236."));
                        }
                        if (!bPreview && bNeedDistribute) {
                            IPublishFolder folder = _apdOwner.getFolder();
                            if (folder == null) {
                                folder = _apdOwner.getOriginalHome();
                                _apdOwner.setFolder(folder);
                            }
                            _context.getFileDistributeShip().distributeFile(sSrcFilePathName, _apdOwner, null, true);
                        }
                    }
                }
            }
            switch (_nReturnMode) {
                case 1: {
                    return sFileName;
                }
                case 2: {
                    if (nFlag != 40 && sFileName.indexOf(47) < 0) {
                        sFileName = WCMAppendixGenerator.makeAppendixURL(_context, _apdOwner, sFileName);
                    }
                    String sResult = null;
                    String sExtra = _context.getAttribute("EXTRA");
                    if (nFlag == 20 || nFlag == 30) {
                        String sDesc;
                        sResult = HtmlUtil.renderImage(sFileName, _appendix.getAlt(), sExtra, _context.getAttribute("WIDTH"), _context.getAttribute("HEIGHT"));
                        if (_context.getAttribute("MEMO", false) && (sDesc = _appendix.getDesc()) != null && sDesc.length() > 0) {
                            sResult = sResult + CMyString.showNull(_context.getAttribute("BEGINMEMO")) + sDesc + CMyString.showNull(_context.getAttribute("ENDMEMO"));
                        }
                        if (_context.getAttribute("AUTOLINK", false)) {
                            sResult = WCMAppendixGenerator.addAutoLink(sResult, _context);
                        }
                    } else {
                        String sDescription = _appendix.getDesc();
                        if (sDescription == null || sDescription.length() == 0) {
                            sDescription = sLinkOrFile;
                        }
                        sResult = _context.getAttribute("AUTOLINK", true) ? HtmlUtil.renderLink(sFileName, _context.getAttribute("TARGET"), _appendix.getAlt(), sExtra, sDescription) : sDescription;
                    }
                    return CMyString.showNull(_context.getAttribute("BEGINHTML")) + sResult + CMyString.showNull(_context.getAttribute("ENDHTML"));
                }
            }
            return null;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label6", "\u751f\u6210\u6587\u6863[") + _apdOwner.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label7", "]\u9644\u4ef6\u6216\u5916\u90e8\u6587\u4ef6\u5931\u8d25"), ex);
        }
    }

    public static String makeAppendixURL(PublishTagContext _context, IPublishContent _apdOwner, String _sFileName) throws WCMException {
        PublishPathCompass compass = _context.getPathCompass();
        boolean bImageURLFilterByConfig = false;
        int nWebSiteid = _context.getRoot().getId();
        m_oLogger.debug((Object)"get into the IMAGE_INDEPENT_URL_DISABLE_BY_SITEIDS");
        String imageUrlFilterBySiteIds = ConfigServer.getServer().getSysConfigValue("IMAGE_INDEPENT_URL_DISABLE_BY_SITEIDS", "");
        if (("," + imageUrlFilterBySiteIds + ",").indexOf("," + String.valueOf(nWebSiteid) + ",") >= 0) {
            bImageURLFilterByConfig = true;
        }
        boolean bStartImagesSite = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("START_IMAGE_SITE", "false"));
        String sAppendixHttpPath = compass.getAbsoluteHttpPath(_apdOwner);
        if (bStartImagesSite && !_context.isPreview() && !bImageURLFilterByConfig) {
            sAppendixHttpPath = PublishPathCompass.calFullDataPath(_apdOwner, false);
            return WCMAppendixGenerator.convertURL2ImageURL(sAppendixHttpPath, _context) + _sFileName;
        }
        boolean bUrlIsAbs = _context.getAttribute("UrlIsAbs", false);
        if (bUrlIsAbs) {
            if (_context.isPreview()) {
                sAppendixHttpPath = compass.getPreviewHttpPath(_apdOwner);
            }
            return sAppendixHttpPath + _sFileName;
        }
        return HtmlUtil.calRelativePath(sAppendixHttpPath, _context.getPageHttpPath()) + _sFileName;
    }

    protected static String addAutoLink(String _sValue, PublishTagContext _context) throws WCMException {
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = "";
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        String sUrl = WCMAppendixGenerator.getAutoLinkUrl(_context);
        if (!_context.getUpperHost().isLink()) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        return HtmlUtil.renderLink(sUrl, sTarget, sAltText, sExtra, _sValue, sLinkText);
    }

    protected static String getAutoLinkUrl(PublishTagContext _context) throws WCMException {
        IPublishElement element = _context.getUpperHost();
        if (element == null) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label8", "\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!"));
        }
        if (!(element instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label9", "\u5f53\u524dUpperHost[") + element.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label10", "]\u4e0d\u662fIPublishContent\u5bf9\u8c61"));
        }
        IPublishContent content = (IPublishContent)element;
        PublishPathCompass compass = _context.getPathCompass();
        switch (content.getBodyType()) {
            case 40: {
                String sFileName = content.getFileName();
                return compass.getAbsoluteHttpPath(_context.getUpperHost()) + sFileName;
            }
            case 30: {
                return content.getLinkUrl();
            }
        }
        return compass.getHttpUrl((IPublishContent)_context.getUpperHost(), 0);
    }

    protected static String getApdHttpPath(IPublishContent _apdOwner, PublishTagContext _context) throws WCMException {
        String sURL = "";
        IPublishElement apdOwner = _context.getUpperHost();
        if (apdOwner == null) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label8", "\u6ca1\u6709\u627e\u5230UpperHost\u5bf9\u8c61!"));
        }
        if (!(apdOwner instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label9", "\u5f53\u524dUpperHost[") + apdOwner.getInfo() + I18NMessage.get(WCMAppendixGenerator.class, "WCMAppendixGenerator.label10", "]\u4e0d\u662fIPublishContent\u5bf9\u8c61"));
        }
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        sURL = bPreview ? compass.getPreviewHttpPath(_apdOwner) : compass.getAbsoluteHttpPath(apdOwner);
        return sURL;
    }

    private static String convertURL2ImageURL(String _sOwnerFullDataPath, PublishTagContext _tagContext) throws WCMException {
        String sImgSitePre = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_PRE", "images");
        String sImgMainDomain = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_MAIN_DOMAIN", "trs.com.cn");
        String sImageSiteCount = ConfigServer.getServer().getSysConfigValue("IMAGE_SITE_COUNT", "1");
        int nImageSiteCount = Integer.parseInt(sImageSiteCount);
        PublishPageContext pageContext = _tagContext.getPageContext();
        String sTemp = pageContext.getExtraAttribute("CurrImageSiteIndex");
        int nCurrImageSiteIndex = Integer.parseInt(sTemp = CMyString.showNull(sTemp, "1"));
        if (nCurrImageSiteIndex >= nImageSiteCount) {
            pageContext.setExtraAttribute("CurrImageSiteIndex", "1");
        } else {
            pageContext.setExtraAttribute("CurrImageSiteIndex", String.valueOf(nCurrImageSiteIndex + 1));
        }
        if ("TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("IMAGE_PUBLISH_IN52", "FALSE"))) {
            return "http://" + sImgSitePre + nCurrImageSiteIndex + "." + sImgMainDomain + "/" + _sOwnerFullDataPath;
        }
        if (nCurrImageSiteIndex == 1) {
            return "http://" + sImgSitePre + "." + sImgMainDomain + "/" + _sOwnerFullDataPath;
        }
        return "http://" + sImgSitePre + (nCurrImageSiteIndex - 1) + "." + sImgMainDomain + "/" + _sOwnerFullDataPath;
    }
}

