/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.RelNewsHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;

public class TagRelNewsParser
implements ITagParser,
ITagParser4List {
    private static ArrayList DEFAULT_FIELDS = new ArrayList(16);
    private static HashMap FIELDS_MAP;
    private TagItem m_tagItem = null;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static TagBeanInfo s_TagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_RELNEWS");
            tbi.setDesc("TRS_RELNEWS");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"USERDEF", "KEYWORDS", "ALL"});
            tbai.setDefaultValue("USERDEF");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MULTISITE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHNLID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SORTBYRELTIME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_contents != null) {
            this.m_contents.clear();
        }
        if (this.m_nextRecordContext != null) {
            this.m_nextRecordContext = null;
        }
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Documents reldocs = RelNewsHelper.getDocuments(_context, this.getSelectFields(_context));
        if (reldocs == null || reldocs.isEmpty()) {
            return null;
        }
        this.m_contents = new PublishElementsCMSObjsImpl(reldocs);
        this.m_nextRecordContext = new PublishTagContext(_context, this.m_tagItem, this);
        String[] results = TagParseHelper.parse4List(this.m_tagItem, _context, this);
        return results;
    }

    @Override
    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int nFolderId = content.getSubstance().getPropertyAsInt("FOLDERID", 0);
            if (nFolderId > 0) {
                Channel channel = Channel.findById(nFolderId);
                content.setFolder((IPublishFolder)PublishElementFactory.makeElementFrom(channel));
            } else {
                content.setFolder(content.getOriginalHome());
            }
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(content);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            int nFolderId = content.getSubstance().getPropertyAsInt("FOLDERID", 0);
            if (nFolderId > 0) {
                Channel channel = Channel.findById(nFolderId);
                content.setFolder((IPublishFolder)PublishElementFactory.makeElementFrom(channel));
            } else {
                content.setFolder(content.getOriginalHome());
            }
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(content);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (sSelectFields == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_tagContext);
                    this.m_tagItem.setExtraAttribute("SELECT", sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(PublishTagContext _tagContext) {
        StringBuffer buff = new StringBuffer(256);
        ArrayList defauts = DEFAULT_FIELDS;
        buff.append(defauts.get(0));
        int nSize = defauts.size();
        for (int i = 1; i < nSize; ++i) {
            buff.append(',').append(defauts.get(i));
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (CMyString.isEmpty(sFieldName) || defauts.contains(sFieldName = sFieldName.toUpperCase())) continue;
            String sMapField = (String)FIELDS_MAP.get(sFieldName);
            boolean zValid = true;
            if (sMapField != null) {
                sFieldName = sMapField;
            } else {
                try {
                    zValid = dbMgr.getFieldInfo("WCMDOCUMENT", sFieldName) != null;
                }
                catch (Exception ex) {
                    zValid = false;
                }
            }
            if (!zValid) continue;
            buff.append(',').append(sFieldName);
        }
        return buff.toString();
    }

    static {
        DEFAULT_FIELDS.add("DOCID");
        DEFAULT_FIELDS.add("DOCCHANNEL");
        DEFAULT_FIELDS.add("DOCSTATUS");
        DEFAULT_FIELDS.add("DOCTYPE");
        DEFAULT_FIELDS.add("DOCTITLE");
        DEFAULT_FIELDS.add("CRUSER");
        DEFAULT_FIELDS.add("CRTIME");
        DEFAULT_FIELDS.add("DOCFLAG");
        DEFAULT_FIELDS.add("TITLECOLOR");
        DEFAULT_FIELDS.add("DOCLINK");
        DEFAULT_FIELDS.add("DOCFILENAME");
        DEFAULT_FIELDS.add("DOCVERSION");
        DEFAULT_FIELDS.add("DOCRELTIME");
        DEFAULT_FIELDS.add("DOCPUBTIME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_TagBeanInfo = null;
    }
}

