/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.util.List;

public class TagChannelHierarchy
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;
    protected TagItem m_oTagItem = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_CHANNELHIERARCHY");
            tbi.setDesc("\u680f\u76ee\u5c42\u6b21");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("SITE");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDTYPE");
            tbai.setDesc("\u7c7b\u578b");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setEnumValue(new String[]{"-1", "0", "1", "2", "11"});
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDINDEX");
            tbai.setDesc("\u8d77\u59cb\u4f4d\u7f6e");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setDesc("\u8d77\u59cb\u4f4d\u7f6e");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LEVEL");
            tbai.setDesc("\u83b7\u53d6\u7684\u5c42\u6b21\u6df1\u5ea6,\u82e5\u6307\u5b9a\u4e3a[-1]\u5219\u83b7\u53d6\u5168\u90e8");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setDesc("\u662f\u5426\u751f\u6210\u8fde\u63a5");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATATYPE");
            tbai.setDesc("\u6570\u636e\u683c\u5f0f");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"XML", "JS", "HTML"});
            tbai.setDefaultValue("XML");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PAGESIZE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_oTagItem = _item;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        BaseChannel parent = WCMTagParserHelper.findFolderHost(this.m_oTagItem, _context, false, true);
        if (parent == null) {
            return null;
        }
        int nLevel = _context.getAttribute("LEVEL", -1);
        int nChnlType = _context.getAttribute("CHILDTYPE", 0);
        boolean zAutoLink = _context.getAttribute("AUTOLINK", true);
        String sDataType = _context.getAttribute("DATATYPE");
        if (CMyString.isEmpty(sDataType)) {
            sDataType = "XML";
        }
        if ("XML".equals(sDataType = sDataType.toUpperCase())) {
            return this.generateXml(_context, parent, nLevel, nChnlType, zAutoLink);
        }
        if ("JS".equals(sDataType)) {
            return this.generateJs(_context, parent, nLevel, nChnlType, zAutoLink);
        }
        return this.generateHtml(_context, parent, nLevel, nChnlType, zAutoLink);
    }

    private String[] generateXml(PublishTagContext _context, BaseChannel parent, int level, int chnlType, boolean autoLink) throws WCMException {
        return new String[]{this.generateXml0(_context, parent, level, chnlType, autoLink)};
    }

    private String generateXml0(PublishTagContext _context, BaseChannel parent, int level, int chnlType, boolean autoLink) throws WCMException {
        StringBuffer buff = new StringBuffer(1024);
        buff.append("<CHNL name='");
        buff.append(parent.getName());
        buff.append("' desc='");
        buff.append(parent.getDesc());
        if (autoLink) {
            buff.append("' link='");
            buff.append(this.getLinkUrl(_context, parent));
        }
        buff.append("'>");
        User loginUser = ContextHelper.getLoginUser();
        List<Channel> children = parent.getChildren(loginUser, chnlType);
        Channel channel = null;
        if ((level == -1 || level > 0) && children.size() > 0) {
            if (level > 0) {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    channel = children.get(i);
                    if (channel == null) continue;
                    buff.append(this.generateXml0(_context, channel, level - 1, chnlType, autoLink));
                }
            } else {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    channel = children.get(i);
                    if (channel == null) continue;
                    buff.append(this.generateXml0(_context, channel, -1, chnlType, autoLink));
                }
            }
        }
        buff.append("</CHNL>");
        return buff.toString();
    }

    private String[] generateJs(PublishTagContext _context, BaseChannel parent, int level, int chnlType, boolean autoLink) throws WCMException {
        return new String[]{this.generateJs0(_context, parent, level, chnlType, autoLink)};
    }

    private String generateJs0(PublishTagContext _context, BaseChannel parent, int level, int chnlType, boolean autoLink) throws WCMException {
        StringBuffer buff = new StringBuffer(1024);
        buff.append("{");
        buff.append("name:'");
        buff.append(parent.getName());
        buff.append("', desc:'");
        buff.append(parent.getDesc());
        if (autoLink) {
            buff.append("', link:'");
            buff.append(this.getLinkUrl(_context, parent));
        }
        buff.append("',chnls:[");
        User loginUser = ContextHelper.getLoginUser();
        List<Channel> children = parent.getChildren(loginUser, chnlType);
        Channel channel = null;
        if ((level == -1 || level > 0) && children.size() > 0) {
            if (level > 0) {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    channel = children.get(i);
                    if (channel == null) continue;
                    buff.append(this.generateJs0(_context, channel, level - 1, chnlType, autoLink));
                    buff.append(',');
                }
            } else {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    channel = children.get(i);
                    if (channel == null) continue;
                    buff.append(this.generateJs0(_context, channel, -1, chnlType, autoLink));
                    buff.append(',');
                }
            }
        }
        buff.append("]");
        buff.append("}");
        return buff.toString();
    }

    private String[] generateHtml(PublishTagContext _context, BaseChannel parent, int level, int chnlType, boolean autoLink) throws WCMException {
        return new String[]{this.generateHtml0(_context, parent, level, chnlType, autoLink)};
    }

    private String generateHtml0(PublishTagContext _context, BaseChannel parent, int level, int chnlType, boolean autoLink) throws WCMException {
        StringBuffer buff = new StringBuffer(1024);
        buff.append("<LI>");
        if (autoLink) {
            buff.append(this.renderLink(_context, parent));
        }
        User loginUser = ContextHelper.getLoginUser();
        List<Channel> children = parent.getChildren(loginUser, chnlType);
        Channel channel = null;
        buff.append("<UL>");
        if ((level == -1 || level > 0) && children.size() > 0) {
            if (level > 0) {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    channel = children.get(i);
                    if (channel == null) continue;
                    buff.append(this.generateHtml0(_context, channel, level - 1, chnlType, autoLink));
                }
            } else {
                int size = children.size();
                for (int i = 0; i < size; ++i) {
                    channel = children.get(i);
                    if (channel == null) continue;
                    buff.append(this.generateHtml0(_context, channel, -1, chnlType, autoLink));
                }
            }
        }
        buff.append("</UL>");
        buff.append("</LI>");
        return buff.toString();
    }

    public void clear() {
        if (this.m_oTagItem != null) {
            this.m_oTagItem.clear();
        }
    }

    private String renderLink(PublishTagContext _context, BaseChannel _host) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_host);
        String sUrl = this.getLinkUrl(_context, folder);
        String sTarget = _context.getAttribute("TARGET");
        String sExtra = _context.getAttribute("EXTRA");
        String sLinkText = _context.getAttribute("LINKTEXT");
        String sAltText = null;
        if (_context.getAttribute("LINKALT", false) && CMyString.isEmpty(sAltText = _context.getAttribute("LINKALTTEXT"))) {
            sAltText = _host.getDesc();
        }
        if (!folder.isLink()) {
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
        }
        return HtmlUtil.renderLink(sUrl, sTarget, sAltText, sExtra, _host.getDesc(), sLinkText);
    }

    private String getLinkUrl(PublishTagContext _context, BaseChannel _host) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_host);
        return this.getLinkUrl(_context, folder);
    }

    private String getLinkUrl(PublishTagContext _context, IPublishFolder folder) throws WCMException {
        TemplateCacheMgr templateCacheMgr;
        Template template;
        String sTempName;
        String sUrl = "";
        sUrl = folder.isLink() ? folder.getLinkUrl() : _context.getPathCompass().getAbsoluteHttpPath(folder);
        if ('/' != sUrl.charAt(sUrl.length() - 1)) {
            sUrl = sUrl + "/";
        }
        if (!CMyString.isEmpty(sTempName = _context.getAttributeTrim("TemplateName")) && (template = (templateCacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr")).lookupByName(folder.getRoot(), sTempName)) != null) {
            sUrl = sUrl + template.getOutputFileName();
            sUrl = sUrl + "_";
            sUrl = sUrl + template.getId();
            sUrl = sUrl + ".";
            sUrl = sUrl + template.getOutputFileExt();
        }
        return sUrl;
    }

    private class TBI
    extends TagBeanInfo {
        private TBI() {
        }

        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            TagBeanInfoHelper.checkChannelName(_folder, _tagItem, _sbResult);
        }
    }
}

