/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.IPublishTaskDocumentsCacheMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PublishTaskDocumentsCacheMgr
implements IPublishTaskDocumentsCacheMgr {
    private static Logger logger = Logger.getLogger(PublishTaskDocumentsCacheMgr.class);
    private Hashtable m_hDocumentsNumCache = new Hashtable(100);
    private Hashtable m_hDocumentsIdListCache = new Hashtable(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Documents get(IPublishFolder _folder, WCMFilter _filter) throws WCMException {
        String sKey = this.makeKey(_folder, _filter);
        boolean bCahced = this.isCached(sKey, _filter);
        if (bCahced) {
            return this.getDocumentsFromCache(_filter, sKey);
        }
        PublishTaskDocumentsCacheMgr publishTaskDocumentsCacheMgr = this;
        synchronized (publishTaskDocumentsCacheMgr) {
            bCahced = this.isCached(sKey, _filter);
            if (bCahced) {
                return this.getDocumentsFromCache(_filter, sKey);
            }
            Channel channel = (Channel)_folder.getSubstance();
            WCMFilter filter = new WCMFilter("", "WCMChnlDoc.DocStatus=?", "");
            filter.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
            filter.addSearchValues(10);
            filter.mergeWith(_filter);
            Documents docs = null;
            if (Document.DOCUMENTS_GET_OPTIMIZE) {
                docs = DocumentsGetHelper.getDocuments(channel, filter);
            } else {
                DocumentMgr mgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                docs = mgr.getDocuments(channel, filter);
            }
            this.put(sKey, _filter, docs);
            docs.m_bNotClearIdList = true;
            return docs;
        }
    }

    private Documents getDocumentsFromCache(WCMFilter _filter, String sKey) {
        Documents documents = new Documents(null);
        documents.setIdList((Vector)this.m_hDocumentsIdListCache.get(sKey), _filter, true);
        return documents;
    }

    @Override
    public void put(IPublishFolder _folder, WCMFilter _filter, Documents _oDocuments) {
        String sKey = this.makeKey(_folder, _filter);
        boolean bCahced = this.isCached(sKey, _filter);
        if (bCahced) {
            return;
        }
        this.put(sKey, _filter, _oDocuments);
    }

    private void put(String _sKey, WCMFilter _filter, Documents _oDocuments) {
        Vector vIdList = _oDocuments.getIdList();
        this.m_hDocumentsNumCache.put(_sKey, new Integer(_filter.getMaxRowNumber()));
        this.m_hDocumentsIdListCache.put(_sKey, vIdList);
    }

    private boolean isCached(String _sKey, WCMFilter _filter) {
        Integer iNum = (Integer)this.m_hDocumentsNumCache.get(_sKey);
        int nNum = -1;
        if (iNum != null) {
            nNum = iNum;
        }
        return nNum == 0 || _filter.getMaxRowNumber() > 0 && nNum >= _filter.getMaxRowNumber();
    }

    private String makeKey(IPublishFolder _folder, WCMFilter _filter) {
        StringBuffer sbKey = new StringBuffer(100);
        sbKey.append("^");
        sbKey.append(_folder.getType());
        sbKey.append(".");
        sbKey.append(_folder.getId());
        sbKey.append("^");
        String sWhere = _filter.getWhere();
        if (sWhere != null) {
            sbKey.append(sWhere.trim().toUpperCase());
        }
        sbKey.append("^");
        String sOrder = _filter.getOrder();
        if (sOrder != null) {
            sbKey.append(sOrder.trim().toUpperCase());
        }
        return sbKey.toString();
    }

    public static void main(String[] args) {
        Vector<String> vId = new Vector<String>(3);
        vId.add("1");
        vId.add("2");
        System.out.println(vId.hashCode());
        vId.add("3");
        System.out.println(vId.hashCode());
        Hashtable<String, Vector<String>> hValue = new Hashtable<String, Vector<String>>();
        hValue.put("1", vId);
        System.out.println(vId);
        ((Vector)vId.clone()).clear();
        System.out.println(vId);
    }
}

