/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParserDocuments;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.Iterator;

public class WCMTagParserEPressNews
extends WCMTagParserDocuments {
    private static TagBeanInfo s_tagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_tagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_EPRESSNEWS");
            tbi.setDesc("TRS_EPRESSNEWS");
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PUBLISHDATE");
            tbai.setDesc("PUBLISHDATE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MAINPAGE");
            tbai.setDefaultValue("\u662f\u5426\u4e3a\u4e3b\u7248\u9762");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHNLDOCSYNCED");
            tbai.setDefaultValue("\u57fa\u672c\u5c5e\u6027\u540c\u6b65\u5230chnldoc");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            Iterator itr = super.getBeanInfo().getAttrInfos();
            while (itr.hasNext()) {
                tbi.addAttrInfo((TagBeanAttrInfo)itr.next());
            }
            tbai = new TagBeanAttrInfo();
            tbai.setName("DOCNUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            s_tagBeanInfo = tbi;
        }
        return s_tagBeanInfo;
    }

    @Override
    protected IPublishElements getPublishedContentsInCurrentFolder(PublishTagContext _context, WCMFilter _filter) throws WCMException {
        try {
            IPublishFolder folder = this.getCurrFolder(_context);
            if (folder == null) {
                return null;
            }
            IPublishElement host = _context.getUpperHost();
            if (host != null && host instanceof IPublishContent) {
                Document doc = (Document)host.getSubstance();
                _context.getPageContext().setExtraAttribute("HISTORYDATE", doc.getPropertyAsString("PublishDate"));
            }
            if (_context.getAttribute("chnldocsynced", false)) {
                return this.getWithChnlDoc(_context, _filter, folder, false);
            }
            WCMFilter filter = this.makeFilter(_context, _filter, folder, false);
            Documents docs = new Documents(null);
            docs.open(filter);
            int nMaxNum = _context.getAttribute("DOCNUM", 0);
            if (nMaxNum > 0 && docs.size() > nMaxNum) {
                int size = docs.size();
                while (size > nMaxNum) {
                    docs.removeAt(--size, false);
                }
            }
            return PublishElementFactory.makeElementsFrom(docs);
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6[" + this.getCurrFolder(_context).getInfo() + "]\u7684\u6570\u636e\u5931\u8d25!", e);
        }
    }

    @Override
    protected IPublishElements getAllContentsInCurrentFolder(PublishTagContext _tagContext, WCMFilter _filter) throws WCMException {
        try {
            IPublishFolder folder = this.getCurrFolder(_tagContext);
            if (folder == null) {
                return null;
            }
            IPublishElement host = _tagContext.getUpperHost();
            if (host != null && host instanceof IPublishContent) {
                Document doc = (Document)host.getSubstance();
                _tagContext.getPageContext().setExtraAttribute("HISTORYDATE", doc.getPropertyAsString("PublishDate"));
            }
            if (_tagContext.getAttribute("chnldocsynced", false)) {
                return this.getWithChnlDoc(_tagContext, _filter, folder, true);
            }
            WCMFilter filter = this.makeFilter(_tagContext, _filter, folder, true);
            Documents docs = new Documents(null);
            docs.open(filter);
            int nMaxNum = _tagContext.getAttribute("DOCNUM", 0);
            if (nMaxNum > 0 && docs.size() > nMaxNum) {
                int size = docs.size();
                while (size > nMaxNum) {
                    docs.removeAt(--size, false);
                }
            }
            return PublishElementFactory.makeElementsFrom(docs);
        }
        catch (WCMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6[" + this.getCurrFolder(_tagContext).getInfo() + "]\u7684\u6570\u636e\u5931\u8d25!", e);
        }
    }

    private IPublishElements getWithChnlDoc(PublishTagContext _tagContext, WCMFilter _filter, IPublishFolder _folder, boolean _bAll) throws WCMException {
        WCMFilter filter = new WCMFilter("", "", "DOCORDERPRI desc,DOCORDER desc");
        StringBuffer buff = new StringBuffer(64);
        buff.append("DOCCHANNEL=? AND ");
        filter.addSearchValues(0, _folder.getId());
        buff.append("ISPAGEIMG=");
        if ("true".equals(_tagContext.getAttribute("MAINPAGE"))) {
            buff.append(1);
            filter.setMaxRowNumber(1);
        } else {
            buff.append(0);
        }
        filter.setSelect("RECID,DOCID");
        String sPublishDate = _tagContext.getAttribute("PUBLISHDATE");
        String sHistoryDate = _tagContext.getPageContext().getExtraAttribute("HISTORYDATE");
        CMyDateTime dtPublishDate = CMyDateTime.now();
        if (!CMyString.isEmpty(sHistoryDate)) {
            try {
                dtPublishDate.setDateTimeWithString(sHistoryDate);
            }
            catch (Exception exception) {}
        } else if (!CMyString.isEmpty(sPublishDate)) {
            try {
                dtPublishDate.setDateTimeWithString(sPublishDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buff.append(" AND PUBLISHDATE=?");
        filter.addSearchValues(1, dtPublishDate.toString("yyyy.MM.dd"));
        if (_bAll) {
            IPublishFolder root = _folder.getRoot();
            IFolderPubStatusCacheMgr manager = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
            int[] arStatusCanPub = manager.findStatusesCanDoPub(root.getType(), root.getId());
            if (arStatusCanPub == null || arStatusCanPub.length == 0) {
                buff.append(" AND DOCSTATUS=");
                buff.append(10);
            } else {
                buff.append(" AND DOCSTATUS in(?");
                filter.addSearchValues(arStatusCanPub[0]);
                int len = arStatusCanPub.length;
                for (int i = 1; i < len; ++i) {
                    buff.append(",?");
                    filter.addSearchValues(arStatusCanPub[i]);
                }
                buff.append(")");
            }
        } else {
            buff.append(" AND DOCSTATUS=");
            buff.append(10);
        }
        filter.setWhere(buff.toString());
        int nMaxNum = _tagContext.getAttribute("DOCNUM", 0);
        if (nMaxNum > 0) {
            filter.setMaxRowNumber(nMaxNum);
        }
        ChnlDocs chnldocs = new ChnlDocs(null);
        chnldocs.open(filter);
        if (chnldocs.isEmpty()) {
            return null;
        }
        buff.setLength(0);
        int size = chnldocs.size();
        for (int i = 0; i < size; ++i) {
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc == null) continue;
            buff.append(',').append(chnldoc.getDocId());
        }
        if (buff.length() == 0) {
            return null;
        }
        Documents docs = Documents.findByIds(null, buff.substring(1));
        if (_filter != null && !CMyString.isEmpty(_filter.getSelect())) {
            docs.setSelect(_filter.getSelect());
        }
        return PublishElementFactory.makeElementsFrom(docs);
    }

    private WCMFilter makeFilter(PublishTagContext _tagContext, WCMFilter _filter, IPublishFolder _folder, boolean _bAll) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMDOCUMENT,WCMCHNLDOC", "", "WCMCHNLDOC.DOCORDERPRI desc,WCMCHNLDOC.DOCORDER desc");
        StringBuffer buff = new StringBuffer(64);
        buff.append("wcmchnldoc.DocChannel=? AND ");
        filter.addSearchValues(0, _folder.getId());
        buff.append("ISPAGEIMG=");
        if ("true".equals(_tagContext.getAttribute("MAINPAGE"))) {
            buff.append(1);
            filter.setMaxRowNumber(1);
            filter.setSelect("PublishDate,Attribute");
        } else {
            buff.append(0);
        }
        String sPublishDate = _tagContext.getAttribute("PUBLISHDATE");
        String sHistoryDate = _tagContext.getPageContext().getExtraAttribute("HISTORYDATE");
        CMyDateTime dtPublishDate = CMyDateTime.now();
        if (!CMyString.isEmpty(sHistoryDate)) {
            try {
                dtPublishDate.setDateTimeWithString(sHistoryDate);
            }
            catch (Exception exception) {}
        } else if (!CMyString.isEmpty(sPublishDate)) {
            try {
                dtPublishDate.setDateTimeWithString(sPublishDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buff.append(" AND PublishDate=?");
        filter.addSearchValues(1, dtPublishDate.toString("yyyy.MM.dd"));
        if (_bAll) {
            IPublishFolder root = _folder.getRoot();
            IFolderPubStatusCacheMgr manager = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
            int[] arStatusCanPub = manager.findStatusesCanDoPub(root.getType(), root.getId());
            if (arStatusCanPub == null || arStatusCanPub.length == 0) {
                buff.append(" AND WCMDocument.DocStatus=");
                buff.append(10);
                buff.append(" AND ");
            } else {
                buff.append(" AND WCMDocument.DocStatus in(?");
                filter.addSearchValues(arStatusCanPub[0]);
                int len = arStatusCanPub.length;
                for (int i = 1; i < len; ++i) {
                    buff.append(",?");
                    filter.addSearchValues(arStatusCanPub[i]);
                }
                buff.append(") AND ");
            }
        } else {
            buff.append(" AND WCMDocument.DocStatus=");
            buff.append(10);
            buff.append(" AND ");
        }
        buff.append("modal=1 ");
        buff.append("and WCMCHNLDOC.DOCID=WCMDOCUMENT.DOCID");
        filter.setWhere(buff.toString());
        filter.mergeWith(_filter);
        return filter;
    }
}

