/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import common.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class WCMTagEPressMainResParser
implements ITagParser {
    private static final Logger LOG = Logger.getLogger(WCMTagEPressMainResParser.class);
    private static TagBeanInfo s_TagBeanInfo = null;

    public void clear() {
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_EPRESSMAINRES");
            tbi.setDesc("TRS_EPRESSMAINRES");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"PIC", "PDF"});
            tbai.setDefaultValue("FILE");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("BEGINHTML");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENDHTML");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MEMO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("BEGINMEMO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENDMEMO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SEPERATOR");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UPLOAD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAMEONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RELATEDCOLUMN");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement content = _context.getUpperHost();
        if (content == null || !(content instanceof IPublishContent)) {
            return null;
        }
        CMSObj doc = content.getSubstance();
        if (doc == null) {
            return null;
        }
        int nMainDocId = this.getMainId(doc.getPropertyAsInt("DOCCHANNEL", 0), doc.getPropertyAsString("PUBLISHDATE"));
        if (nMainDocId == 0) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "APPDOCID=? and APPFLAG=?", "");
        filter.addSearchValues(nMainDocId);
        String mode = _context.getAttribute("MODE");
        if ("pdf".equalsIgnoreCase(mode)) {
            filter.addSearchValues(10);
        } else {
            filter.addSearchValues(20);
        }
        filter.setMaxRowNumber(1);
        Appendixes appendixes = new Appendixes(null);
        appendixes.open(filter);
        if (appendixes.isEmpty()) {
            return null;
        }
        int nReturnMode = _context.getAttribute("NAMEONLY", false) ? 1 : 2;
        return new String[]{WCMAppendixGenerator.generateAppendix((Appendix)appendixes.getAt(0), (IPublishContent)content, _context, nReturnMode)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMainId(int nDocChannel, String sPubDate) {
        String sql = "select DOCID from WCMDOCUMENT where DOCCHANNEL=? and PUBLISHDATE=? and ISPAGEIMG=1";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DBManager dbman = DBManager.getDBManager();
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, nDocChannel);
            pstmt.setString(2, sPubDate);
            pstmt.setFetchSize(1);
            pstmt.setMaxRows(1);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"failed to get main page docid.", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbman.freeConnection(conn);
            }
        }
        return 0;
    }
}

