/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.html.HtmlUtil;
import java.util.HashMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TagEBookDirParser
implements ITagParser {
    private static TagBeanInfo s_oTagBeanInfo;
    private TagItem m_oTagItem;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_oTagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_BOOKDIR");
            tbi.setDesc("\u4e66\u76ee\u5f55\u7d22\u5f15\u7f6e\u6807\u89e3\u91ca");
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setDesc("\u4e66\u7684\u6807\u8bc6ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("USEABSURL");
            tbai.setDesc("\u8fd4\u56de\u7edd\u5bf9\u8def\u5f84\u94fe\u63a5");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("PAGEDIGITAL");
            tbai.setDesc("\u9875\u9762\u4f4d\u6570");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("3");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATAFORMAT");
            tbai.setDesc("\u8fd4\u56de\u7684\u6570\u636e\u683c\u5f0f");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("xml");
            tbi.addAttrInfo(tbai);
        }
        return s_oTagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_oTagItem = _item;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Channel channel = (Channel)WCMTagParserHelper.findFolderHost(this.m_oTagItem, _context, true);
        if (channel == null) {
            throw new WCMException("\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u6709\u8bef,\u4e0d\u662f\u5e94\u7528\u5728\u4e00\u4e2a\u6709\u6548\u7684Folder\u4e0a");
        }
        boolean zAbsUrl = _context.getAttribute("USEABSURL", false);
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", "DocChannel=? and DocStatus>0", "");
        filter.setOrder("PAGENUM asc,PAGEORDER asc,DocId asc");
        filter.setSelect("DocId,DocTitle,Piece,Charpter,PageName,PageSect,DocChannel,CrTime,DocStatus");
        filter.addSearchValues(0, channel.getId());
        Documents documents = new Documents(null);
        documents.open(filter);
        Document document = null;
        String piece = null;
        String charpter = null;
        String pagename = null;
        String pagesect = null;
        String title = null;
        String link = null;
        Element parentEl = null;
        Element currCharpter = null;
        Element temp = null;
        HashMap<String, Element> bookdir = new HashMap<String, Element>(50);
        String lastPageName = "";
        String lastPageSect = "";
        String id = "";
        Element rootEl = DocumentHelper.createElement((String)"STRUCTURE");
        int size = documents.size();
        for (int i = 0; i < size; ++i) {
            document = (Document)documents.getAt(i);
            piece = TagEBookDirParser.getProperty(document, "PIECE");
            charpter = TagEBookDirParser.getProperty(document, "CHARPTER");
            pagename = TagEBookDirParser.getProperty(document, "PAGENAME");
            pagesect = TagEBookDirParser.getProperty(document, "PAGESECT");
            title = document.getTitle();
            id = String.valueOf(document.getId());
            link = TagEBookDirParser.makeLink(folder, document, zAbsUrl, _context);
            if (!TagEBookDirParser.isEmpty(piece)) {
                parentEl = (Element)bookdir.get(piece);
                if (parentEl == null) {
                    parentEl = rootEl.addElement("PIECE");
                    parentEl.addAttribute("name", piece);
                    parentEl.addAttribute("link", link);
                    parentEl.addAttribute("id", id);
                    bookdir.put(piece, parentEl);
                }
                if (TagEBookDirParser.isEmpty(charpter)) continue;
                String key = piece + charpter;
                currCharpter = (Element)bookdir.get(key);
                if (currCharpter == null) {
                    currCharpter = parentEl.addElement("CHAPTER");
                    currCharpter.addAttribute("name", charpter);
                    currCharpter.addAttribute("link", link);
                    currCharpter.addAttribute("id", id);
                    bookdir.put(key, currCharpter);
                    lastPageName = "";
                }
                if (TagEBookDirParser.isEmpty(pagename)) continue;
                key = key + pagename;
                if (!lastPageName.equals(pagename)) {
                    temp = currCharpter.addElement("SECTION");
                    temp.addAttribute("name", pagename);
                    temp.addAttribute("link", link);
                    temp.addAttribute("id", id);
                    lastPageName = pagename;
                    bookdir.put(key, temp);
                }
                if (TagEBookDirParser.isEmpty(pagesect)) continue;
                temp = ((Element)bookdir.get(key)).addElement("ITEM");
                if (TagEBookDirParser.isEmpty(pagesect)) {
                    pagesect = title;
                }
                temp.addAttribute("name", pagesect);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                continue;
            }
            if (TagEBookDirParser.isEmpty(charpter)) {
                temp = rootEl.addElement("PIECE");
                temp.addAttribute("name", title);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                continue;
            }
            currCharpter = (Element)bookdir.get(charpter);
            if (currCharpter == null) {
                currCharpter = rootEl.addElement("PIECE");
                currCharpter.addAttribute("name", charpter);
                currCharpter.addAttribute("link", link);
                currCharpter.addAttribute("id", id);
                bookdir.put(charpter, currCharpter);
                lastPageName = "";
                if (TagEBookDirParser.isEmpty(pagename)) continue;
                temp = currCharpter.addElement("CHAPTER");
                temp.addAttribute("name", pagename);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                bookdir.put(pagename, temp);
                lastPageName = pagename;
                continue;
            }
            if (!lastPageName.equals(pagename)) {
                temp = currCharpter.addElement("CHAPTER");
                temp.addAttribute("name", pagename);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                bookdir.put(pagename, temp);
                lastPageName = pagename;
                continue;
            }
            currCharpter = (Element)bookdir.get(pagename);
            if (!lastPageSect.equals(pagesect)) {
                temp = currCharpter.addElement("SECTION");
                if (TagEBookDirParser.isEmpty(pagesect)) {
                    pagesect = title;
                }
                temp.addAttribute("name", pagesect);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                lastPageSect = pagesect;
                continue;
            }
            currCharpter = (Element)bookdir.get(pagesect);
            temp = currCharpter.addElement("ITEM");
            temp.addAttribute("name", title);
            temp.addAttribute("link", link);
            temp.addAttribute("id", id);
            bookdir.put(pagesect, temp);
        }
        bookdir.clear();
        return new String[]{rootEl.asXML()};
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static String makeLink(IPublishFolder folder, Document document, boolean zAbsUrl, PublishTagContext context) throws WCMException {
        IPublishContent content = PublishElementFactory.makeContentFrom(document, folder);
        String link = context.getPathCompass().getHttpUrl(content, 0);
        if (!zAbsUrl) {
            link = HtmlUtil.calRelativePath(link, context.getPageHttpPath());
        }
        return link;
    }

    public void clear() {
        if (this.m_oTagItem != null) {
            this.m_oTagItem.clear();
            this.m_oTagItem = null;
        }
    }

    public static void main(String[] args) {
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", "DocChannel=? and DocStatus>0", "");
        filter.setOrder("PAGENUM asc,DocId asc");
        filter.setSelect("DocId,DocTitle,Piece,Charpter,PageName,PageSect,DocChannel,CrTime,DocStatus");
        filter.addSearchValues(0, 834);
        Documents documents = new Documents(null);
        try {
            documents.open(filter);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        Document document = null;
        String piece = null;
        String charpter = null;
        String pagename = null;
        String pagesect = null;
        String title = null;
        String link = null;
        Element parentEl = null;
        Element currCharpter = null;
        Element temp = null;
        HashMap<String, Element> bookdir = new HashMap<String, Element>(50);
        String lastPageName = "";
        String lastPageSect = "";
        String id = "";
        Element rootEl = DocumentHelper.createElement((String)"STRUCTURE");
        int size = documents.size();
        for (int i = 0; i < size; ++i) {
            document = (Document)documents.getAt(i);
            piece = TagEBookDirParser.getProperty(document, "PIECE");
            charpter = TagEBookDirParser.getProperty(document, "CHARPTER");
            pagename = TagEBookDirParser.getProperty(document, "PAGENAME");
            pagesect = TagEBookDirParser.getProperty(document, "PAGESECT");
            title = document.getTitle();
            link = id = String.valueOf(document.getId());
            if (!TagEBookDirParser.isEmpty(piece)) {
                parentEl = (Element)bookdir.get(piece);
                if (parentEl == null) {
                    parentEl = rootEl.addElement("PIECE");
                    parentEl.addAttribute("name", piece);
                    parentEl.addAttribute("link", link);
                    parentEl.addAttribute("id", id);
                    bookdir.put(piece, parentEl);
                }
                if ((currCharpter = (Element)bookdir.get(charpter)) == null) {
                    currCharpter = parentEl.addElement("CHAPTER");
                    currCharpter.addAttribute("name", charpter);
                    currCharpter.addAttribute("link", link);
                    currCharpter.addAttribute("id", id);
                    bookdir.put(charpter, currCharpter);
                }
                if (TagEBookDirParser.isEmpty(pagename)) continue;
                if (!lastPageName.equals(pagename)) {
                    temp = currCharpter.addElement("SECTION");
                    temp.addAttribute("name", pagename);
                    temp.addAttribute("link", link);
                    temp.addAttribute("id", id);
                    lastPageName = pagename;
                    bookdir.put(pagename, temp);
                }
                if (TagEBookDirParser.isEmpty(pagesect)) continue;
                temp = ((Element)bookdir.get(pagename)).addElement("ITEM");
                if (TagEBookDirParser.isEmpty(pagesect)) {
                    pagesect = title;
                }
                temp.addAttribute("name", pagesect);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                continue;
            }
            if (TagEBookDirParser.isEmpty(charpter)) {
                temp = rootEl.addElement("PIECE");
                temp.addAttribute("name", title);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                continue;
            }
            currCharpter = (Element)bookdir.get(charpter);
            if (currCharpter == null) {
                currCharpter = rootEl.addElement("PIECE");
                currCharpter.addAttribute("name", charpter);
                currCharpter.addAttribute("link", link);
                currCharpter.addAttribute("id", id);
                bookdir.put(charpter, currCharpter);
                if (TagEBookDirParser.isEmpty(pagename)) continue;
                temp = currCharpter.addElement("CHAPTER");
                temp.addAttribute("name", pagename);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                bookdir.put(pagename, temp);
                lastPageName = pagename;
                continue;
            }
            if (!lastPageName.equals(pagename)) {
                temp = currCharpter.addElement("CHAPTER");
                temp.addAttribute("name", pagename);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                bookdir.put(pagename, temp);
                lastPageName = pagename;
                continue;
            }
            currCharpter = (Element)bookdir.get(pagename);
            if (!lastPageSect.equals(pagesect)) {
                temp = currCharpter.addElement("SECTION");
                if (TagEBookDirParser.isEmpty(pagesect)) {
                    pagesect = title;
                }
                temp.addAttribute("name", pagesect);
                temp.addAttribute("link", link);
                temp.addAttribute("id", id);
                lastPageSect = pagesect;
                continue;
            }
            currCharpter = (Element)bookdir.get(pagesect);
            temp = currCharpter.addElement("ITEM");
            temp.addAttribute("name", title);
            temp.addAttribute("link", link);
            temp.addAttribute("id", id);
            bookdir.put(pagesect, temp);
        }
        bookdir.clear();
        System.out.println(rootEl.asXML());
    }

    private static String getProperty(Document document, String propName) {
        String propValue = document.getPropertyAsString(propName);
        if (TagEBookDirParser.isEmpty(propValue)) {
            propValue = "";
        }
        return propValue;
    }
}

