/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.contentlink;

import com.trs.components.wcm.contentlink.IVContentLinkParser;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TxtFileParserForContentLink
implements IVContentLinkParser {
    @Override
    public Map parse(String filename) throws WCMException {
        BufferedReader reader = null;
        InputStreamReader insr = null;
        InputStream ins = null;
        HashMap contentLinkMap = new HashMap();
        FileService file = new FileService(filename);
        if (!file.exists() || file.isDirectory()) {
            throw new WCMException(10, "\u6ca1\u6709\u8fd9\u4e2a\u6587\u4ef6\uff1a" + filename);
        }
        try {
            char ch;
            ins = file.getInputStream();
            String encoding = CharsetDetector.detect(filename);
            insr = new InputStreamReader(ins, encoding);
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            if (line == null) {
                throw new WCMException(10, "\u65e0\u6548\u7684\u8f93\u5165\uff0c\u5b83\u662f\u4e00\u4e2a\u7a7a\u6587\u4ef6\u3002");
            }
            if (line.length() > 0 && "utf-8".equals(encoding) && ((ch = line.charAt(0)) == '\ufeff' || ch == '\ufffe')) {
                line = line.substring(1);
            }
            Pattern pattern = Pattern.compile("^[\u4e00-\u9fa5\\w]+$");
            int i = 0;
            while (line != null && line.length() > 0) {
                String[] sInfo = (line = line.trim()).split("\\t");
                if (sInfo.length < 2) {
                    throw new WCMException(10, "\u7f3a\u5c11\u5b57\u6bb5\u4fe1\u606f,\u5fc5\u987b\u8f93\u5165\u70ed\u8bcd\u540d\u79f0\u548c\u94fe\u63a5\uff01");
                }
                String sContentLinkName = sInfo[0];
                String sContentLinkHttp = sInfo[1];
                String sBcontainsChildren = "0";
                if (sInfo.length == 3) {
                    sBcontainsChildren = sInfo[2];
                }
                String sLinkTitle = "";
                if (sInfo.length > 3) {
                    sLinkTitle = sInfo[3];
                }
                if (CMyString.isEmpty(sContentLinkName) || CMyString.isEmpty(sContentLinkHttp)) {
                    throw new WCMException(10, "\u70ed\u8bcd\u540d\u79f0\u548c\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (sContentLinkName.length() > 30) {
                    throw new WCMException(10, "\u65e0\u6548\u7684\u540d\u79f0.\u8fd9\u4e2a\u540d\u79f0[" + sContentLinkName + "]\u592a\u957f\u4e86.");
                }
                if (!pattern.matcher(sContentLinkName).matches()) {
                    throw new WCMException(10, "\u65e0\u6548\u7684\u540d\u79f0.\u8fd9\u4e2a\u540d\u79f0[" + sContentLinkName + "]\u5305\u542b\u975e\u6cd5\u5b57\u7b26.");
                }
                if (!sContentLinkHttp.matches("^http://([\\w-]+\\.)+[\\w-]+(:[0-9]{1,5})?(/[\\w-./?%&=]*)?$")) {
                    throw new WCMException(10, "\u65e0\u6548\u7684\u94fe\u63a5.\u8fd9\u4e2a\u540d\u79f0[" + sContentLinkHttp + "]\u4e0d\u7b26\u5408\u683c\u5f0fprotocol://host:port/path.");
                }
                if (!sBcontainsChildren.matches("[0-1]{1}")) {
                    throw new WCMException(10, "\u662f\u5426\u53ef\u4ee5\u5728\u5b50\u680f\u76ee\u4e2d\u4f7f\u7528\u7684\u503c[" + sContentLinkHttp + "]\u65e0\u6548\uff0c\u5408\u6cd5\u7684\u683c\u5f0f\u4e3a0\u6216\u80051.");
                }
                ArrayList<String> infoList = new ArrayList<String>();
                infoList.add(sContentLinkName);
                infoList.add(sContentLinkHttp);
                infoList.add(sBcontainsChildren);
                infoList.add(sLinkTitle);
                Integer index = new Integer(++i);
                contentLinkMap.put(index, infoList);
                line = reader.readLine();
            }
            HashMap hashMap = contentLinkMap;
            return hashMap;
        }
        catch (WCMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(50, "\u89e3\u6790\u6587\u4ef6\u5931\u8d25.", ex);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            file.delete();
        }
    }

    public static void main(String[] args) {
        System.out.println("http://www.baidu.com".matches("^[\\w.////:]+$"));
    }
}

