/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.eprobiti.trs.TRSConnection;
import com.trs.infra.I18NMessage;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TRSConnectionPool
implements Runnable {
    private static Logger logger = Logger.getLogger(TRSConnectionPool.class);
    public boolean IS_DEBUG = true;
    private static String m_sServer = "";
    private static String m_sServerPort = "";
    private static String m_sUserName = "";
    private static String m_sPassWord = "";
    private int maxConnections;
    private Vector availableConnections;
    private Vector busyConnections;

    public TRSConnectionPool() {
    }

    public TRSConnectionPool(String _sServer, String _sServerPort, String _sUserName, String _sPassWord, int initialConnections, int maxConnections, boolean waitIfBusy) throws Exception {
        m_sServer = _sServer;
        m_sServerPort = _sServerPort;
        m_sUserName = _sUserName;
        m_sPassWord = _sPassWord;
    }

    public synchronized void closeAllConnections() {
        if (this.availableConnections != null) {
            this.closeConnections(this.availableConnections);
            this.availableConnections.clear();
        }
        if (this.busyConnections != null) {
            this.closeConnections(this.busyConnections);
            this.busyConnections.clear();
        }
    }

    private void closeConnections(Vector connections) {
        try {
            for (int i = 0; i < connections.size(); ++i) {
                TRSConnection connection = (TRSConnection)connections.elementAt(i);
                if (connection.isClosed()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label1", "\u5173\u95edTRS\u8fde\u63a5(TRSConnectionPool.closeConnections)"));
                }
                connection.close();
            }
        }
        catch (Exception sqle) {
            logger.error((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label2", "\u5173\u95edConnection\u5931\u8d25\uff01"), (Throwable)sqle);
        }
    }

    public void free(TRSConnection connection) {
        connection.close();
        connection = null;
    }

    public boolean isValid(TRSConnection _currConnection) {
        try {
            _currConnection.getConfig();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public TRSConnection getConnection() throws Exception {
        TRSConnection conn = this.makeNewConnection();
        if (conn != null) {
            return conn;
        }
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(800L);
            conn = this.makeNewConnection();
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    private TRSConnection makeNewConnection() throws Exception {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label8", "\uff1a\u6b63\u5728\u8fde\u63a5TRSServer........(TRSConnectionPool.makeNewConnection)"));
                logger.debug((Object)("m_sServer:" + m_sServer));
                logger.debug((Object)("m_sServerPort:" + m_sServerPort));
            }
            TRSConnection trsConn = new TRSConnection();
            trsConn.connect(m_sServer, m_sServerPort, m_sUserName, m_sPassWord);
            trsConn.setAutoExtend("", "", "", 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label9", "\uff1a\u8fde\u63a5TRSServer\u5b8c\u6210\uff01(TRSConnectionPool.makeNewConnection)"));
            }
            return trsConn;
        }
        catch (Exception ex) {
            logger.error((Object)(I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label10", "\u5efa\u7acbTRS\u8fde\u63a5[") + m_sServer + ":" + m_sServerPort + I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label11", "]\u5931\u8d25\uff01")), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void run() {
    }

    public synchronized String toString() {
        String info = "ConnectionPool(" + m_sServer + "," + m_sUserName + "), available=" + this.availableConnections.size() + ", busy=" + this.busyConnections.size() + ", max=" + this.maxConnections;
        return info;
    }

    public synchronized int totalConnections() {
        return this.availableConnections.size() + this.busyConnections.size();
    }

    public synchronized void reopenAllConnection() throws Exception {
        for (int i = 0; i < this.availableConnections.size(); ++i) {
            TRSConnection connection = (TRSConnection)this.availableConnections.get(i);
            try {
                logger.debug((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label12", "\u6b63\u5728\u91cd\u65b0\u8fde\u63a5TRS...........(TRSConnectionPool.reopenAllConnection)"));
                connection.reconnect(m_sServer, m_sServerPort, m_sUserName, m_sPassWord);
                logger.debug((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label13", "\u91cd\u65b0\u8fde\u63a5\u5b8c\u6210\uff01(TRSConnectionPool.reopenAllConnection)"));
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)I18NMessage.get(TRSConnectionPool.class, "TRSConnectionPool.label14", "\u91cd\u65b0\u8fde\u63a5TRS\u53d1\u751f\u5f02\u5e38\uff01(TRSConnectionPool.reopenAllConnection)"), (Throwable)ex);
                throw ex;
            }
        }
    }
}

