/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Documents
extends CMSBaseObjs {
    private String m_sTableName = null;
    private int m_nRecCount = -1;
    private int m_nCurrentStartIndex = -1;
    static Logger s_logger = Logger.getLogger(Documents.class);
    public boolean m_bNotClearIdList = false;

    public Documents(User _currUser) {
        super(_currUser);
    }

    public Documents(User _currUser, int _initCapacity, int _incCapacity) {
        super(_currUser, _initCapacity, _incCapacity);
    }

    public void setDbTableName(String _sTableName) {
        this.m_sTableName = _sTableName;
    }

    @Override
    public String getDbTableName() {
        if (this.m_sTableName != null && this.m_sTableName.length() > 0) {
            return this.m_sTableName;
        }
        return "WCMDOCUMENT";
    }

    @Override
    public String getIdFieldName() {
        return "DOCID";
    }

    @Override
    public Class getElementClass() {
        return Document.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new Documents(this.currUser);
    }

    public boolean addElementById(int _id) throws Exception {
        try {
            if (_id <= 0 || this.indexOf(_id) >= 0) {
                return false;
            }
            this.vIdList.addElement(new Integer(_id));
            this.currIndex = this.size() - 1;
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Documents.class, "Documents.label1", "\u6dfb\u52a0\u5143\u7d20\u5230\u96c6\u5408\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".addElement).", ex);
        }
    }

    @Override
    public void setRecCount(int _nRecCount) {
        if (_nRecCount < 0) {
            return;
        }
        this.m_nRecCount = _nRecCount;
    }

    @Override
    public int getRecCount() {
        if (this.m_nRecCount < 0) {
            return this.size();
        }
        return this.m_nRecCount;
    }

    public int getCurrentStartIndex() {
        return this.m_nCurrentStartIndex;
    }

    public void setCurrentStartIndex(int _nCurrentStartIndex) {
        this.m_nCurrentStartIndex = _nCurrentStartIndex;
    }

    @Override
    public int size() {
        if (this.m_nRecCount <= 0) {
            return super.size();
        }
        return this.m_nRecCount;
    }

    @Override
    public BaseObj getAt(int _index) {
        if (this.m_nCurrentStartIndex < 0) {
            return super.getAt(_index);
        }
        return super.getAt(_index - this.m_nCurrentStartIndex);
    }

    public static final Documents findByIds(User _currUser, String _sIds) {
        Documents currDocuments = Documents.createNewInstance(_currUser);
        if (_sIds == null || _sIds.length() <= 0) {
            return currDocuments;
        }
        currDocuments.addElement(_sIds);
        return currDocuments;
    }

    public static final Documents openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        Documents currDocuments = Documents.createNewInstance(_currUser);
        currDocuments.open(_filter);
        return currDocuments;
    }

    public static Documents createNewInstance(User _currUser) {
        return new Documents(_currUser);
    }

    public static void main(String[] args) {
        Document currDocument = null;
        Documents currDocuments = Documents.createNewInstance(User.getSystem());
        try {
            WCMFilter currFilter = new WCMFilter();
            currFilter.setMaxRowNumber(4);
            currDocuments = Documents.openWCMObjs(User.getSystem(), currFilter);
            System.out.println("size:" + currDocuments.size());
            for (int i = 0; i < currDocuments.size(); ++i) {
                currDocument = (Document)currDocuments.getAt(i);
                s_logger.info((Object)("[" + (i + 1) + "]:" + currDocument.getTitle() + "[" + currDocument.getId() + "]"));
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(Documents.class, "Documents.label2", "\u6d4b\u8bd5openWCMObjs\u5931\u8d25\uff01"), (Throwable)ex);
        }
    }

    @Override
    protected BaseObj createElementInstance() {
        Document document = new Document();
        if (this.m_sTableName != null) {
            document.setDbTableName(this.m_sTableName);
        }
        return document;
    }

    public void insertOtherTable(User _currUser, String _sTableName) throws WCMException {
        for (int i = 0; i < this.size(); ++i) {
            Document document = (Document)this.getAt(i);
            if (document == null) continue;
            document.insertOtherTable(_currUser, _sTableName);
        }
    }

    public Vector getIdList() {
        return this.vIdList;
    }

    public void setIdList(Vector _vIdList, WCMFilter _filter, boolean _bNotClear) {
        this.vIdList = _vIdList;
        this.currIndex = this.vIdList.isEmpty() ? -2 : 0;
        this.filter = _filter;
        this.m_bNotClearIdList = _bNotClear;
    }

    @Override
    public void clear() {
        if (this.m_oObjsBuffer != null) {
            this.m_oObjsBuffer.clear();
        }
        if (this.m_bNotClearIdList) {
            return;
        }
        super.clear();
    }
}

