/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import org.dom4j.Element;

public class DocumentXmlConverter
extends BaseObjToXmlConverter {
    private boolean m_bWithAppendix = false;
    private ObjToXmlConverter m_converter = new ObjToXmlConverter();

    @Override
    protected Element toXmlElement(BaseObj obj, String fieldsList) throws WCMException {
        Element currElement = super.toXmlElement(obj, fieldsList);
        currElement.element("PROPERTIES").addElement("CHNLNAME");
        Document currDocument = (Document)obj;
        if (currDocument != null) {
            String sChnlName = currDocument.getChannelName();
            currElement.element("PROPERTIES").element("CHNLNAME").addCDATA(sChnlName);
            int nAttachPic = currDocument.getPropertyAsInt("ATTACHPIC", 0);
            if (!this.isWithAppendix() && nAttachPic > 0) {
                currElement.element("PROPERTIES").element("ATTACHPIC").addCDATA("0");
            }
        }
        return currElement;
    }

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        if (this.isWithAppendix()) {
            AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            Appendixes appendixes = appendixMgr.getAppendixes((Document)_baseObj, -1);
            return new Element[]{this.m_converter.toXmlElement(appendixes, null)};
        }
        return null;
    }

    public boolean isWithAppendix() {
        return this.m_bWithAppendix;
    }

    public void setWithAppendix(boolean withAppendix) {
        this.m_bWithAppendix = withAppendix;
    }
}

