/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.domain.DocumentLCListenerForRelDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlElement;
import com.trs.infra.util.html.HtmlElementFinder;
import org.apache.log4j.Logger;

public class DocumentLCListenerForDocForm
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForRelDocs.class);

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Document document = (Document)_oObjAdded;
        int nDocForm = document.getPropertyAsInt("DOCFORM", 0);
        if (nDocForm == 0) {
            nDocForm = this.resetDocForm4Add(document);
            document.refreshProperty("DOCFORM", nDocForm);
            this.updateSQL(nDocForm, document.getId());
        }
    }

    private int resetDocForm4Add(Document document) throws WCMException {
        int nDocForm = this.getDocFormBySite(document);
        if (nDocForm != 0) {
            return nDocForm;
        }
        int nDocType = document.getType();
        if (nDocType == 40) {
            String sFileName = document.getPropertyAsString("DOCFILENAME");
            nDocForm = this.analyzeExt(sFileName);
        } else if (nDocType == 20) {
            String sHtmlCon = document.getHtmlContent();
            nDocForm = this.analyzeDocForm(sHtmlCon);
        } else {
            nDocForm = 1;
        }
        return nDocForm;
    }

    private int getDocFormBySite(Document document) throws WCMException {
        int nDocForm = 0;
        Channel channel = document.getChannel();
        if (channel == null) {
            return nDocForm;
        }
        WebSite site = channel.getSite();
        if (site == null) {
            return nDocForm;
        }
        int nSiteType = site.getType();
        switch (nSiteType) {
            case 1: {
                nDocForm = 2;
                break;
            }
            case 2: {
                nDocForm = 4;
                break;
            }
        }
        return nDocForm;
    }

    private void updateSQL(int nDocForm, int nDocId) throws WCMException {
        String[] sSql = new String[]{"UPDATE WCMCHNLDOC SET DocForm=" + nDocForm + " WHERE DocId=" + nDocId, "UPDATE WCMDOCUMENT SET DocForm=" + nDocForm + " WHERE DocId=" + nDocId};
        DBManager.getDBManager().sqlExecuteUpdate(sSql);
    }

    private int analyzeExt(String _src) {
        if (CMyString.isEmpty(_src)) {
            return 1;
        }
        String sPicExt = "jpg,jpeg,gif,png,bmp";
        String sAudioExt = "wav,mid,midi,mp3,mpa,mp2,ra,ram,rm,wma";
        String sVideoExt = "asf,avi,mpg,mpeg,mpe,mov,rm,rmvb,wmv,swf,flv,mp4,f4v";
        String[] extGroup = new String[]{sPicExt, sAudioExt, sVideoExt};
        int[] nDocForm = new int[]{2, 3, 4};
        for (int i = 0; i < extGroup.length; ++i) {
            for (int j = 0; j < extGroup[i].split(",").length; ++j) {
                if (_src.indexOf("." + extGroup[i].split(",")[j]) < 0) continue;
                return nDocForm[i];
            }
        }
        return 1;
    }

    private int analyzeDocForm(String _sDocHtmlCon) throws WCMException {
        if (CMyString.isEmpty(_sDocHtmlCon)) {
            return 1;
        }
        HtmlElementFinder elementFinder = null;
        HtmlElement element = null;
        try {
            String sSrc;
            elementFinder = new HtmlElementFinder(_sDocHtmlCon);
            element = elementFinder.findNextElement("EMBED", false);
            if (element != null && !CMyString.isEmpty(sSrc = element.getAttributeValue("src"))) {
                return this.analyzeExt(sSrc);
            }
            elementFinder.setPosition(0);
            element = elementFinder.findNextElement("script", false);
            if (element != null && !CMyString.isEmpty(sSrc = element.getAttributeValue("src")) && sSrc.toLowerCase().indexOf("swfobject.js") >= 0) {
                return 4;
            }
            elementFinder.setPosition(0);
            element = elementFinder.findNextElement("IMG", false);
            if (element != null) {
                return 2;
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(HTMLContent.class, "HTMLContent.label112", "\u89e3\u6790\u6587\u6863\u6240\u5c5e\u5173\u7cfb\u53d1\u751f\u9519\u8bef!"), ex);
        }
        return 1;
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(DocumentLCListenerForDocForm.class, "DocumentLCListenerForDocForm.label3", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        int nDocForm = _oObjModified.getNewPropertyAsInt("DOCFORM", 0);
        if (nDocForm == 0) {
            Document document = (Document)_oObjModified;
            nDocForm = this.resetDocForm4Mod(document);
            document.refreshProperty("DOCFORM", nDocForm);
            this.updateSQL(nDocForm, document.getId());
        }
    }

    private int resetDocForm4Mod(Document document) throws WCMException {
        int nDocForm = this.getDocFormBySite(document);
        if (nDocForm != 0) {
            return nDocForm;
        }
        int nDocType = document.getNewPropertyAsInt("DOCTYPE", 0);
        if (nDocType == 40) {
            String sFileName = document.getNewPropertyAsString("DOCFILENAME");
            nDocForm = this.analyzeExt(sFileName);
        } else if (nDocType == 20) {
            String sHtmlCon = document.getNewPropertyAsString("DOCHTMLCON");
            nDocForm = this.analyzeDocForm(sHtmlCon);
        } else {
            nDocForm = 1;
        }
        return nDocForm;
    }
}

