/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class DocumentLCListenerAfterModify
implements IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerAfterModify.class);

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!(objModified instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + objModified.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        ChnlDoc oChnlDoc = (ChnlDoc)objModified;
        boolean isDocStatusProChanged = oChnlDoc.isChangeProperty("DOCSTATUS");
        if (!isDocStatusProChanged) {
            return;
        }
        int nOldDocStatus = oChnlDoc.getStatusId();
        int nNewDocStatus = oChnlDoc.getNewPropertyAsInt("DOCSTATUS", 0);
        if (nOldDocStatus > 0 && nNewDocStatus > 0) {
            return;
        }
        if (nOldDocStatus < 0 && nNewDocStatus < 0) {
            return;
        }
        boolean isObjDeleted = false;
        if (nOldDocStatus > 0 && nNewDocStatus < 0) {
            isObjDeleted = true;
        }
        WCMFilter filter = new WCMFilter("", "OBJTYPE=? and OBJID=?", "");
        filter.addSearchValues(605);
        filter.addSearchValues(oChnlDoc.getDocId());
        FlowDocs oFlowDocs = FlowDocs.openWCMObjs(null, filter);
        if (oFlowDocs.size() <= 0) {
            return;
        }
        int nSize = oFlowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            FlowDoc oFlowDoc = (FlowDoc)oFlowDocs.getAt(i);
            if (oFlowDoc == null) continue;
            oFlowDoc.setObjDeleted(isObjDeleted);
            oFlowDoc.save();
        }
    }
}

