/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.eprobiti.trs.TRSConnection;
import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.trsserver.DocsFromTRSServer;
import com.trs.components.wcm.content.trsserver.TRSToWCMFilter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DocKeywordMgrImpl
implements IDocKeywordMgr {
    private static Logger logger = Logger.getLogger(DocKeywordMgrImpl.class);
    private static final String sInsertSQL = "insert into WCMDOCKEYWORD(DocId, DOCCRTIME, DOCKEYWORD, DOCKEYWORDORDER,SITEID)values(?, ?, ?, ?,?)";
    public static boolean GET_FROM_TRSSERVER = false;

    @Override
    public void addNewDocKeywords(Document _document) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return;
        }
        if (_document == null) {
            return;
        }
        String sKeywords = _document.getKeywords();
        this.putKeywords(_document, sKeywords);
    }

    private void putKeywords(Document _document, String _sKeywords) throws WCMException {
        if (_sKeywords == null || (_sKeywords = _sKeywords.trim()).length() <= 0) {
            return;
        }
        DBManager dbMgr = DBManager.getDBManager();
        Channel docChannel = _document.getChannel();
        int nSiteId = 0;
        if (docChannel != null) {
            nSiteId = docChannel.getSiteId();
        }
        Integer iSiteId = new Integer(nSiteId);
        Object[] pInsertArgs = new Object[5];
        pInsertArgs[0] = _document.getKey();
        CMyDateTime dtTime = _document.getReleaseTime();
        if (dtTime == null || dtTime.isNull()) {
            dtTime = _document.getCrTime();
        }
        pInsertArgs[1] = dtTime.toTimestamp();
        String[] pKeywords = CMyString.split(_sKeywords, ";");
        for (int i = 0; i < pKeywords.length; ++i) {
            pInsertArgs[2] = pKeywords[i].trim();
            pInsertArgs[3] = new Integer(i + 1);
            pInsertArgs[4] = iSiteId;
            dbMgr.sqlExecuteUpdate(new String[]{sInsertSQL}, pInsertArgs);
        }
    }

    @Override
    public void updateDocKeywords(Document _document, String _sOldKeywords, String _sNewKeywords) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return;
        }
        if (_sOldKeywords == null) {
            if (_sNewKeywords == null) {
                return;
            }
        } else {
            if (_sOldKeywords.equals(_sNewKeywords)) {
                return;
            }
            if (_sOldKeywords.length() > 0) {
                this.removeDocKeywords(_document);
            }
        }
        this.putKeywords(_document, _sNewKeywords);
    }

    @Override
    public void removeDocKeywords(Document _document) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return;
        }
        String sDeleteDocKeywordsSQL = "delete from WCMDOCKEYWORD where DocId=?";
        DBManager dbMgr = DBManager.getDBManager();
        dbMgr.sqlExecuteUpdate(new String[]{"delete from WCMDOCKEYWORD where DocId=?"}, new int[]{_document.getId()});
    }

    @Override
    public Documents getRelatedDocumentsByKeywords(Document _document, int _nMaxSize, String _sSelectFields, int[] _pFilterStatusId, boolean _bMultiSite, ArrayList _arExistDocumentTitles, boolean bRemoveRepeatTitle) throws WCMException {
        Channel docChannel;
        ArrayList<String> arExistDocumentTitles;
        if (GET_FROM_TRSSERVER) {
            WCMFilter filter = new WCMFilter();
            filter.setSelect(_sSelectFields);
            filter.setPageSize(_nMaxSize);
            return this.getAllRelatedDocumentsByKeywordsFromTRSServer(_document.getKeywords(), filter, 1);
        }
        User currUser = User.getSystem();
        Documents relDocuments = new Documents(currUser);
        int nMaxSize = _nMaxSize;
        if (nMaxSize <= 0) {
            nMaxSize = 100;
        }
        if ((arExistDocumentTitles = _arExistDocumentTitles) == null) {
            arExistDocumentTitles = new ArrayList<String>(nMaxSize);
        }
        arExistDocumentTitles.add(_document.getTitle().trim());
        String sKeywords = _document.getKeywords();
        if (sKeywords == null || (sKeywords = sKeywords.trim()).length() <= 0) {
            return relDocuments;
        }
        StringBuffer sbWhere = new StringBuffer("DocKeyword=?");
        if (!_bMultiSite && (docChannel = _document.getChannel()) != null) {
            sbWhere.append(" AND SiteId=").append(docChannel.getSiteId());
        }
        if (_sSelectFields != null) {
            _sSelectFields = _sSelectFields.replaceAll("WCMDocument.DOCID", "DOCID");
        }
        WCMFilter filter = new WCMFilter("WCMDocKeyword", sbWhere.toString(), "DocKeywordOrder, DocCrTime desc", _sSelectFields);
        filter.setMaxRowNumber(nMaxSize + 30);
        String[] pKeywords = CMyString.split(sKeywords, ";");
        for (int i = 0; i < pKeywords.length; ++i) {
            filter.addSearchValues(0, pKeywords[i]);
            DebugTimer timer = new DebugTimer();
            timer.start();
            Documents documents = Documents.openWCMObjs(currUser, filter);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u4ece\u6570\u636e\u5e93\u4e2d\u67e5\u8be2\u5230\u8bb0\u5f55\u603b\u6570\u4e3a\uff1a" + documents.size()));
            }
            documents.remove(_document.getId(), false);
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("query reldocuments of [DocId=" + _document.getId() + "] by keyword[" + pKeywords[i] + "] Info:"));
                logger.debug((Object)("use [" + timer.getTime() + "]ms!"));
                logger.debug((Object)("size=[" + documents.size() + "]!"));
                logger.debug((Object)filter);
            }
            timer.start();
            int nSize = documents.size();
            documents.setPageSize(nSize);
            documents.setMaxBufferSize(nSize);
            for (int j = nSize - 1; j >= 0; --j) {
                Document document = (Document)documents.getAt(j);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5f00\u59cb\u904d\u5386\u76f8\u5173\u6587\u6863:" + j));
                }
                boolean bGetElementByDatabase = false;
                if (document == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"\u4ece\u96c6\u5408\u4e2d\u83b7\u53d6\uff08documents.getAt(j)\uff09\u5230\u7684\u5143\u7d20\u4e3anull\uff0c\u5c06\u6839\u636e\u6587\u6863id=documents.getIdAt(j)\u53bb\u6570\u636e\u5e93\u4e2d\u67e5\u8be2");
                    }
                    int nDocId = -1;
                    try {
                        nDocId = documents.getIdAt(j);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nDocId == -1) {
                        documents.removeAt(j, false);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"\u8be5\u6761\u8bb0\u5f55\u4e0d\u5408\u6cd5\uff1a\u6ca1\u6709\u4e3b\u952eid\u503c.");
                        continue;
                    }
                    document = Document.findById(nDocId);
                    if (document == null) {
                        documents.removeAt(j, false);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("\u8be5\u6761\u8bb0\u5f55\u4e0d\u5408\u6cd5\uff1a\u76f8\u5173\u6587\u6863\u5bf9\u8c61\u4e3anull[docid=" + nDocId + "]"));
                        continue;
                    }
                    bGetElementByDatabase = true;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u5f53\u524d\u76f8\u5173\u6587\u6863[docid=" + document.getId() + "]\u6807\u9898\u4e3a\uff1a[" + document.getTitle() + "]"));
                }
                if (!this.isInRange(document.getStatusId(), _pFilterStatusId)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\u8be5\u6761\u8bb0\u5f55\u4e0d\u5408\u6cd5\uff1a\u5f53\u524d\u76f8\u5173\u6587\u6863\u5bf9\u8c61\u72b6\u6001\u503c[statusId=" + document.getStatusId() + "]\u4e0d\u5728\u6307\u5b9a\u8303\u56f4\u5185:" + _pFilterStatusId));
                    }
                    documents.removeAt(j, false);
                    continue;
                }
                if (document.getPropertyAsInt("DocChannel", 0) <= 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\u8be5\u6761\u8bb0\u5f55\u4e0d\u5408\u6cd5\uff1a\u5f53\u524d\u76f8\u5173\u6587\u6863\u5bf9\u8c61\u7684DocChannel\u5b57\u6bb5\u503c[" + document.getPropertyAsInt("DocChannel", -1) + "]\u5c0f\u4e8e0"));
                    }
                    documents.removeAt(j, false);
                    continue;
                }
                if (bRemoveRepeatTitle) {
                    String sTitle = document.getTitle().trim();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(j + ":" + sTitle));
                    }
                    if (arExistDocumentTitles.contains(sTitle)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"already exists!");
                        }
                        documents.removeAt(j, false);
                        continue;
                    }
                    arExistDocumentTitles.add(sTitle);
                }
                if (!bGetElementByDatabase) continue;
                documents.removeAt(j, false);
                documents.addElement(document);
            }
            timer.stop();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("filter reldocuments by keyword[" + pKeywords[i] + "] Info:"));
                logger.debug((Object)("use [" + timer.getTime() + "]ms!"));
                logger.debug((Object)("\u8fc7\u6ee4\u540e\u5f97\u5230\u7684\u6709\u6548\u6587\u6863\u6570\u4e3a\uff1a" + documents.size()));
            }
            if (documents.isEmpty()) continue;
            relDocuments.setMaxBufferSize(relDocuments.size() + documents.size());
            relDocuments.addWith(documents);
            if (relDocuments.size() >= nMaxSize) break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u83b7\u53d6\u5230\u7684\u6709\u6548\u76f8\u5173\u6587\u6863\u603b\u6570\u4e3a:" + relDocuments.size()));
        }
        return relDocuments;
    }

    @Override
    public Documents getAllRelatedDocumentsByKeywords(String _sKeywords, int _nExcludeDocId, WCMFilter _filter) throws WCMException {
        if (GET_FROM_TRSSERVER) {
            return this.getAllRelatedDocumentsByKeywordsFromTRSServer(_sKeywords, _filter, 1);
        }
        User currUser = User.getSystem();
        Documents relDocuments = new Documents(currUser);
        String sKeywords = _sKeywords;
        if (sKeywords == null || (sKeywords = sKeywords.trim()).length() <= 0) {
            return relDocuments;
        }
        String[] pKeywords = CMyString.split(sKeywords, ";");
        WCMFilter filter = new WCMFilter("", "", "DOCID desc");
        StringBuffer sbDocKeywordWhere = new StringBuffer(10 + pKeywords.length * 42);
        sbDocKeywordWhere.append(" (WCMDocKeyword.DOCKEYWORD=?");
        filter.addSearchValues(pKeywords[0]);
        for (int i = 1; i < pKeywords.length; ++i) {
            pKeywords[i] = pKeywords[i].trim();
            if (pKeywords[i].length() <= 0) continue;
            sbDocKeywordWhere.append(" OR WCMDocKeyword.DOCKEYWORD=?");
            filter.addSearchValues(pKeywords[i]);
        }
        sbDocKeywordWhere.append(")");
        String sWhere = "DocChannel>0 and DocStatus>=0 and exists(select DocId from WCMDocKeyword where WCMDocument.DOCID=WCMDocKeyword.DOCID and " + sbDocKeywordWhere.toString() + ")";
        filter.setWhere(sWhere);
        filter.mergeWith(_filter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"=====The filter of get reldocuments======");
            logger.debug((Object)filter);
        }
        Documents documents = Documents.openWCMObjs(currUser, filter);
        documents.remove(_nExcludeDocId, false);
        return documents;
    }

    public Documents getAllRelatedDocumentsByKeywordsFromTRSServer(String _sKeywords, WCMFilter _filter, int _nPageIndex) throws WCMException {
        if (CMyString.isEmpty(_sKeywords)) {
            return new Documents(null);
        }
        int nPageSize = _filter.getPageSize();
        if (nPageSize <= 0) {
            nPageSize = 20;
        }
        int nCurrPage = _nPageIndex;
        TRSConnection.setCharset((int)3, (boolean)false);
        DocsFromTRSServer aDocsFromTRSServer = (DocsFromTRSServer)DreamFactory.createObjectById("DocsFromTRSServer");
        TRSToWCMFilter filter = new TRSToWCMFilter();
        filter.setIDFieldName(DocsFromTRSServer.getTRSDocIdDBName());
        String sTRSSelectFields = null;
        String sWCMSelectFields = _filter.getSelect();
        if (CMyString.isEmpty(sWCMSelectFields)) {
            sWCMSelectFields = "docid,doctitle,docchannel,docauthor,crtime,cruser,docstatus,doctype,dockeywords,docsource,docreltime,docpuburl";
            sTRSSelectFields = DocsFromTRSServer.getTRSDocIdDBName() + ",doctitle,docchannel,docauthor,crtime,cruser,docstatus,doctype,dockeywords,docsource,docreltime,docpuburl";
        } else {
            sTRSSelectFields = CMyString.replaceStr(sWCMSelectFields.toUpperCase(), "DOCID", DocsFromTRSServer.getTRSDocIdDBName());
        }
        filter.setTRSFrom(DocsFromTRSServer.getTRSDocDBName());
        filter.setSelect(sWCMSelectFields, sTRSSelectFields);
        _sKeywords = _sKeywords.replaceAll("[,\uff1b\uff0c\\s]", ";");
        String[] pKeywords = _sKeywords.split(";");
        StringBuffer sbKeywords = new StringBuffer();
        for (int i = 0; i < pKeywords.length; ++i) {
            if (CMyString.isEmpty(pKeywords[i])) continue;
            sbKeywords.append(pKeywords[i]);
            sbKeywords.append(" or ");
        }
        sbKeywords.setLength(sbKeywords.length() - 4);
        filter.setTRSWhere(sbKeywords.toString());
        filter.setDefaultCols("DocKeywords");
        filter.setTRSOrder("-publishdate");
        DebugTimer timer = new DebugTimer();
        timer.start();
        Documents documents = aDocsFromTRSServer.openDocs(null, filter, nCurrPage, nPageSize);
        timer.stop();
        logger.debug((Object)("documents.size():" + documents.size() + " use [" + timer.getTime() + "]ms!"));
        return documents;
    }

    private boolean isInRange(int _nValue, int[] _pRange) {
        if (_pRange == null || _pRange.length == 0) {
            return true;
        }
        for (int i = 0; i < _pRange.length; ++i) {
            if (_nValue != _pRange[i]) continue;
            return true;
        }
        return false;
    }
}

