/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.DocumentSyn;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ChnlSynWorker
extends BaseStatefulScheduleWorker {
    private static Logger s_logger = Logger.getLogger(ChnlSynWorker.class);
    public static boolean NEW_MODE = false;
    public static boolean STOP_MODE = true;
    private static DocumentMgr currDocumentMgr = null;

    private void assertNotNull(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null) {
            throw new WCMException(10, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label1", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    private DocumentMgr getDocumentMgr() {
        if (currDocumentMgr != null) {
            return currDocumentMgr;
        }
        currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return currDocumentMgr;
    }

    private ChannelSyns getChannelSyns() throws WCMException {
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("SDATE<=");
        sbWhere.append(this.getDBManager().getDBType().sqlDateTime(CMyDateTime.now().toString("yyyy-MM-dd") + " 23:59:59", "YYYY-MM-DD HH24:MI:SS"));
        sbWhere.append(" AND EDATE>=");
        sbWhere.append(this.getDBManager().getDBType().sqlDateTime(CMyDateTime.now().toString("yyyy-MM-dd") + " 00:00:00", "YYYY-MM-DD HH24:MI:SS"));
        WCMFilter filter = new WCMFilter("", sbWhere.toString(), "CHANNELSYNID DESC");
        return ChannelSyns.openWCMObjs(User.getSystem(), filter);
    }

    private Documents getDocuments(ChannelSyn _currSyn) throws WCMException {
        boolean bInEIP;
        this.assertNotNull(_currSyn);
        Channel srcChannel = _currSyn.getSrcChannel();
        if (srcChannel == null) {
            return new Documents(User.getSystem());
        }
        String sDocStatuses = _currSyn.getStatusIds();
        String sExtraSql = _currSyn.getWhereSql();
        if (!CMyString.isEmpty(sExtraSql)) {
            if (sExtraSql.toUpperCase().indexOf("WCMCHNLDOC") != -1) {
                s_logger.warn((Object)("Unsupported extra include wcmchnldoc: " + sExtraSql));
            }
            return null;
        }
        CMyDateTime docCrSTime = _currSyn.getDocStartTime();
        CMyDateTime docCrETime = _currSyn.getDocEndTime();
        try {
            docCrETime.setTimeWithString("23:59:59", 0);
        }
        catch (CMyException e) {
            s_logger.error((Object)"failed to auto transmit documents caused by:\n", (Throwable)e);
        }
        String sWhere = "DocChannel=? and CrTime>=? and CrTime<=?";
        boolean bl = bInEIP = this.getDBManager().getFieldInfo("WCMDOCUMENT", "DOCPARENTID") != null;
        if (bInEIP) {
            sWhere = sWhere + "  and DOCPARENTID<=0";
        }
        if (sDocStatuses != null && sDocStatuses.trim().length() > 0) {
            sWhere = sWhere + " AND DOCSTATUS IN (" + sDocStatuses + ")";
        }
        if (sExtraSql != null && sExtraSql.trim().length() > 0) {
            sWhere = sWhere + " AND (" + sExtraSql + ")";
        }
        sWhere = sWhere + " and not exists(select 1 from WCMDOCSYN where WCMDOCSYN.ChnlId=? and WCMDOCSYN.DocId=WCMDocument.DocId)";
        WCMFilter filter = new WCMFilter("", sWhere, "DocId asc");
        filter.addSearchValues(0, _currSyn.getSrcChannelId());
        filter.addSearchValues(1, docCrSTime);
        filter.addSearchValues(2, docCrETime);
        filter.addSearchValues(3, _currSyn.getToChannelId());
        int nMaxCount = 200;
        filter.setMaxRowNumber(nMaxCount);
        filter.setPageSize(nMaxCount);
        Documents documents = new Documents(null);
        documents.setMaxBufferSize(nMaxCount);
        documents.setMaxSize(nMaxCount);
        documents.open(filter);
        return documents;
    }

    @Override
    protected void execute() {
        try {
            if (!STOP_MODE) {
                this.autoTransmit();
            }
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label2", "\u81ea\u52a8\u5206\u53d1\u4efb\u52a1\u6267\u884c\u5931\u8d25!"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transmitDocument(ChannelSyn _chnlsyn) throws WCMException {
        if (_chnlsyn == null) {
            return;
        }
        Channel target = _chnlsyn.getToChannel();
        Documents documents = this.getDocuments(_chnlsyn);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("docsyn:from[" + _chnlsyn.getSrcChannel() + "] to [" + target + "],docs=" + documents.size()));
        }
        if (target == null || documents == null || documents.isEmpty()) {
            return;
        }
        int nType = _chnlsyn.getTransmitType();
        switch (nType) {
            case 1: {
                Channel source = _chnlsyn.getSrcChannel();
                if (source == null) break;
                this.syncCopy(documents, source, target);
                break;
            }
            case 2: {
                this.syncQuote(documents, target);
                break;
            }
            case 3: {
                this.syncMirror(documents, target);
                break;
            }
            default: {
                s_logger.error((Object)("auto transmit documents failed,caused by invalid transmit type[" + nType + "]!"));
            }
        }
        try {
            this.recordTransmited(target.getId(), documents.getIdListAsString());
        }
        finally {
            documents.clear();
        }
    }

    private void syncCopy(Documents _documents, Channel _source, Channel _target) throws WCMException {
        DocumentMgr manager = this.getDocumentMgr();
        AppendixMgr appendixManager = this.getAppendixManager();
        RelationMgr relationManager = this.getRelationManager();
        Document newDoc = null;
        if (_target.getType() == 0 || _target.getType() == 13) {
            int len;
            Document document = null;
            int[] failedid = new int[_documents.size()];
            int size = _documents.size();
            for (int i = 0; i < size; ++i) {
                document = (Document)_documents.getAt(i);
                if (document == null) continue;
                try {
                    newDoc = manager.copyDocument(document, _source, _target);
                    if (newDoc == null || newDoc.getId() == document.getId()) continue;
                    appendixManager.copyAppendixes(document, newDoc);
                    relationManager.copyRelations(document, newDoc);
                    continue;
                }
                catch (WCMException e) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"syncopy failed", (Throwable)e);
                    }
                    failedid[i] = document.getId();
                }
            }
            Arrays.sort(failedid);
            boolean zZeroId = false;
            for (int i = len = failedid.length - 1; i >= 0 && !zZeroId; --i) {
                _documents.remove(failedid[i], false);
                zZeroId = failedid[i] == 0;
            }
        } else {
            this.syncQuote(_documents, _target);
        }
    }

    private RelationMgr getRelationManager() {
        return (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    }

    private AppendixMgr getAppendixManager() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    private void syncQuote(Documents _documents, Channel _target) throws WCMException {
        DocumentMgr manager = this.getDocumentMgr();
        Document document = null;
        int size = _documents.size();
        for (int i = 0; i < size; ++i) {
            document = (Document)_documents.getAt(i);
            if (document == null) continue;
            manager.quoteTo(document, _target);
        }
    }

    private void syncMirror(Documents _documents, Channel _target) throws WCMException {
        DocumentMgr manager = this.getDocumentMgr();
        Document document = null;
        int size = _documents.size();
        for (int i = 0; i < size; ++i) {
            document = (Document)_documents.getAt(i);
            if (document == null) continue;
            manager.mirrorTo(document, _target);
        }
    }

    private void recordTransmited(int _nTargetChannelId, String _sTransmitedDocumentIds) throws WCMException {
        int[] arryIds = CMyString.splitToInt(_sTransmitedDocumentIds, ",");
        DocumentSyn docsyn = null;
        int len = arryIds.length;
        for (int i = 0; i < len; ++i) {
            docsyn = new DocumentSyn();
            docsyn.setChannelId(_nTargetChannelId);
            docsyn.setDocumentId(arryIds[i]);
            docsyn.insert();
        }
    }

    private void autoTransmit() throws WCMException {
        ChannelSyns currChnlSyns;
        ContextHelper.initContext(User.getSystem());
        if (NEW_MODE) {
            this.transmitDocumentForTriggerMode();
        }
        if ((currChnlSyns = this.getChannelSyns()).isEmpty()) {
            return;
        }
        ChannelSyn currChnlSyn = null;
        int size = currChnlSyns.size();
        for (int i = 0; i < size; ++i) {
            currChnlSyn = (ChannelSyn)currChnlSyns.getAt(i);
            if (currChnlSyn == null) continue;
            try {
                this.transmitDocument(currChnlSyn);
                continue;
            }
            catch (Exception e) {
                s_logger.error((Object)("failed to trsansmit documents from[" + currChnlSyn.getSrcChannel() + "] to [" + currChnlSyn.getToChannel() + "]!"), (Throwable)e);
            }
        }
        currChnlSyns.clear();
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label3", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label4", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    private void transmitDocumentForTriggerMode() throws WCMException {
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String sQuerySynDocBak = "select recid,srcchnlid,tochnlid,docid,modal from wcmchnldocsynbak order by recid asc";
            String sDeleteSynDocBak = "delete from wcmchnldocsynbak where recid=?";
            String[] sDeleteSynDocBaks = new String[]{sDeleteSynDocBak};
            connection = DBManager.getDBManager().getConnection();
            pstmt = connection.prepareStatement(sQuerySynDocBak);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int nRecId = rs.getInt("recid");
                int nToChnlId = rs.getInt("tochnlid");
                int nSrcChnlId = rs.getInt("srcchnlid");
                int nDocId = rs.getInt("docid");
                int nModal = rs.getInt("modal");
                Document currDocument = Document.findById(nDocId);
                if (currDocument == null) {
                    DBManager.getDBManager().sqlExecuteUpdate(sDeleteSynDocBaks, new int[]{nRecId});
                    throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label5", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25currDocument[") + nDocId + "] is null");
                }
                Channel srcChannel = Channel.findById(nSrcChnlId);
                if (srcChannel == null) {
                    DBManager.getDBManager().sqlExecuteUpdate(sDeleteSynDocBaks, new int[]{nRecId});
                    throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label6", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25srcChannel[") + nSrcChnlId + "] is null");
                }
                Channel toChannel = Channel.findById(nToChnlId);
                if (toChannel == null) {
                    DBManager.getDBManager().sqlExecuteUpdate(sDeleteSynDocBaks, new int[]{nRecId});
                    throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label7", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25toChannel[") + nToChnlId + "] is null");
                }
                Report report = null;
                DocumentMgr manager = this.getDocumentMgr();
                switch (nModal) {
                    case 1: {
                        this.synCopy(srcChannel, toChannel, currDocument);
                        break;
                    }
                    case 2: {
                        report = manager.quoteTo(currDocument, toChannel);
                        break;
                    }
                    case 3: {
                        report = manager.mirrorTo(currDocument, toChannel);
                        break;
                    }
                    default: {
                        s_logger.error((Object)("auto transmit document failed,caused by invalid transmit type[" + nModal + "]!"));
                    }
                }
                if (report != null) {
                    switch (report.getType()) {
                        case 5: {
                            s_logger.error((Object)(I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label8", "\u5206\u53d1\u6587\u6863[") + currDocument + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label9", "]\u5230[") + toChannel + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label10", "]\u7684\u65f6\u5019\u5b58\u5728\u9519\u8bef\uff01\n") + report));
                            break;
                        }
                        case 4: {
                            s_logger.error((Object)(I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label8", "\u5206\u53d1\u6587\u6863[") + currDocument + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label9", "]\u5230[") + toChannel + I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label11", "]\u7684\u65f6\u5019\u5b58\u5728\u8b66\u544a\uff01\n") + report));
                            break;
                        }
                    }
                }
                DBManager.getDBManager().sqlExecuteUpdate(sDeleteSynDocBaks, new int[]{nRecId});
            }
        }
        catch (WCMException eWCM) {
            throw eWCM;
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(ChnlSynWorker.class, "ChnlSynWorker.label12", "\u5229\u7528\u89e6\u53d1\u5668\u7684\u4e2d\u95f4\u7ed3\u679c\u8fdb\u884c\u81ea\u52a8\u5206\u53d1\u5931\u8d25"), ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                    connection = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private void synCopy(Channel _source, Channel _target, Document document) throws WCMException {
        DocumentMgr manager = this.getDocumentMgr();
        AppendixMgr appendixManager = this.getAppendixManager();
        RelationMgr relationManager = this.getRelationManager();
        Document newDoc = manager.copyDocument(document, _source, _target);
        if (newDoc != null && newDoc.getId() != document.getId()) {
            appendixManager.copyAppendixes(document, newDoc);
            relationManager.copyRelations(document, newDoc);
        }
    }
}

