/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.auth;

import com.trs.cms.auth.domain.IRightObj;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.auth.ChannelAuthHelper;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;

public class ChannelRightObjImpl
implements IRightObj {
    private Channel m_oChannel = null;

    @Override
    public boolean hasRight(User _currUser, int _nRightIndex) throws WCMException {
        if (_nRightIndex == -1) {
            return true;
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        String isPermitView = ConfigServer.getServer().getSysConfigValue("CREATER_CAN_SEE_OWN_CHANNEL", "true");
        if (isPermitView.equalsIgnoreCase("true") && _currUser.getName().equalsIgnoreCase(this.m_oChannel.getCrUserName())) {
            return true;
        }
        return ChannelAuthHelper.hasRight(_currUser, this.m_oChannel, _nRightIndex);
    }

    @Override
    public int getId() {
        return this.m_oChannel == null ? 0 : this.m_oChannel.getId();
    }

    @Override
    public String getInfo() {
        if (this.m_oChannel == null) {
            return null;
        }
        return this.m_oChannel.toString();
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_oChannel;
    }

    @Override
    public int getType() {
        return 101;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_oChannel = Channel.findById(_nId);
        return true;
    }

    @Override
    public void makeFrom(CMSObj _oObj) throws WCMException {
        this.m_oChannel = (Channel)_oObj;
    }

    @Override
    public void setSubstance(CMSObj _oObj) {
        this.m_oChannel = (Channel)_oObj;
    }
}

