/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.DreamFactory;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.AbstractXmlToObjConverter;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public class AdvisorXmlToObjConverter
extends AbstractXmlToObjConverter {
    ChannelMgr m_oChannelMgr;
    private WebSite m_oSite;
    private Channel m_oChannel;

    public AdvisorXmlToObjConverter(int _nImportType, Channel oCurrChannel) throws WCMException {
        super(_nImportType);
        this.m_oChannel = oCurrChannel;
        this.m_oSite = oCurrChannel.getSite();
        this.m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        this.registPersistentObj("XWCMADVISOR", Advisor.class);
        this.registPersistentObj("XWCMSTEP", Step.class);
        this.registPersistentObj("XWCMOPTIONGROUP", OptionGroup.class);
        this.registPersistentObj("XWCMOPTION", Option.class);
    }

    @Override
    protected Map processSpecialProperties(Element propertiesEl) throws WCMException {
        HashMap<String, Integer> specialValue = new HashMap<String, Integer>(1);
        Element element = propertiesEl.element("CHANNELID");
        if (element == null) {
            return specialValue;
        }
        String sChnlName = element.attributeValue("ChnlName");
        if (CMyString.isEmpty(sChnlName)) {
            specialValue.put("CHANNELID", new Integer(this.m_oChannel.getId()));
            return specialValue;
        }
        Channel channel = this.m_oChannelMgr.getChannelByName(this.m_oSite.getId(), sChnlName);
        if (channel == null) {
            specialValue.put("CHANNELID", new Integer(this.m_oChannel.getId()));
            return specialValue;
        }
        specialValue.put("CHANNELID", new Integer(channel.getId()));
        return specialValue;
    }
}

