/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.Advisors;
import com.trs.components.wcm.advisor.Option;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.components.wcm.advisor.OptionGroups;
import com.trs.components.wcm.advisor.Options;
import com.trs.components.wcm.advisor.Step;
import com.trs.components.wcm.advisor.Steps;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdvisorMgr {
    private static Logger logger = Logger.getLogger(AdvisorMgr.class);
    private Map m_mOptionIdMapping;

    public Advisors queryByChannel(Channel _channel, WCMFilter _filter) throws WCMException {
        if (_channel == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label1", "\u680f\u76ee\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u987e\u95ee\u6570\u636e\uff01"));
        }
        User oLoginUser = this.getLoginUser();
        boolean bHasViewRight = AuthServer.hasRight(oLoginUser, (CMSObj)_channel, 14);
        if (!bHasViewRight) {
            throw new WCMException(CMyString.format(I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[{0}]\u4e0b\u7684\u987e\u95ee\uff01"), new String[]{_channel.getDesc()}));
        }
        WCMFilter filter = new WCMFilter("", "ChannelId=?", "");
        filter.addSearchValues(_channel.getId());
        filter.mergeWith(_filter);
        return Advisors.openWCMObjs(oLoginUser, filter);
    }

    public Steps queryStepsByAdvisor(Advisor _advisor, WCMFilter _filter) throws WCMException {
        if (_advisor == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label3", "\u987e\u95ee\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u6b65\u9aa4\uff01"));
        }
        int nAdvisorId = _advisor.getId();
        WCMFilter filter = new WCMFilter("", "ADVISORID=?", "AORDER ASC");
        filter.addSearchValues(nAdvisorId);
        filter.mergeWith(_filter);
        return Steps.openWCMObjs(null, filter);
    }

    public OptionGroups queryOptionGroupsByStep(Step _step, WCMFilter _filter) throws WCMException {
        if (_step == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label4", "\u987e\u95ee\u6b65\u9aa4\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u9009\u9879\u7ec4\uff01"));
        }
        int nStepId = _step.getId();
        WCMFilter filter = new WCMFilter("", "STEPID=?", "AORDER ASC");
        filter.addSearchValues(nStepId);
        filter.mergeWith(_filter);
        return OptionGroups.openWCMObjs(null, filter);
    }

    public Options queryOptionsByOptionGroup(OptionGroup _optionGroup, WCMFilter _filter) throws WCMException {
        if (_optionGroup == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label5", "\u987e\u95ee\u6b65\u9aa4\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u9009\u9879\u7ec4\uff01"));
        }
        int nOptionGroupId = _optionGroup.getId();
        WCMFilter filter = new WCMFilter("", "GROUPID=?", "AORDER ASC");
        filter.addSearchValues(nOptionGroupId);
        filter.mergeWith(_filter);
        return Options.openWCMObjs(null, filter);
    }

    public Options queryOptionsByAdvisor(Advisor advisor, WCMFilter _filter) throws WCMException {
        String sWhere = "EXISTS(SELECT 1 FROM XWCMOPTIONGROUP WHERE XWCMOPTIONGROUP.OPTIONGROUPID = XWCMOPTION.GROUPID AND EXISTS(SELECT 1 FROM XWCMSTEP WHERE XWCMSTEP.STEPID = XWCMOPTIONGROUP.STEPID AND EXISTS(SELECT 1 FROM XWCMADVISOR WHERE XWCMADVISOR.ADVISORID = ? AND XWCMADVISOR.ADVISORID = XWCMSTEP.ADVISORID)))";
        WCMFilter filter = new WCMFilter("", sWhere, "AORDER ASC");
        filter.addSearchValues(advisor.getId());
        filter.mergeWith(_filter);
        return Options.openWCMObjs(null, filter);
    }

    public void deleteAdvisor(Advisor _advisor) throws WCMException {
        if (_advisor == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label6", "\u5f85\u5220\u9664\u7684\u987e\u95ee\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Steps steps = this.queryStepsByAdvisor(_advisor, null);
        for (int i = steps.size() - 1; i >= 0; --i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            this.deleteStep(step);
        }
        _advisor.delete();
    }

    public void deleteStep(Step _step) throws WCMException {
        if (_step == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label7", "\u5f85\u5220\u9664\u7684\u6b65\u9aa4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        OptionGroups groups = this.queryOptionGroupsByStep(_step, null);
        for (int i = groups.size() - 1; i >= 0; --i) {
            OptionGroup optionGroup = (OptionGroup)groups.getAt(i);
            if (optionGroup == null) continue;
            this.deleteOptionGroup(optionGroup);
        }
        _step.delete();
    }

    public void deleteOptionGroup(OptionGroup _optionGroup) throws WCMException {
        if (_optionGroup == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label8", "\u5f85\u5220\u9664\u7684\u9009\u9879\u7ec4\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Options options = this.queryOptionsByOptionGroup(_optionGroup, null);
        for (int i = options.size() - 1; i >= 0; --i) {
            Option option = (Option)options.getAt(i);
            if (option == null) continue;
            this.deleteOption(option);
        }
        _optionGroup.delete();
    }

    public void deleteOption(Option _option) throws WCMException {
        if (_option == null) {
            throw new WCMException(10, I18NMessage.get(AdvisorMgr.class, "AdvisorMgr.label9", "\u5f85\u5220\u9664\u7684\u9009\u9879\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        _option.delete();
    }

    public void copy(Advisor _advisor, Channels channels, User currUser) throws WCMException {
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.copy(_advisor, channel, currUser);
        }
    }

    public void copy(Advisor _advisor, Channel channel, User currUser) throws WCMException {
        this.m_mOptionIdMapping = new HashMap();
        Advisor advisor = (Advisor)_advisor.cloneToNewObj();
        advisor.setChannelId(channel.getId());
        String sAppendixFileName = advisor.getAppendixFileName();
        if (!CMyString.isEmpty(sAppendixFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sNewAppendixFileName = filesMan.copyWCMFile(sAppendixFileName, "P0");
            advisor.setAppendixFileName(sNewAppendixFileName);
        }
        advisor.save(currUser);
        Steps steps = this.queryStepsByAdvisor(_advisor, null);
        int nSize = steps.size();
        for (int i = 0; i < nSize; ++i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            this.copy(step, advisor, currUser);
        }
        this.afterAdvisorSave(advisor);
    }

    private void afterAdvisorSave(Advisor advisor) throws WCMException {
        Steps steps = this.queryStepsByAdvisor(advisor, null);
        int nSize = steps.size();
        for (int i = 0; i < nSize; ++i) {
            Step step = (Step)steps.getAt(i);
            if (step == null) continue;
            OptionGroups groups = this.queryOptionGroupsByStep(step, null);
            int nJSize = groups.size();
            for (int j = 0; j < nJSize; ++j) {
                String sLastOptions;
                OptionGroup group = (OptionGroup)groups.getAt(j);
                if (group == null || CMyString.isEmpty(sLastOptions = group.getLastOptions())) continue;
                String sNewOptions = this.getNewOptionIds(sLastOptions);
                group.setLastOptions(sNewOptions);
                group.save(ContextHelper.getLoginUser());
            }
        }
        Options options = this.queryOptionsByAdvisor(advisor, null);
        int nSize2 = options.size();
        for (int i = 0; i < nSize2; ++i) {
            String sNotAllowOptions;
            Option option = (Option)options.getAt(i);
            if (option == null) continue;
            boolean isChange = false;
            String sLastOptions = option.getLastOptions();
            if (!CMyString.isEmpty(sLastOptions)) {
                String sNewOptions = this.getNewOptionIds(sLastOptions);
                option.setLastOptions(sNewOptions);
                isChange = true;
            }
            if (!CMyString.isEmpty(sNotAllowOptions = option.getNotAllowedSelectOptions())) {
                String sNewOptions = this.getNewOptionIds(sNotAllowOptions);
                option.setNotAllowedSelectOptions(sNewOptions);
                isChange = true;
            }
            if (!isChange) continue;
            option.save(ContextHelper.getLoginUser());
        }
    }

    private void copy(Step _step, Advisor advisor, User currUser) throws WCMException {
        Step step = (Step)_step.cloneToNewObj();
        step.setAdvisorId(advisor.getId());
        step.save(currUser);
        OptionGroups groups = this.queryOptionGroupsByStep(_step, null);
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            OptionGroup group = (OptionGroup)groups.getAt(i);
            if (group == null) continue;
            this.copy(group, step, currUser);
        }
    }

    private void copy(OptionGroup _optionGroup, Step step, User currUser) throws WCMException {
        OptionGroup optionGroup = (OptionGroup)_optionGroup.cloneToNewObj();
        optionGroup.setStepId(step.getId());
        optionGroup.save(currUser);
        Options options = this.queryOptionsByOptionGroup(_optionGroup, null);
        int nSize = options.size();
        for (int i = 0; i < nSize; ++i) {
            Option option = (Option)options.getAt(i);
            if (option == null) continue;
            this.copy(option, optionGroup, currUser);
        }
    }

    private void copy(Option _option, OptionGroup optionGroup, User currUser) throws WCMException {
        Option option = (Option)_option.cloneToNewObj();
        option.setGroupId(optionGroup.getId());
        String[] pics = new String[]{"PICTRUE"};
        for (int i = 0; i < pics.length; ++i) {
            String sPicFileName = _option.getPropertyAsString(pics[i]);
            if (CMyString.isEmpty(sPicFileName)) continue;
            FilesMan filesMan = FilesMan.getFilesMan();
            if (!filesMan.fileExists(sPicFileName)) {
                logger.error((Object)CMyString.format("\u987e\u95ee\u56fe\u7247\u65f6\u56fe\u7247\u4e0d\u5b58\u5728[{0}]", new String[]{sPicFileName}));
                continue;
            }
            String sNewFileName = filesMan.copyWCMFile(sPicFileName, "P0");
            option.setPropertyWithString(pics[i], sNewFileName);
        }
        option.save(currUser);
        this.m_mOptionIdMapping.put(_option.getKey(), option.getKey());
    }

    private String getNewOptionIds(String sOldOptionIds) {
        if (CMyString.isEmpty(sOldOptionIds)) {
            return "";
        }
        int[] oldIds = CMyString.splitToInt(sOldOptionIds, ",");
        StringBuffer sbNewIds = new StringBuffer();
        for (int i = 0; i < oldIds.length; ++i) {
            Integer oNewId = (Integer)this.m_mOptionIdMapping.get(new Integer(oldIds[i]));
            if (oNewId == null) continue;
            sbNewIds.append(oNewId).append(",");
        }
        if (sbNewIds.length() > 0) {
            sbNewIds.setLength(sbNewIds.length() - 1);
        }
        return sbNewIds.toString();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

