/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.key.CKeyUtil;
import com.trs.license.License;
import com.trs.license.LicenseException;
import com.trs.license.LicenseUtil;

public class MyDB
implements License {
    private static final String LICENSE = "license/LICENSE.trswcm";
    private int m_nMaxSiteNum = -1;

    @Override
    public int getMaxSiteNum() {
        if (this.m_nMaxSiteNum < 0) {
            this.validate();
        }
        return this.m_nMaxSiteNum;
    }

    @Override
    public int getMaxUserNum() {
        return 0;
    }

    @Override
    public int getPluginCode() {
        return 0;
    }

    @Override
    public String validate() {
        try {
            String sKeyInfo = MyDB.getProductKey();
            if (sKeyInfo.toUpperCase().indexOf("TRSWCM6.0") != 0) {
                return I18NMessage.get(MyDB.class, "MyDB.label1", "\u4e0d\u662fTRSWCM6.0\u6ce8\u518c\u7801\uff01");
            }
            String sKey = MyDB.loadLicenseFile();
            String temp = CKeyUtil.DecodeKey(sKey = LicenseUtil.decodeRadix64(sKey)).substring(12, 14);
            int nMaxSiteNum = CKeyUtil.getKeyNum(temp);
            if (nMaxSiteNum == 99) {
                return I18NMessage.get(MyDB.class, "MyDB.label2", "Platform\u7684License");
            }
            this.m_nMaxSiteNum = nMaxSiteNum;
        }
        catch (Throwable e) {
            return "Validate Exception\uff01DB";
        }
        return null;
    }

    private static String getProductKey() {
        String sKey = MyDB.loadLicenseFile();
        String[] pKeys = (sKey = LicenseUtil.decodeRadix64(sKey)).split("-");
        if (pKeys.length <= 6) {
            throw new Error(I18NMessage.get(MyDB.class, "MyDB.label3", "\u4e0d\u662f\u6700\u65b0\u7684\u6ce8\u518c\u7801\uff01"));
        }
        return pKeys[6];
    }

    private static String loadLicenseFile() {
        String sLicenseContent = "";
        Class<MyDB> clazz = MyDB.class;
        String filename = clazz.getClassLoader().getResource(LICENSE).getFile();
        try {
            sLicenseContent = CMyFile.readFile(filename).trim();
        }
        catch (CMyException e) {
            int nErrNumber = e.getErrNo();
            if (55 == nErrNumber) {
                throw new LicenseException(I18NMessage.get(MyDB.class, "MyDB.label4", "\u975e\u6cd5\u4f7f\u7528!\u6ca1\u6709\u627e\u5230\u5408\u6cd5\u7684License."));
            }
            throw new LicenseException(I18NMessage.get(MyDB.class, "MyDB.label5", "\u7cfb\u7edf\u542f\u52a8\u5f02\u5e38!\u6821\u9a8c\u4f7f\u7528\u8bb8\u53ef\u5931\u8d25"));
        }
        String decodeContent = LicenseUtil.decodeRadix64(sLicenseContent);
        return decodeContent;
    }
}

