/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DocstatHandler4SiteOfUser;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DocstatHandler4ChannelOfUser
extends BaseStatHandler {
    private int nCrUserIndex = -1;
    private String sUserName = "";
    private boolean isAdmin = false;
    private boolean asAdmin = false;
    User user = null;

    public DocstatHandler4ChannelOfUser(String _sCrUser) throws WCMException {
        this.sUserName = _sCrUser;
        this.user = User.findByName(this.sUserName);
        Groups groups = this.user.getGroups();
        for (int i = 0; i < groups.size(); ++i) {
            if (!AuthServer.hasRight(this.user, (CMSObj)((Group)groups.getAt(i)), 13)) continue;
            this.isAdmin = true;
            this.asAdmin = true;
            break;
        }
    }

    public DocstatHandler4ChannelOfUser(String _sCrUser, boolean asAdmin) throws WCMException {
        this.sUserName = _sCrUser;
        this.user = User.findByName(this.sUserName);
        this.asAdmin = asAdmin;
        if (asAdmin) {
            new DocstatHandler4SiteOfUser(_sCrUser);
        }
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int index) throws WCMException {
        int nSQLIndex = index;
        try {
            String sCrUser = "";
            sCrUser = resultSet.getString(this.nCrUserIndex);
            boolean userauth = false;
            if (this.isAdmin) {
                Groups groups = User.findByName(sCrUser).getGroups();
                for (int i = 0; i < groups.size(); ++i) {
                    if (!AuthServer.hasRight(this.user, (CMSObj)((Group)groups.getAt(i)), 13)) continue;
                    userauth = true;
                }
            } else {
                userauth = this.user.isAdministrator() && this.asAdmin ? true : this.sUserName.equalsIgnoreCase(sCrUser);
            }
            if (CMyString.isEmpty(sCrUser) || !userauth) {
                return;
            }
            int nChannelId = resultSet.getInt(2);
            int nDataCount = resultSet.getInt(1);
            String sKey = "";
            for (Channel parent = Channel.findById(nChannelId); parent != null; parent = parent.getParent()) {
                sKey = this.makeHostKey(parent, resultSet);
                int nExistDataCount = this.getValue(nSQLIndex, sKey);
                this.setValue(nSQLIndex, sKey, nExistDataCount + nDataCount);
                this.addMajorObject(parent.getId() + "");
            }
        }
        catch (SQLException e) {
            throw new WCMException(1100, "\u6309\u7167\u7528\u6237\u904d\u5386\u680f\u76ee\u7edf\u8ba1\u7ed3\u679c\u5e76\u505a\u52a0\u548c\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        super.visitStart(resultSet, nSQLIndex);
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int nColumnCount = metaData.getColumnCount();
            for (int i = 2; i <= nColumnCount; ++i) {
                if (!"CRUSER".equals(metaData.getColumnName(i).toUpperCase())) continue;
                this.nCrUserIndex = i;
                break;
            }
        }
        catch (SQLException e) {
            throw new WCMException(1100, "\u8bbe\u7f6ecruser\u7684\u7d22\u5f15\u4f4d\u7f6e\u51fa\u73b0\u9519\u8bef", e);
        }
    }

    private String makeHostKey(Channel parent, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        if (nColumnCount <= 3) {
            return this.makeKey(new String[]{String.valueOf(parent.getId())});
        }
        String[] keys = new String[nColumnCount - 2];
        keys[0] = String.valueOf(parent.getId());
        for (int i = 1; i < nColumnCount - 2; ++i) {
            keys[i] = resultSet.getString(i + 2);
        }
        return this.makeKey(keys);
    }
}

