/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.DocStatHandler4UserDept;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandler4ChnlDeptSite
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandler4UserDept.class);
    private HashMap m_hRelGroupsOfChannel = null;
    private int m_SiteId = 0;
    private IChnlDeptMgr m_oChnlDeptMgr = null;

    public DocStatHandler4ChnlDeptSite(int _nSiteId) {
        this.m_SiteId = _nSiteId;
        this.m_hRelGroupsOfChannel = new HashMap();
        this.m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            int nColumnCount = resultSet.getMetaData().getColumnCount();
            int nSiteId = resultSet.getInt(nColumnCount);
            if (nSiteId != this.m_SiteId) {
                return;
            }
            int nDataCount = resultSet.getInt(1);
            if (nDataCount == 0) {
                return;
            }
            int nChannelId = resultSet.getInt(2);
            Channel channel = Channel.findById(nChannelId);
            if (channel == null) {
                throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u680f\u76ee! [ChannelId = " + nChannelId + "]");
            }
            DebugTimer timerTemp = new DebugTimer();
            timerTemp.start();
            Groups oRelGroups = this.makeCurrRelGroups(channel);
            timerTemp.stop();
            logger.debug((Object)("makeCurrRelGroups of channel-" + nChannelId + " use[" + timerTemp.getTime() + "]ms"));
            timerTemp.start();
            int nSize = oRelGroups.size();
            for (int nRelChannelIndex = 0; nRelChannelIndex < nSize; ++nRelChannelIndex) {
                Group oRelGroup = (Group)oRelGroups.getAt(nRelChannelIndex);
                if (oRelGroup == null) continue;
                String sGroupId = oRelGroup.getId() + "";
                String oGroupKey = this.makePrivateKey(sGroupId, resultSet);
                int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                int nDataCountOfCurrGroup = nDataCount;
                this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                this.addMajorObject(sGroupId);
            }
            timerTemp.stop();
            logger.debug((Object)("merge datacount of channel-" + nChannelId + " use[" + timerTemp.getTime() + "]ms"));
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String groupKey, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        String[] sParam = new String[nColumnCount - 2];
        sParam[0] = groupKey;
        for (int i = 2; i < nColumnCount - 1; ++i) {
            sParam[i - 1] = resultSet.getString(i + 1);
        }
        return this.makeKey(sParam);
    }

    private Groups makeCurrRelGroups(Channel _oChannel) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfChannel.get(_oChannel);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        Groups groups = currUser.getGroups();
        Groups ogroups = new Groups(currUser);
        for (int i = 0; i < groups.size(); ++i) {
            Group group = (Group)groups.getAt(i);
            Users users = group.getUsers(currUser);
            User noAdminUser = null;
            for (int j = 0; j < users.size(); ++j) {
                User oUser = (User)users.getAt(j);
                if (group.isAdministrator(oUser) || oUser.isAdministrator()) continue;
                noAdminUser = (User)users.getAt(j);
                break;
            }
            if (noAdminUser == null) {
                return null;
            }
            if (currUser.isAdministrator()) {
                ogroups.addElement(group);
                continue;
            }
            if (!AuthServer.hasRight(noAdminUser, (CMSObj)_oChannel, 31)) continue;
            ogroups.addElement(group);
        }
        this.m_hRelGroupsOfChannel.put(_oChannel.getKey(), ogroups);
        return ogroups;
    }
}

