/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.web;

import com.trs.components.metadata.web.HTMLMaker;
import com.trs.components.metadata.web.impl.DefaultHTMLMaker;
import com.trs.infra.I18NMessage;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class HTMLMakerFactory {
    private static Logger mLogger = Logger.getLogger(HTMLMakerFactory.class);
    private static boolean mIsLoaded = false;
    private static Map mHTMLMakerMapping = new HashMap();

    private static void load() {
        if (mIsLoaded) {
            return;
        }
        mIsLoaded = true;
        IDiscovery discovery = WCMDiscoveryFactory.getDiscovery();
        Iterator itr = discovery.getImplementors(HTMLMaker.class.getName());
        while (itr.hasNext()) {
            String sClassName = (String)itr.next();
            try {
                Class<?> objClass = Class.forName(sClassName);
                HTMLMaker instance = (HTMLMaker)objClass.newInstance();
                int[] aFieldType = instance.getFieldTypes();
                for (int i = 0; i < aFieldType.length; ++i) {
                    HTMLMakerFactory.register(aFieldType[i], objClass);
                }
            }
            catch (Exception e) {
                mLogger.debug((Object)(I18NMessage.get(HTMLMakerFactory.class, "HTMLMakerFactory.label1", "\u52a0\u8f7dHMTLMaker\u51fa\u73b0\u9519\u8bef[") + sClassName + "]"), (Throwable)e);
            }
        }
    }

    public static void register(int nFieldType, Class objClass) {
        mHTMLMakerMapping.put(new Integer(nFieldType), objClass);
    }

    public static HTMLMaker getHTMLMaker(int nFieldType) {
        HTMLMakerFactory.load();
        Class<DefaultHTMLMaker> objClass = (Class<DefaultHTMLMaker>)mHTMLMakerMapping.get(new Integer(nFieldType));
        if (objClass == null) {
            objClass = DefaultHTMLMaker.class;
        }
        try {
            return (HTMLMaker)objClass.newInstance();
        }
        catch (Exception e) {
            mLogger.debug((Object)(I18NMessage.get(HTMLMakerFactory.class, "HTMLMakerFactory.label2", "\u521b\u5efaHTMLMaker\u51fa\u73b0\u9519\u8bef[") + objClass + "]"), (Throwable)e);
            return null;
        }
    }
}

