/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.portervisitors;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewEmployer;
import com.trs.components.metadata.center.MetaViewEmployers;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.service.portervisitors.IPorterVisitor;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverter;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ChannelPorterVisitorForMetaView
implements IPorterVisitor {
    private static Logger logger = Logger.getLogger(ChannelPorterVisitorForMetaView.class);
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");

    @Override
    public void doExport(BaseObj _baseObj, Object _extraArgs) throws Exception {
        if (!(_baseObj instanceof Channel)) {
            return;
        }
        Channel oChannel = (Channel)_baseObj;
        WCMFilter filter = new WCMFilter("", "channelid=?", "");
        filter.addSearchValues(oChannel.getId());
        MetaViewEmployers metaViewEmployers = MetaViewEmployers.openWCMObjs(filter);
        if (metaViewEmployers == null || metaViewEmployers.size() <= 0) {
            return;
        }
        int nSize = metaViewEmployers.size();
        for (int i = 0; i < nSize; ++i) {
            int nViewId;
            MetaView oView;
            MetaViewEmployer metaViewEmployer = (MetaViewEmployer)metaViewEmployers.getAt(i);
            if (metaViewEmployer == null || (oView = MetaView.findById(nViewId = metaViewEmployer.getPropertyAsInt("VIEWID", 0))) == null) continue;
            metaViewEmployer.getProperties().put("VIEWNAME", oView.getName());
        }
        Element[] elements = new Element[]{new ObjToXmlConverter().toXmlElement(metaViewEmployers, "VIEWID,CHANNELID,VIEWNAME")};
        Object[] objs = (Object[])_extraArgs;
        BaseObjToXmlConverter converter = (BaseObjToXmlConverter)objs[0];
        converter.addChildElements((Element)objs[1], elements);
    }

    @Override
    public void doImport(BaseObj _baseObj, XmlObject _xmlObj, Object _extraArgs) throws Exception {
        MetaView oMetaView;
        if (!(_baseObj instanceof Channel)) {
            return;
        }
        Channel oChannel = (Channel)_baseObj;
        XmlObject[] oMetaViewEmployers = _xmlObj.getChild("XWCMMETAVIEWEMPLOYERS");
        if (oMetaViewEmployers == null || oMetaViewEmployers.length <= 0) {
            return;
        }
        MetaViewEmployer metaViewEmployer = (MetaViewEmployer)oMetaViewEmployers[0].getCurrentObj();
        String sViewName = metaViewEmployer.getPropertyAsString("VIEWNAME");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u627e\u5230\u680f\u76ee\u5173\u8054\u7684\u89c6\u56fe\u540d\u79f0:" + sViewName));
        }
        if ((oMetaView = this.findMetaViewByName(sViewName)) == null) {
            int viewId = metaViewEmployer.getPropertyAsInt("viewId", 0);
            oMetaView = MetaView.findById(viewId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u5f53\u524d\u680f\u76ee\u5173\u8054\u7684\u89c6\u56fe\u4fe1\u606f\u4e3a:" + oMetaView));
        }
        if (oMetaView == null) {
            oChannel.setProperty("CONTENTSHOWPAGE", "");
            oChannel.setProperty("CONTENTLISTPAGE", "");
            oChannel.setProperty("CONTENTADDEDITPAGE", "");
            oChannel.save();
            return;
        }
        this.m_oMetaViewEmployerMgr.setEmployer(ContextHelper.getLoginUser(), oChannel, oMetaView);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u8bbe\u5b9a\u5b8c\u680f\u76ee\u548c\u89c6\u56fe\u7684\u7ed1\u5b9a\u5173\u7cfb.");
        }
    }

    private MetaView findMetaViewByName(String sViewName) throws WCMException {
        if (CMyString.isEmpty(sViewName)) {
            return null;
        }
        WCMFilter filter = new WCMFilter("", "ViewName=?", "", "ViewId");
        filter.addSearchValues(sViewName);
        MetaViews oViews = MetaViews.createNewInstance(ContextHelper.getLoginUser());
        oViews.open(filter);
        int nSize = oViews.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView oView = (MetaView)oViews.getAt(i);
            if (oView == null) continue;
            return oView;
        }
        return null;
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{Channel.class.getName()};
    }
}

